/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.mmoserver;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.items.impl.ItemManagerImpl;
import org.asf.edge.common.services.messages.WsMessageService;
import org.asf.edge.common.services.messages.impl.WsMessageServiceImpl;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.mmoserver.config.MMOServerConfig;
import org.asf.edge.mmoserver.events.clients.ClientConnectedEvent;
import org.asf.edge.mmoserver.events.server.MMOServerSetupEvent;
import org.asf.edge.mmoserver.events.server.MMOServerStartupEvent;
import org.asf.edge.mmoserver.networking.SmartfoxServer;
import org.asf.edge.mmoserver.networking.impl.BitswarmSmartfoxServer;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class EdgeMMOServer
implements IBaseServer {
    public static final String MMO_SERVER_VERSION = "1.0.0.A2";
    private Logger logger;
    private MMOServerConfig config;
    private SmartfoxServer server;
    private long lastRestartTime;
    private long lastShutdownTime;

    public String getVersion() {
        return MMO_SERVER_VERSION;
    }

    static void printSplash() {
        System.out.println("-------------------------------------------------------------");
        System.out.println("                                                             ");
        System.out.println("    EDGE - Fan-made server software for School of Dragons    ");
        System.out.println("                 MMO Server Version 1.0.0.A2                 ");
        System.out.println("                                                             ");
        System.out.println("-------------------------------------------------------------");
        System.out.println("");
    }

    public EdgeMMOServer(MMOServerConfig config) {
        this.config = config;
        this.logger = LogManager.getLogger((String)"MMOSERVER");
    }

    public SmartfoxServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public MMOServerConfig getConfiguration() {
        return this.config;
    }

    public void setupServer() throws IOException {
        if (this.config.server == null) {
            this.config.server = new BitswarmSmartfoxServer(this.config.listenAddress, this.config.listenPort);
            this.logger.info("Edge bitswarm MMO server created with listen address " + this.config.listenAddress + " and port " + this.config.listenPort);
        }
        this.server = this.config.server;
        this.logger.debug("Dispatching event...");
        EventBus.getInstance().dispatchEvent((EventObject)new MMOServerSetupEvent(this.config, this));
        this.logger.debug("Configuring server event handlers...");
        this.server.getEventBus().addEventHandler(ClientConnectedEvent.class, event -> event.getClient().setObject(EdgeMMOServer.class, this));
        this.logger.debug("Configuring server packet handlers...");
        this.logger.info("Setting up item manager...");
        ServiceManager.registerServiceImplementation(ItemManager.class, (AbstractService)new ItemManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(ItemManager.class);
        this.logger.info("Setting up message service...");
        ServiceManager.registerServiceImplementation(WsMessageService.class, (AbstractService)new WsMessageServiceImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(WsMessageService.class);
        this.logger.info("Loading text filter...");
        TextFilterService.getInstance();
        this.logger.info("Starting shutdown and restart watchdog...");
        CommonDataContainer cont = CommonDataManager.getInstance().getContainer("EDGECOMMON");
        try {
            if (!cont.entryExists("shutdown")) {
                this.lastShutdownTime = System.currentTimeMillis();
                cont.setEntry("shutdown", (JsonElement)new JsonPrimitive((Number)this.lastShutdownTime));
            } else {
                this.lastShutdownTime = cont.getEntry("shutdown").getAsLong();
            }
            if (!cont.entryExists("restart")) {
                this.lastRestartTime = System.currentTimeMillis();
                cont.setEntry("restart", (JsonElement)new JsonPrimitive((Number)this.lastRestartTime));
            } else {
                this.lastRestartTime = cont.getEntry("restart").getAsLong();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AsyncTaskManager.runAsync(() -> {
            while (true) {
                try {
                    long shutdown = cont.getEntry("shutdown").getAsLong();
                    if (shutdown > this.lastShutdownTime && this.isRunning()) {
                        this.stopServer();
                        break;
                    }
                    long restart = cont.getEntry("restart").getAsLong();
                    if (restart > this.lastRestartTime && this.isRunning()) {
                        CommonInit.restartPending = true;
                        this.stopServer();
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    public void startServer() throws IOException {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (this.server.isRunning()) {
            throw new IllegalArgumentException("Server is already running");
        }
        this.logger.info("Starting the MMO server...");
        this.server.start();
        EventBus.getInstance().dispatchEvent((EventObject)new MMOServerStartupEvent(this.config, this));
        this.logger.info("MMO server started successfully!");
    }

    public void stopServer() {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (!this.server.isRunning()) {
            throw new IllegalArgumentException("Server is not running");
        }
        this.logger.info("Shutting down the MMO server...");
        try {
            this.server.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("MMO server stopped successfully!");
    }

    public void killServer() {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (!this.server.isRunning()) {
            throw new IllegalArgumentException("Server is not running");
        }
        this.logger.info("Forcefully shutting down the MMO server!");
        try {
            this.server.stopForced();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("MMO server stopped successfully!");
    }

    public boolean isRunning() {
        if (this.server == null) {
            return false;
        }
        return this.server.isRunning();
    }

    public void waitForExit() {
        while (this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

