/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.mmoserver.networking;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.mmoserver.events.clients.ClientConnectedEvent;
import org.asf.edge.mmoserver.events.clients.ClientDisconnectedEvent;
import org.asf.edge.mmoserver.networking.SmartfoxServer;
import org.asf.edge.mmoserver.networking.sfs.OuterSmartfoxPacket;
import org.asf.edge.mmoserver.networking.sfs.SmartfoxNetworkObjectUtil;
import org.asf.edge.modules.eventbus.EventObject;

public abstract class SmartfoxClient {
    private HashMap<String, Object> memory = new HashMap();
    private Logger logger = LogManager.getLogger((String)"smartfox-client");
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    protected Logger getLogger() {
        return this.logger;
    }

    public <T> T getObject(Class<T> type) {
        return (T)this.memory.get(type.getTypeName());
    }

    public <T> void setObject(Class<T> type, T object) {
        this.memory.put(type.getTypeName(), object);
    }

    public <T> void removeObject(Class<T> type) {
        this.memory.remove(type.getTypeName());
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.callDisconnectEvents();
        this.disconnectClient();
    }

    protected void callDisconnectEvents() {
        this.getServer().getEventBus().dispatchEvent((EventObject)new ClientDisconnectedEvent(this.getServer(), this));
    }

    public abstract SmartfoxServer getServer();

    public abstract String getRemoteAddress();

    public abstract boolean isConnected();

    protected abstract void disconnectClient();

    protected abstract byte[] readSingleRawPacket() throws IOException;

    protected abstract void writeSingleRawPacket(byte[] var1) throws IOException;

    void startClient() {
        try {
            byte[] data = this.readSingleRawPacket();
            Map<String, Object> obj = SmartfoxNetworkObjectUtil.parseSfsObject(data);
            OuterSmartfoxPacket handshakePk = OuterSmartfoxPacket.fromSfsObject(obj);
        }
        catch (IOException e) {
            this.getLogger().error("Failed to handshake client " + this.getRemoteAddress(), (Throwable)e);
            this.disconnect();
            return;
        }
        this.getServer().getEventBus().dispatchEvent((EventObject)new ClientConnectedEvent(this.getServer(), this));
        while (true) {
            byte[] packet;
            try {
                packet = this.readSingleRawPacket();
            }
            catch (IOException e) {
                this.disconnect();
                return;
            }
            try {
                OuterSmartfoxPacket pkt = OuterSmartfoxPacket.fromSfsObject(SmartfoxNetworkObjectUtil.parseSfsObject(packet));
            }
            catch (Exception e) {
                this.logger.debug("Error occured while decoding packet: " + SmartfoxClient.bytesToHex(packet) + " from client " + this.getRemoteAddress(), (Throwable)e);
                this.disconnect();
                return;
            }
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

