/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.mmoserver.networking.bitswarm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class BitswarmClient {
    private InputStream input;
    private OutputStream output;

    public BitswarmClient(InputStream input, OutputStream output) {
        this.input = input;
        this.output = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPacket() throws IOException {
        InputStream inputStream = this.input;
        synchronized (inputStream) {
            int b = this.input.read();
            if (b == -1) {
                throw new IOException("Disconnected");
            }
            boolean encrypted = (b & 0x40) > 0;
            boolean compressed = (b & 0x20) > 0;
            boolean largeSize = (b & 8) > 0;
            int length = largeSize ? this.readInt(this.input) : this.readShort(this.input);
            byte[] payload = this.input.readNBytes(length);
            if (encrypted) {
                throw new IOException("Encryption not supported");
            }
            if (compressed) {
                ByteArrayInputStream bIn = new ByteArrayInputStream(payload);
                InflaterInputStream inInf = new InflaterInputStream(bIn);
                payload = inInf.readAllBytes();
                inInf.close();
            }
            return payload;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePacket(byte[] payload, boolean encrypted) throws IOException {
        OutputStream outputStream = this.output;
        synchronized (outputStream) {
            boolean compressed;
            boolean bl = compressed = payload.length >= 2000000;
            if (compressed) {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                DeflaterOutputStream dOut = new DeflaterOutputStream(bOut);
                dOut.write(payload);
                dOut.close();
                payload = bOut.toByteArray();
            }
            if (encrypted) {
                throw new IOException("Encryption not supported");
            }
            boolean largeSize = payload.length > Short.MAX_VALUE;
            int header = 0;
            if (encrypted) {
                header |= 0x40;
            }
            if (compressed) {
                header |= 0x20;
            }
            if (largeSize) {
                header |= 8;
            }
            this.output.write(header);
            if (largeSize) {
                this.writeInt(this.output, payload.length);
            } else {
                this.writeShort(this.output, (short)payload.length);
            }
            this.output.write(payload);
        }
    }

    private int readInt(InputStream strm) throws IOException {
        return ByteBuffer.wrap(strm.readNBytes(4)).getInt();
    }

    private int readShort(InputStream strm) throws IOException {
        return ByteBuffer.wrap(strm.readNBytes(2)).getShort();
    }

    private void writeInt(OutputStream strm, int val) throws IOException {
        strm.write(ByteBuffer.allocate(4).putInt(val).array());
    }

    private void writeShort(OutputStream strm, short val) throws IOException {
        strm.write(ByteBuffer.allocate(2).putShort(val).array());
    }
}

