/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.asf.edge.gameplayapi.commands.CommandContext;
import org.asf.edge.gameplayapi.commands.IEdgeServerCommand;

public abstract class TaskBasedCommand
implements IEdgeServerCommand {
    public abstract IEdgeServerCommand[] tasks();

    @Override
    public String syntax(CommandContext ctx) {
        return "<task> [arguments...]";
    }

    @Override
    public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(args));
        if (cmd.size() <= 0) {
            return "Error: missing task ID, please use 'help' for a list of commands and tasks";
        }
        String result = "Task not found, please use 'help' for a list of commands and tasks";
        String id = cmd.get(0);
        cmd.remove(0);
        for (IEdgeServerCommand c : this.tasks()) {
            if (!c.id().equalsIgnoreCase(id) || !ctx.getPermissions().hasPermission(c.permNode(), c.permLevel())) continue;
            result = c.run((String[])cmd.toArray(String[]::new), ctx, logger, outputWriteLineCallback, dataBlobs);
            break;
        }
        return result;
    }
}

