/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.http.handlers.api.messaging;

import java.io.IOException;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.CommonUpdater;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.entities.messages.WsMessage;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionResult;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequest;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequestParam;
import org.asf.edge.common.http.apihandlerutils.functions.SodTokenSecured;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireCapability;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireSave;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.messages.PlayerMessenger;
import org.asf.edge.common.services.messages.WsMessageService;
import org.asf.edge.common.xmls.messages.MessageInfoData;
import org.asf.edge.common.xmls.messages.MessageInfoList;
import org.asf.edge.commonapi.EdgeCommonApiServer;

public class MessagingWebServiceProcessor
extends EdgeWebService<EdgeCommonApiServer> {
    public MessagingWebServiceProcessor(EdgeCommonApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new MessagingWebServiceProcessor((EdgeCommonApiServer)this.getServerInstance());
    }

    public String path() {
        return "/MessagingWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        this.setResponseStatus(404, "Not found");
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult getUserMessageQueue(EdgeWebService.ServiceRequestInfo req, AccountObject account, AccountSaveContainer save) throws IOException {
        CommonUpdater.warnPlayerIfUpdating((AccountObject)account);
        PlayerMessenger messenger = WsMessageService.getInstance().getMessengerFor(account, save);
        WsMessage[] messages = messenger.getQueuedMessages(!((String)req.payload.get("showOldMessages")).equalsIgnoreCase("true"));
        MessageInfoList list = new MessageInfoList();
        list.messages = new MessageInfoData[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            WsMessage msg = messages[i];
            MessageInfoData info = new MessageInfoData();
            info.typeID = msg.messageTypeID();
            msg.serialize(info);
            list.messages[i] = info;
        }
        String str = req.generateXmlValue("ArrayOfMessageInfo", (Object)list);
        return this.ok("text/xml", str);
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult saveMessage(EdgeWebService.ServiceRequestInfo req, AccountObject account, AccountSaveContainer save, @SodRequestParam int userMessageQueueID, @SodRequestParam boolean isDeleted) throws IOException {
        PlayerMessenger messenger = WsMessageService.getInstance().getMessengerFor(account, save);
        if (isDeleted) {
            messenger.deleteMessage(userMessageQueueID);
        } else {
            messenger.markMessageRead(userMessageQueueID);
        }
        return this.ok("text/xml", req.generateXmlValue("bool", (Object)true));
    }
}

