/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.messages.impl;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.entities.messages.WsMessage;
import org.asf.edge.common.entities.messages.defaultmessages.WsGenericMessage;
import org.asf.edge.common.entities.messages.defaultmessages.WsRankMessage;
import org.asf.edge.common.events.achievements.RankChangedEvent;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.services.messages.PlayerMessenger;
import org.asf.edge.common.services.messages.WsMessageService;
import org.asf.edge.common.xmls.achievements.RewardData;
import org.asf.edge.common.xmls.messages.MessageInfoData;
import org.asf.edge.modules.eventbus.EventListener;

public class WsMessageServiceImpl
extends WsMessageService {
    @EventListener
    public void onRankChange(RankChangedEvent event) throws IOException {
        AccountObject acc = event.getAccount();
        int rankType = event.getEntityRank().getTypeID().getPointTypeID();
        if ((rankType == 1 || rankType == 8) && event.hasRankChanged()) {
            WsRankMessage msg = new WsRankMessage();
            msg.rankType = rankType;
            switch (rankType) {
                case 1: {
                    msg.particle = "PfPlayerLevelUpFxDO";
                    msg.levelUpMessage = new String[]{"You've leveled up to Rank " + (AchievementManager.getInstance().getRankIndex(event.getNewRank()) + 1)};
                    break;
                }
                case 8: {
                    RewardData reward = new RewardData();
                    reward.entityID = event.getEntityRank().getEntityID();
                    msg.particle = "PfDragonLevelUpFxDO";
                    msg.levelUpMessage = new String[]{"Your dragon bond with {{PetName}} the {{PetType}} is now Rank " + (AchievementManager.getInstance().getRankIndex(event.getNewRank()) + 1)};
                    msg.rawObject.data = new XmlMapper().writer().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("RewardData").writeValueAsString((Object)reward);
                    break;
                }
            }
            event.getAchievementManager().getRankForUser(event.getSave(), RankTypeID.UDT).addPoints(5);
            this.getMessengerFor(acc).sendSessionMessage(msg);
        } else {
            WsGenericMessage msg2 = new WsGenericMessage();
            msg2.rawObject.typeID = 11;
            this.getMessengerFor(acc).sendSessionMessage(msg2);
        }
    }

    @Override
    public void initService() {
    }

    @Override
    public PlayerMessenger getMessengerFor(AccountObject account, AccountSaveContainer save) {
        PlayerMessengerImpl i = new PlayerMessengerImpl();
        i.account = account;
        i.save = save;
        return i;
    }

    @Override
    public PlayerMessenger getMessengerFor(AccountObject account) {
        PlayerMessengerImpl i = new PlayerMessengerImpl();
        i.account = account;
        return i;
    }

    private class PlayerMessengerImpl
    extends PlayerMessenger {
        public AccountObject account;
        public AccountSaveContainer save;

        private PlayerMessengerImpl() {
        }

        @Override
        public WsMessage[] getQueuedMessages(boolean unreadOnly) throws IOException {
            WsMessage message;
            MessageInfoData msg;
            JsonObject msgD;
            int messageID;
            AccountDataContainer messagesContainer;
            ArrayList<WsMessage> messages = new ArrayList<WsMessage>();
            if (this.save != null) {
                messagesContainer = this.save.getSaveData().getChildContainer("wsservicemessages");
                for (String key : messagesContainer.getEntryKeys()) {
                    if (!key.startsWith("msg-")) continue;
                    messageID = Integer.parseInt(key.substring(4));
                    msgD = messagesContainer.getEntry(key).getAsJsonObject();
                    if (unreadOnly && !msgD.get("isRead").getAsBoolean()) {
                        msg = (MessageInfoData)new ObjectMapper().readValue(msgD.get("messageObject").toString(), MessageInfoData.class);
                        msg.messageQueueID = messageID;
                        message = WsMessageServiceImpl.this.deserializeMessage(msg);
                        messages.add(message);
                    }
                    if (msgD.get("persistent").getAsBoolean()) continue;
                    this.deleteMessage(messageID);
                }
            }
            messagesContainer = this.account.getAccountData().getChildContainer("wsservicemessages");
            for (String key : messagesContainer.getEntryKeys()) {
                if (!key.startsWith("msg-")) continue;
                messageID = Integer.parseInt(key.substring(4));
                msgD = messagesContainer.getEntry(key).getAsJsonObject();
                if (msgD.get("session").getAsLong() != this.account.getLastLoginTime()) {
                    this.deleteMessage(messageID);
                    continue;
                }
                msg = (MessageInfoData)new ObjectMapper().readValue(msgD.get("messageObject").toString(), MessageInfoData.class);
                msg.messageQueueID = messageID;
                message = WsMessageServiceImpl.this.deserializeMessage(msg);
                messages.add(message);
                this.deleteMessage(messageID);
            }
            return (WsMessage[])messages.toArray(WsMessage[]::new);
        }

        @Override
        public void deleteMessage(int messageID) throws IOException {
            AccountDataContainer messagesContainer;
            if (this.save != null && (messagesContainer = this.save.getSaveData().getChildContainer("wsservicemessages")).entryExists("msg-" + messageID)) {
                messagesContainer.deleteEntry("msg-" + messageID);
                return;
            }
            messagesContainer = this.account.getAccountData().getChildContainer("wsservicemessages");
            if (messagesContainer.entryExists("msg-" + messageID)) {
                messagesContainer.deleteEntry("msg-" + messageID);
            }
        }

        @Override
        public void markMessageRead(int messageID) throws IOException {
            AccountDataContainer messagesContainer;
            if (this.save != null && (messagesContainer = this.save.getSaveData().getChildContainer("wsservicemessages")).entryExists("msg-" + messageID)) {
                JsonObject msgD = messagesContainer.getEntry("msg-" + messageID).getAsJsonObject();
                msgD.addProperty("isRead", Boolean.valueOf(true));
                messagesContainer.setEntry("msg-" + messageID, (JsonElement)msgD);
                return;
            }
            messagesContainer = this.account.getAccountData().getChildContainer("wsservicemessages");
            if (messagesContainer.entryExists("msg-" + messageID)) {
                this.deleteMessage(messageID);
            }
        }

        @Override
        public void sendPersistentMessage(WsMessage message) throws IOException {
            if (this.save == null) {
                throw new IllegalArgumentException("Cannot send persistent messages from getMessengerFor(account), this can only be used from getMessengerFor(account,save)");
            }
            AccountDataContainer messagesContainer = this.save.getSaveData().getChildContainer("wsservicemessages");
            MessageInfoData msg = new MessageInfoData();
            message.serialize(msg);
            int messageID = 0;
            while (messagesContainer.entryExists("msg-" + messageID)) {
                ++messageID;
            }
            msg.messageQueueID = messageID;
            JsonObject msgD = new JsonObject();
            msgD.addProperty("isRead", Boolean.valueOf(false));
            msgD.addProperty("persistent", Boolean.valueOf(true));
            msgD.add("messageObject", JsonParser.parseString((String)new ObjectMapper().writeValueAsString((Object)msg)));
            messagesContainer.setEntry("msg-" + messageID, (JsonElement)msgD);
        }

        @Override
        public void sendSessionMessage(WsMessage message) throws IOException {
            AccountDataContainer messagesContainer = this.account.getAccountData().getChildContainer("wsservicemessages");
            MessageInfoData msg = new MessageInfoData();
            message.serialize(msg);
            int messageID = -1;
            while (messagesContainer.entryExists("msg-" + messageID)) {
                --messageID;
            }
            msg.messageQueueID = messageID;
            JsonObject msgD = new JsonObject();
            msgD.addProperty("session", (Number)this.account.getLastLoginTime());
            msgD.add("messageObject", JsonParser.parseString((String)new ObjectMapper().writeValueAsString((Object)msg)));
            messagesContainer.setEntry("msg-" + messageID, (JsonElement)msgD);
        }
    }
}

