/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.commondata.impl.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.commondata.impl.http.RemoteHttpCommonDataContainer;
import org.asf.edge.common.services.config.ConfigProviderService;
import org.asf.edge.common.util.HttpUpgradeUtil;

public class RemoteHttpCommonDataManager
extends CommonDataManager {
    public String urlBase = "http://127.0.0.1:5324/commondatamanager/";
    private Logger logger = LogManager.getLogger((String)"CommonDataManager");

    @Override
    public void initService() {
    }

    @Override
    public void loadManager() {
        JsonObject commonDataManagerConfig;
        try {
            commonDataManagerConfig = ConfigProviderService.getInstance().loadConfig("server", "commondata");
        }
        catch (IOException e) {
            this.logger.error("Failed to load common data manager configuration!", (Throwable)e);
            return;
        }
        if (commonDataManagerConfig == null) {
            commonDataManagerConfig = new JsonObject();
        }
        JsonObject config = new JsonObject();
        if (!commonDataManagerConfig.has("remoteHttpManager")) {
            config.addProperty("url", this.urlBase);
            commonDataManagerConfig.add("remoteHttpManager", (JsonElement)config);
            try {
                ConfigProviderService.getInstance().saveConfig("server", "commondata", commonDataManagerConfig);
            }
            catch (IOException e) {
                this.logger.error("Failed to write the common data manager configuration!", (Throwable)e);
                return;
            }
        } else {
            config = commonDataManagerConfig.get("remoteHttpManager").getAsJsonObject();
        }
        this.urlBase = config.get("url").getAsString();
        if (!this.urlBase.endsWith("/")) {
            this.urlBase = this.urlBase + "/";
        }
        this.logger.info("Using remote common data manager server, url: " + this.urlBase);
        this.logger.warn("Warning: the http-based remote common data manager service is not efficient!");
        this.logger.warn("Warning: its highly recommened to use a different implementation, such as a database server.");
    }

    public JsonObject commonDataManagerRequest(String function, JsonObject payload) throws IOException {
        Object url = this.urlBase;
        url = (String)url + function;
        HttpURLConnection conn = (HttpURLConnection)new URL((String)url).openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.getOutputStream().write(payload.toString().getBytes("UTF-8"));
        if (conn.getResponseCode() != 200) {
            throw new IOException("Server returned HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage());
        }
        try {
            return JsonParser.parseString((String)new String(conn.getInputStream().readAllBytes(), "UTF-8")).getAsJsonObject();
        }
        catch (Exception e) {
            throw new IOException("Server returned a non-json response");
        }
    }

    public Socket commonDataManagerUpgradeRequest(String function, JsonObject payload, String upgradeProtocol, String expectedResponseProtocol) throws IOException {
        Object url = this.urlBase;
        url = (String)url + function;
        byte[] body = payload.toString().getBytes("UTF-8");
        return HttpUpgradeUtil.upgradeRequest((String)url, "POST", new ByteArrayInputStream(body), body.length, Map.of("X-Request-ID", UUID.randomUUID().toString()), new HashMap<String, String>(), upgradeProtocol, expectedResponseProtocol);
    }

    @Override
    protected CommonDataContainer getContainerInternal(String rootNodeName) {
        return new RemoteHttpCommonDataContainer(rootNodeName, this);
    }

    @Override
    protected void setupContainer(String rootNodeName) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("node", rootNodeName);
            JsonObject response = this.commonDataManagerRequest("setupContainer", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success = false");
            }
        }
        catch (IOException e) {
            this.logger.error("Common data manager server query failure occurred in setupContainer!", (Throwable)e);
        }
    }
}

