/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.achievements;

import java.util.ArrayList;
import java.util.List;
import org.asf.edge.common.entities.achivements.EntityRankInfo;
import org.asf.edge.common.entities.achivements.RankInfo;
import org.asf.edge.common.entities.achivements.RankMultiplierInfo;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.xmls.achievements.UserRankData;

public abstract class AchievementManager
extends AbstractService {
    public static AchievementManager getInstance() {
        return ServiceManager.getService(AchievementManager.class);
    }

    public abstract RankInfo[] getRankDefinitions();

    public abstract RankInfo[] getRankDefinitionsByPointType(int var1);

    public abstract RankInfo getRankDefinition(int var1);

    public abstract void registerRankDefinition(int var1, UserRankData var2);

    public abstract void updateRankDefinition(int var1, UserRankData var2);

    public abstract EntityRankInfo getRankForUser(AccountSaveContainer var1, RankTypeID var2);

    public abstract EntityRankInfo getRankForDragon(AccountSaveContainer var1, String var2);

    public abstract EntityRankInfo getRankForClan(AccountSaveContainer var1, String var2);

    public EntityRankInfo[] getRanks(AccountSaveContainer save, String entityID) {
        ArrayList<EntityRankInfo> ranks = new ArrayList<EntityRankInfo>();
        if (save.getSaveID().equals(entityID)) {
            for (RankTypeID type : RankTypeID.values()) {
                if (type == RankTypeID.DRAGON || type == RankTypeID.CLAN) continue;
                ranks.add(this.getRank(save, entityID, type));
            }
        } else {
            ranks.add(this.getRank(save, entityID, RankTypeID.DRAGON));
        }
        return (EntityRankInfo[])ranks.toArray(EntityRankInfo[]::new);
    }

    public EntityRankInfo getRank(AccountSaveContainer save, String entityID, RankTypeID type) {
        if (type == RankTypeID.DRAGON) {
            return this.getRankForDragon(save, entityID);
        }
        if (type == RankTypeID.CLAN) {
            return this.getRankForClan(save, entityID);
        }
        return this.getRankForUser(save, type);
    }

    public int getRankIndex(RankInfo rank) {
        if (rank == null) {
            return -1;
        }
        int ind = 0;
        for (RankInfo r : this.getRankDefinitionsByPointType(rank.getPointTypeID())) {
            if (r.getID() == rank.getID()) {
                return ind;
            }
            ++ind;
        }
        return -1;
    }

    public abstract RankMultiplierInfo[] getServerwideRankMultipliers();

    public abstract RankMultiplierInfo[] getUserRankMultipliers(AccountSaveContainer var1);

    public RankMultiplierInfo[] getRankMultipliers(AccountSaveContainer save) {
        ArrayList<RankMultiplierInfo> multipliers = new ArrayList<RankMultiplierInfo>();
        multipliers.addAll(List.of(this.getServerwideRankMultipliers()));
        multipliers.addAll(List.of(this.getUserRankMultipliers(save)));
        return (RankMultiplierInfo[])multipliers.toArray(RankMultiplierInfo[]::new);
    }

    public abstract void addUserRankMultiplier(AccountSaveContainer var1, RankMultiplierInfo var2);

    public abstract int applyModifiers(AccountSaveContainer var1, int var2, RankTypeID var3);

    public abstract void reload();
}

