/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl.accounts.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.RemoteHttpAccountManager;
import org.asf.edge.common.util.SimpleBinaryMessageClient;

public class RemoteHttpDataContainer
extends AccountDataContainer {
    private String id;
    private RemoteHttpAccountManager mgr;
    private Logger logger = LogManager.getLogger((String)"AccountManager");
    private AccountObject account;

    public RemoteHttpDataContainer(AccountObject account, String id, RemoteHttpAccountManager mgr) {
        this.id = id;
        this.mgr = mgr;
        this.account = account;
    }

    @Override
    protected JsonElement get(String key) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("key", key);
            JsonObject response = this.mgr.accountManagerRequest("accounts/getDataEntry", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            return response.get("entryValue");
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getDataEntry!", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void set(String key, JsonElement value) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("key", key);
            payload.add("value", value);
            JsonObject response = this.mgr.accountManagerRequest("accounts/setDataEntry", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in setDataEntry!", (Throwable)e);
        }
    }

    @Override
    protected void create(String key, String root, JsonElement value) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("key", key);
            payload.addProperty("root", root);
            payload.add("value", value);
            JsonObject response = this.mgr.accountManagerRequest("accounts/createDataEntry", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in setDataEntry!", (Throwable)e);
        }
    }

    @Override
    protected boolean exists(String key) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("key", key);
            JsonObject response = this.mgr.accountManagerRequest("accounts/dataEntryExists", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in dataEntryExists!", (Throwable)e);
            return false;
        }
    }

    @Override
    protected void delete(String key) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("key", key);
            JsonObject response = this.mgr.accountManagerRequest("accounts/deleteDataEntry", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in deleteDataEntry!", (Throwable)e);
        }
    }

    @Override
    public AccountObject getAccount() {
        return this.account;
    }

    @Override
    public AccountSaveContainer getSave() {
        return null;
    }

    @Override
    protected String[] getEntryKeys(String key) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("key", key);
            JsonObject response = this.mgr.accountManagerRequest("accounts/getEntryKeys", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
            JsonArray arr = response.get("result").getAsJsonArray();
            String[] res = new String[arr.size()];
            int i = 0;
            for (JsonElement ele : arr) {
                res[i++] = ele.getAsString();
            }
            return res;
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getEntryKeys!", (Throwable)e);
            return new String[0];
        }
    }

    @Override
    protected String[] getChildContainers(String key) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("key", key);
            JsonObject response = this.mgr.accountManagerRequest("accounts/getChildContainers", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
            JsonArray arr = response.get("result").getAsJsonArray();
            String[] res = new String[arr.size()];
            int i = 0;
            for (JsonElement ele : arr) {
                res[i++] = ele.getAsString();
            }
            return res;
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getChildContainers!", (Throwable)e);
            return new String[0];
        }
    }

    @Override
    protected void deleteContainer(String root) throws IOException {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("root", root);
            JsonObject response = this.mgr.accountManagerRequest("accounts/deleteContainer", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in deleteContainer!", (Throwable)e);
        }
    }

    @Override
    protected JsonElement find(BiFunction<String, JsonElement, Boolean> function, String root) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("root", root);
            Socket conn = this.mgr.accountManagerUpgradeRequest("runForDataEntries", payload, "EDGEBINPROT/ACCMANAGER/RUNFOR", "EDGEBINPROT/ACCMANAGER/RUNFOR");
            ResultContainer cont = new ResultContainer();
            SimpleBinaryMessageClient binH = new SimpleBinaryMessageClient((packet, client) -> {
                try {
                    ByteArrayInputStream bIn = new ByteArrayInputStream(packet.data);
                    byte[] nameB = bIn.readNBytes(ByteBuffer.wrap(bIn.readNBytes(4)).getInt());
                    String name = new String(nameB, "UTF-8");
                    byte[] dataB = bIn.readNBytes(ByteBuffer.wrap(bIn.readNBytes(4)).getInt());
                    String data = new String(dataB, "UTF-8");
                    JsonElement d = JsonParser.parseString((String)data);
                    boolean res = (Boolean)function.apply(name, d);
                    if (res) {
                        cont.res = d;
                    }
                    client.send(new byte[]{!res ? (byte)1 : (byte)0});
                    if (!res) {
                        return false;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Exception occurred while running findDataEntry!", (Throwable)e);
                    return false;
                }
                return true;
            }, conn.getInputStream(), conn.getOutputStream());
            binH.start();
            conn.close();
            return (JsonElement)cont.res;
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in findDataEntry!", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void runFor(BiFunction<String, JsonElement, Boolean> function, String root) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("root", root);
            Socket conn = this.mgr.accountManagerUpgradeRequest("runForDataEntries", payload, "EDGEBINPROT/ACCMANAGER/RUNFOR", "EDGEBINPROT/ACCMANAGER/RUNFOR");
            SimpleBinaryMessageClient binH = new SimpleBinaryMessageClient((packet, client) -> {
                try {
                    ByteArrayInputStream bIn = new ByteArrayInputStream(packet.data);
                    byte[] nameB = bIn.readNBytes(ByteBuffer.wrap(bIn.readNBytes(4)).getInt());
                    String name = new String(nameB, "UTF-8");
                    byte[] dataB = bIn.readNBytes(ByteBuffer.wrap(bIn.readNBytes(4)).getInt());
                    String data = new String(dataB, "UTF-8");
                    boolean res = (Boolean)function.apply(name, JsonParser.parseString((String)data));
                    client.send(new byte[]{res ? (byte)1 : (byte)0});
                    if (!res) {
                        return false;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Exception occurred while running runForDataEntries!", (Throwable)e);
                    return false;
                }
                return true;
            }, conn.getInputStream(), conn.getOutputStream());
            binH.start();
            conn.close();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in runForDataEntries!", (Throwable)e);
        }
    }

    @Override
    protected void runForChildren(Function<String, Boolean> function, String root) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("root", root);
            Socket conn = this.mgr.accountManagerUpgradeRequest("runForDataChildren", payload, "EDGEBINPROT/ACCMANAGER/RUNFORCHILDREN", "EDGEBINPROT/ACCMANAGER/RUNFORCHILDREN");
            SimpleBinaryMessageClient binH = new SimpleBinaryMessageClient((packet, client) -> {
                try {
                    String name = new String(packet.data, "UTF-8");
                    boolean res = (Boolean)function.apply(name);
                    client.send(new byte[]{res ? (byte)1 : (byte)0});
                    if (!res) {
                        return false;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Exception occurred while running runForDataChildren!", (Throwable)e);
                    return false;
                }
                return true;
            }, conn.getInputStream(), conn.getOutputStream());
            binH.start();
            conn.close();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in runForDataChildren!", (Throwable)e);
        }
    }

    private class ResultContainer {
        public Object res;

        private ResultContainer() {
        }
    }
}

