/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.bytecode.sources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.asf.cyan.fluid.bytecode.enums.ComparisonMethod;
import org.asf.cyan.fluid.bytecode.sources.IClassSourceProvider;

public class LoaderClassSourceProvider
implements IClassSourceProvider<ClassLoader> {
    private ClassLoader classLoader;

    public LoaderClassSourceProvider(ClassLoader loader) {
        this.classLoader = loader;
    }

    @Override
    public ComparisonMethod getComparisonMethod() {
        return ComparisonMethod.LOGICAL_EQUALS;
    }

    @Override
    public ClassLoader providerObject() {
        return this.classLoader;
    }

    @Override
    public InputStream getStream(String classType) {
        URL u = this.classLoader.getResource(classType + ".class");
        if (u == null) {
            return null;
        }
        try {
            return u.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void importAll(FluidClassPool pool) {
    }
}

