/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.bytecode;

import java.lang.reflect.Modifier;
import java.util.function.Consumer;
import org.asf.cyan.fluid.bytecode.enums.OpcodeUseCase;
import org.asf.cyan.fluid.implementation.FluidBytecodeExporter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class BytecodeExporter {
    private static BytecodeExporter selectedImplementation = new FluidBytecodeExporter();

    static BytecodeExporter getImplmentationInstance() {
        return selectedImplementation;
    }

    protected static void setImplementation(BytecodeExporter implementation) {
        selectedImplementation = implementation;
    }

    protected BytecodeExporter() {
    }

    protected abstract String getImplementationName();

    protected abstract String getOpcodeName(Object var1, OpcodeUseCase var2);

    protected abstract String insnNodeToString(AbstractInsnNode var1, int var2);

    protected abstract String mthAnnotationHeadToString(MethodNode var1);

    protected abstract String mthHeadToString(MethodNode var1);

    protected abstract String classHeadToString(ClassNode var1);

    protected abstract String fieldToStringInternal(FieldNode var1);

    public static String opcodeToString(int opcode, OpcodeUseCase useCase) {
        return selectedImplementation.getOpcodeName(opcode, useCase);
    }

    public static String opcodeToString(Integer opcode, OpcodeUseCase useCase) {
        return selectedImplementation.getOpcodeName(opcode, useCase);
    }

    public static String instructionToString(AbstractInsnNode instruction, int index) {
        return selectedImplementation.insnNodeToString(instruction, index);
    }

    public static String methodAnnotationHeadToString(MethodNode method) {
        return selectedImplementation.mthAnnotationHeadToString(method);
    }

    public static String methodHeadToString(MethodNode method) {
        return selectedImplementation.mthHeadToString(method);
    }

    public static String fieldToString(FieldNode field) {
        return selectedImplementation.fieldToStringInternal(field);
    }

    public static String methodToString(MethodNode method) {
        StringBuilder result = new StringBuilder();
        selectedImplementation.methodToStringInternal(method, str -> result.append((String)str));
        return result.toString();
    }

    public static String classToString(ClassNode cls) {
        StringBuilder result = new StringBuilder();
        boolean hasAnno = selectedImplementation.classToStringInternal(cls, str -> result.append((String)str));
        boolean first = true;
        boolean firstContainsAnno = hasAnno;
        if (result.toString().startsWith("\n")) {
            firstContainsAnno = true;
        }
        for (MethodNode mth : cls.methods) {
            if (!first) {
                result.append("\n");
            }
            result.append("\n");
            StringBuilder strs = new StringBuilder();
            selectedImplementation.methodToStringInternal(mth, str -> strs.append((String)str));
            boolean first2 = true;
            if (strs.toString().startsWith("@")) {
                result.append("\n");
                if (first) {
                    firstContainsAnno = true;
                }
            }
            for (String line : strs.toString().split("\n")) {
                if (!first2) {
                    result.append("\n");
                }
                result.append("\t").append(line);
                first2 = false;
            }
            first = false;
        }
        if (firstContainsAnno) {
            result.append("\n");
        }
        result.append("\n}");
        return result.toString();
    }

    protected boolean classToStringInternal(ClassNode cls, Consumer<String> append) {
        boolean firstIsAnno = false;
        boolean first = true;
        append.accept(selectedImplementation.classHeadToString(cls));
        for (FieldNode field : cls.fields) {
            append.accept("\n");
            append.accept("\t");
            String fieldOut = selectedImplementation.fieldToStringInternal(field).replaceAll("\n", "\n\t");
            if (fieldOut.startsWith("@")) {
                append.accept("\n\t");
                if (first) {
                    firstIsAnno = true;
                }
            }
            first = false;
            append.accept(fieldOut);
        }
        return firstIsAnno;
    }

    protected void methodToStringInternal(MethodNode method, Consumer<String> append) {
        append.accept(BytecodeExporter.methodHeadToString(method));
        boolean indent = false;
        int normalIndex = 0;
        int labelIndex = 0;
        append.accept("\n\n");
        if (!Modifier.isAbstract(method.access)) {
            for (AbstractInsnNode insn : method.instructions) {
                int index = normalIndex++;
                if (insn instanceof LabelNode) {
                    index = labelIndex++;
                }
                String instrOut = BytecodeExporter.instructionToString(insn, index);
                if (instrOut.endsWith("{")) {
                    if (indent) {
                        append.accept("\t}\n\n");
                        normalIndex = 0;
                    }
                    indent = true;
                } else if (indent) {
                    append.accept("\t");
                }
                append.accept("\t");
                append.accept(instrOut);
                append.accept("\n");
            }
            if (indent) {
                append.accept("\t}");
            }
            append.accept("\n}");
        }
    }
}

