/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.mmoserver.networking.sfs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public class SmartfoxNetworkObjectUtil {
    public static Map<String, Object> parseSfsObject(byte[] data) throws IOException {
        ByteArrayInputStream strm = new ByteArrayInputStream(data);
        if (strm.read() != 18) {
            throw new IOException("Invalid packet: magic number invalid");
        }
        return SmartfoxNetworkObjectUtil.parseObject(strm);
    }

    public static Map<String, Object> parseObject(InputStream data) throws IOException {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        int length = ByteBuffer.wrap(data.readNBytes(2)).getShort();
        if (length < 0) {
            throw new IOException("Invalid length: " + (short)length + ": negative values are invalid for object length");
        }
        for (int i = 0; i < length; ++i) {
            short l = ByteBuffer.wrap(data.readNBytes(2)).getShort();
            String key = new String(data.readNBytes(l), "UTF-8");
            int type = data.read();
            Object val = SmartfoxNetworkObjectUtil.decodeVal(type, data);
            obj.put(key, val);
        }
        return obj;
    }

    private static Object decodeVal(int type, InputStream data) throws IOException {
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return data.read() == 1;
            }
            case 2: {
                return (byte)data.read();
            }
            case 3: {
                return ByteBuffer.wrap(data.readNBytes(2)).getShort();
            }
            case 4: {
                return ByteBuffer.wrap(data.readNBytes(4)).getInt();
            }
            case 5: {
                return ByteBuffer.wrap(data.readNBytes(8)).getLong();
            }
            case 6: {
                return Float.valueOf(ByteBuffer.wrap(data.readNBytes(4)).getFloat());
            }
            case 7: {
                return ByteBuffer.wrap(data.readNBytes(8)).getDouble();
            }
            case 8: {
                short l = ByteBuffer.wrap(data.readNBytes(2)).getShort();
                return new String(data.readNBytes(l), "UTF-8");
            }
            case 9: {
                short l = ByteBuffer.wrap(data.readNBytes(2)).getShort();
                boolean[] b = new boolean[l];
                for (int i2 = 0; i2 < b.length; ++i2) {
                    b[i2] = data.read() == 1;
                }
                return b;
            }
            case 10: {
                int ln = ByteBuffer.wrap(data.readNBytes(4)).getInt();
                return data.readNBytes(ln);
            }
            case 11: {
                short l = ByteBuffer.wrap(data.readNBytes(2)).getShort();
                short[] b = new short[l];
                for (int i2 = 0; i2 < b.length; ++i2) {
                    b[i2] = ByteBuffer.wrap(data.readNBytes(2)).getShort();
                }
                return b;
            }
            case 12: {
                short l = ByteBuffer.wrap(data.readNBytes(2)).getShort();
                int[] b = new int[l];
                for (int i2 = 0; i2 < b.length; ++i2) {
                    b[i2] = ByteBuffer.wrap(data.readNBytes(4)).getInt();
                }
                return b;
            }
            case 13: {
                short l = ByteBuffer.wrap(data.readNBytes(2)).getShort();
                long[] b = new long[l];
                for (int i2 = 0; i2 < b.length; ++i2) {
                    b[i2] = ByteBuffer.wrap(data.readNBytes(8)).getLong();
                }
                return b;
            }
            case 14: {
                short l = ByteBuffer.wrap(data.readNBytes(2)).getShort();
                float[] b = new float[l];
                for (int i2 = 0; i2 < b.length; ++i2) {
                    b[i2] = ByteBuffer.wrap(data.readNBytes(4)).getFloat();
                }
                return b;
            }
            case 15: {
                short l = ByteBuffer.wrap(data.readNBytes(2)).getShort();
                double[] b = new double[l];
                for (int i2 = 0; i2 < b.length; ++i2) {
                    b[i2] = ByteBuffer.wrap(data.readNBytes(8)).getDouble();
                }
                return b;
            }
            case 16: {
                short l = ByteBuffer.wrap(data.readNBytes(2)).getShort();
                String[] b = new String[l];
                for (int i2 = 0; i2 < b.length; ++i2) {
                    short l2 = ByteBuffer.wrap(data.readNBytes(2)).getShort();
                    b[i2] = new String(data.readNBytes(l2), "UTF-8");
                }
                return b;
            }
            case 17: {
                short l = ByteBuffer.wrap(data.readNBytes(2)).getShort();
                Object[] b = new Object[l];
                for (int i2 = 0; i2 < b.length; ++i2) {
                    b[i2] = SmartfoxNetworkObjectUtil.decodeVal(data.read(), data);
                }
                return b;
            }
            case 18: 
            case 19: {
                return SmartfoxNetworkObjectUtil.parseObject(data);
            }
        }
        throw new IOException("Invalid data type " + type);
    }

    public static byte[] encodeSfsObject(Map<String, Object> obj) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(18);
        SmartfoxNetworkObjectUtil.encodeObject(obj, output);
        return output.toByteArray();
    }

    public static void encodeObject(Map<String, Object> obj, OutputStream output) throws IOException {
        Object value;
        int[] types = new int[obj.size()];
        int i = 0;
        if (obj.size() > Short.MAX_VALUE) {
            throw new IOException("Too many values in object, max size is 32767");
        }
        for (String key : obj.keySet()) {
            if (key.length() > Short.MAX_VALUE) {
                throw new IOException("String '" + key + "' too long, max length is 32767");
            }
            value = obj.get(key);
            if (value == null) {
                types[i++] = 0;
                continue;
            }
            if (value instanceof Boolean) {
                types[i++] = 1;
                continue;
            }
            if (value instanceof Byte) {
                types[i++] = 2;
                continue;
            }
            if (value instanceof Short) {
                types[i++] = 3;
                continue;
            }
            if (value instanceof Integer) {
                types[i++] = 4;
                continue;
            }
            if (value instanceof Long) {
                types[i++] = 5;
                continue;
            }
            if (value instanceof Float) {
                types[i++] = 6;
                continue;
            }
            if (value instanceof Double) {
                types[i++] = 7;
                continue;
            }
            if (value instanceof String) {
                if (value.toString().length() > Short.MAX_VALUE) {
                    throw new IOException("String '" + value.toString() + "' too long, max length is 32767");
                }
                types[i++] = 8;
                continue;
            }
            if (value instanceof boolean[]) {
                types[i++] = 9;
                continue;
            }
            if (value instanceof byte[]) {
                types[i++] = 10;
                continue;
            }
            if (value instanceof short[]) {
                types[i++] = 11;
                continue;
            }
            if (value instanceof int[]) {
                types[i++] = 12;
                continue;
            }
            if (value instanceof long[]) {
                types[i++] = 13;
                continue;
            }
            if (value instanceof float[]) {
                types[i++] = 14;
                continue;
            }
            if (value instanceof double[]) {
                types[i++] = 15;
                continue;
            }
            if (value instanceof String[]) {
                for (String str : (String[])value) {
                    if (str.length() <= Short.MAX_VALUE) continue;
                    throw new IOException("String '" + str + "' too long, max length is 32767");
                }
                types[i++] = 16;
                continue;
            }
            if (value instanceof Object[]) {
                types[i++] = 17;
                continue;
            }
            if (value instanceof Map) {
                Map mp = (Map)value;
                if (!mp.containsKey("$C") || !mp.containsKey("$F")) {
                    types[i++] = 18;
                    continue;
                }
                types[i++] = 19;
                continue;
            }
            throw new IOException("Unsupported type: " + value.getClass().getTypeName());
        }
        i = 0;
        output.write(ByteBuffer.allocate(2).putShort((short)obj.size()).array());
        for (String key : obj.keySet()) {
            value = obj.get(key);
            output.write(ByteBuffer.allocate(2).putShort((short)key.length()).array());
            output.write(key.getBytes("UTF-8"));
            SmartfoxNetworkObjectUtil.writeVal(value, types[i], output);
            ++i;
        }
    }

    private static void writeVal(Object value, int type, OutputStream output) throws IOException {
        output.write(type);
        switch (type) {
            case 1: {
                output.write((Boolean)value == true ? 1 : 0);
                break;
            }
            case 2: {
                output.write(((Byte)value).byteValue());
                break;
            }
            case 3: {
                output.write(ByteBuffer.allocate(2).putShort((Short)value).array());
                break;
            }
            case 4: {
                output.write(ByteBuffer.allocate(4).putInt((Integer)value).array());
                break;
            }
            case 5: {
                output.write(ByteBuffer.allocate(8).putLong((Long)value).array());
                break;
            }
            case 6: {
                output.write(ByteBuffer.allocate(4).putFloat(((Float)value).floatValue()).array());
                break;
            }
            case 7: {
                output.write(ByteBuffer.allocate(8).putDouble((Double)value).array());
                break;
            }
            case 8: {
                output.write(ByteBuffer.allocate(2).putShort((short)value.toString().length()).array());
                output.write(value.toString().getBytes("UTF-8"));
                break;
            }
            case 9: {
                boolean[] b = (boolean[])value;
                output.write(ByteBuffer.allocate(2).putShort((short)b.length).array());
                for (boolean bl : b) {
                    output.write(bl ? 1 : 0);
                }
                break;
            }
            case 10: {
                byte[] b = (byte[])value;
                output.write(ByteBuffer.allocate(4).putInt(b.length).array());
                output.write(b);
                break;
            }
            case 11: {
                short[] va = (short[])value;
                output.write(ByteBuffer.allocate(2).putShort((short)va.length).array());
                for (short v : va) {
                    output.write(ByteBuffer.allocate(2).putShort(v).array());
                }
                break;
            }
            case 12: {
                int[] va = (int[])value;
                output.write(ByteBuffer.allocate(2).putShort((short)va.length).array());
                for (int v : va) {
                    output.write(ByteBuffer.allocate(4).putInt(v).array());
                }
                break;
            }
            case 13: {
                long[] va = (long[])value;
                output.write(ByteBuffer.allocate(2).putShort((short)va.length).array());
                for (long v : va) {
                    output.write(ByteBuffer.allocate(8).putLong(v).array());
                }
                break;
            }
            case 14: {
                float[] va = (float[])value;
                output.write(ByteBuffer.allocate(2).putShort((short)va.length).array());
                for (float v : va) {
                    output.write(ByteBuffer.allocate(4).putFloat(v).array());
                }
                break;
            }
            case 15: {
                double[] va = (double[])value;
                output.write(ByteBuffer.allocate(2).putShort((short)va.length).array());
                for (double v : va) {
                    output.write(ByteBuffer.allocate(8).putDouble(v).array());
                }
                break;
            }
            case 16: {
                String[] va = (String[])value;
                output.write(ByteBuffer.allocate(2).putShort((short)va.length).array());
                for (String v : va) {
                    output.write(ByteBuffer.allocate(2).putShort((short)v.toString().length()).array());
                    output.write(v.toString().getBytes("UTF-8"));
                }
                break;
            }
            case 17: {
                Map[] va = (Map[])value;
                output.write(ByteBuffer.allocate(2).putShort((short)va.length).array());
                for (Map v : va) {
                    int t = 0;
                    if (value == null) {
                        t = 0;
                    } else if (value instanceof Boolean) {
                        t = 1;
                    } else if (value instanceof Byte) {
                        t = 2;
                    } else if (value instanceof Short) {
                        t = 3;
                    } else if (value instanceof Integer) {
                        t = 4;
                    } else if (value instanceof Long) {
                        t = 5;
                    } else if (value instanceof Float) {
                        t = 6;
                    } else if (value instanceof Double) {
                        t = 7;
                    } else if (value instanceof String) {
                        if (value.toString().length() > Short.MAX_VALUE) {
                            throw new IOException("String '" + value.toString() + "' too long, max length is 32767");
                        }
                        t = 8;
                    } else if (value instanceof boolean[]) {
                        t = 9;
                    } else if (value instanceof byte[]) {
                        t = 10;
                    } else if (value instanceof short[]) {
                        t = 11;
                    } else if (value instanceof int[]) {
                        t = 12;
                    } else if (value instanceof long[]) {
                        t = 13;
                    } else if (value instanceof float[]) {
                        t = 14;
                    } else if (value instanceof double[]) {
                        t = 15;
                    } else if (value instanceof String[]) {
                        for (String str : (String[])value) {
                            if (str.length() <= Short.MAX_VALUE) continue;
                            throw new IOException("String '" + str + "' too long, max length is 32767");
                        }
                        t = 16;
                    } else if (value instanceof Object[]) {
                        t = 17;
                    } else if (value instanceof Map) {
                        Map mp = (Map)value;
                        t = !mp.containsKey("$C") || !mp.containsKey("$F") ? 18 : 19;
                    } else {
                        throw new IOException("Unsupported type: " + value.getClass().getTypeName());
                    }
                    SmartfoxNetworkObjectUtil.writeVal(v, t, output);
                }
                break;
            }
            case 18: 
            case 19: {
                SmartfoxNetworkObjectUtil.encodeObject((Map)value, output);
            }
        }
    }
}

