/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.contentserver;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.CommonUpdater;
import org.asf.edge.contentserver.EdgeContentServer;
import org.asf.edge.contentserver.config.ContentServerConfig;
import org.asf.edge.contentserver.events.config.ContentServerConfigLoadedEvent;
import org.asf.edge.contentserver.events.config.ContentServerConfigPresetupEvent;
import org.asf.edge.modules.ModuleManager;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class EdgeContentServerMain {
    public static void main(String[] args) throws IOException, URISyntaxException {
        Locale.setDefault(Locale.ENGLISH);
        EdgeContentServer.printSplash();
        CommonInit.initAll();
        CommonUpdater.init((String)"contentserver", (String)"stable", (String)"1.0.0.A1", (File)new File(EdgeContentServerMain.class.getProtectionDomain().getCodeSource().getLocation().toURI()));
        Logger logger = LogManager.getLogger((String)"CONTENTSERVER");
        logger.info("Preparing to start...");
        ModuleManager.init();
        ContentServerConfig config = new ContentServerConfig();
        EventBus.getInstance().dispatchEvent((EventObject)new ContentServerConfigPresetupEvent(config));
        logger.info("Loading server configuration...");
        File configFile = new File("server.json");
        if (!configFile.exists()) {
            logger.debug("Creating server configuration...");
            if (config.server == null) {
                Files.writeString(configFile.toPath(), (CharSequence)"{\n\n    \"listenAddress\": \"0.0.0.0\",\n    \"listenPort\": 5319,\n    \"contentRequestListenPath\": \"/\",\n    \"contentDataPath\": \"./asset-data\",\n    \"allowIndexingAssets\": true,\n\n    \"serverTestEndpoint\": null,\n    \"fallbackAssetServerEndpoint\": null,\n    \"fallbackAssetServerManifestModifications\": {},\n\n    \"storeFallbackAssetDownloads\": false,\n    \"https\": false,\n    \"tlsKeystore\": null,\n    \"tlsKeystorePassword\": null,\n\n    \"modules\": {\n    }\n\n}", new OpenOption[0]);
            } else {
                Files.writeString(configFile.toPath(), (CharSequence)"{\n\n    \"contentRequestListenPath\": \"/\",\n    \"contentDataPath\": \"./asset-data\",\n    \"allowIndexingAssets\": true,\n\n    \"serverTestEndpoint\": null,\n    \"assetProxyServerEndpoint\": null,\n    \"assetProxyManifestModifications\": {},\n\n    \"storeFallbackAssetDownloads\": false,\n    \"modules\": {\n    }\n\n}", new OpenOption[0]);
            }
        }
        logger.debug("Loading configuration file server.json...");
        JsonObject configData = JsonParser.parseString((String)Files.readString(configFile.toPath())).getAsJsonObject();
        if (config.server == null) {
            logger.debug("Loading listening settings...");
            config.listenAddress = configData.get("listenAddress").getAsString();
            config.listenPort = configData.get("listenPort").getAsInt();
        }
        logger.debug("Loading IO settings...");
        config.contentRequestListenPath = configData.get("contentRequestListenPath").getAsString();
        config.contentDataPath = configData.get("contentDataPath").getAsString();
        config.allowIndexingAssets = configData.get("allowIndexingAssets").getAsBoolean();
        if (configData.has("fallbackAssetServerEndpoint") && !configData.get("fallbackAssetServerEndpoint").isJsonNull()) {
            config.fallbackAssetServerEndpoint = configData.get("fallbackAssetServerEndpoint").getAsString();
        }
        if (configData.has("fallbackAssetServerManifestModifications") && !configData.get("fallbackAssetServerManifestModifications").isJsonNull()) {
            config.fallbackAssetServerManifestModifications = configData.get("fallbackAssetServerManifestModifications").getAsJsonObject();
        }
        if (configData.has("storeFallbackAssetDownloads") && !configData.get("storeFallbackAssetDownloads").isJsonNull()) {
            config.storeFallbackAssetDownloads = configData.get("storeFallbackAssetDownloads").getAsBoolean();
        }
        if (configData.has("serverTestEndpoint") && !configData.get("serverTestEndpoint").isJsonNull()) {
            config.serverTestEndpoint = configData.get("serverTestEndpoint").getAsString();
        }
        if (config.server == null) {
            logger.debug("Loading encryption settings...");
            config.https = configData.get("https").getAsBoolean();
            if (config.https) {
                config.tlsKeystore = configData.get("tlsKeystore").getAsString();
                config.tlsKeystorePassword = configData.get("tlsKeystorePassword").getAsString();
            }
        }
        if (configData.has("modules")) {
            logger.debug("Loading module configurations...");
            JsonObject moduleSettings = configData.get("modules").getAsJsonObject();
            for (String id : moduleSettings.keySet()) {
                JsonObject conf = moduleSettings.get(id).getAsJsonObject();
                LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
                for (String key : conf.keySet()) {
                    mp.put(key, conf.get(key).getAsString());
                }
                ModuleManager.loadedModuleConfig((String)id, mp);
            }
        }
        EventBus.getInstance().dispatchEvent((EventObject)new ContentServerConfigLoadedEvent(config));
        EdgeContentServer server = new EdgeContentServer(config);
        server.setupServer();
        server.startServer();
        ModuleManager.runModulePostInit();
        logger.info("Server is running!");
        server.waitForExit();
        if (CommonInit.restartPending) {
            System.exit(237);
        } else {
            System.exit(0);
        }
    }
}

