/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.items.impl.ItemManagerImpl;

public class InventoryFixTool {
    private static long accountCount;
    private static long index;

    public static void main(String[] args) {
        CommonInit.initAll();
        Logger logger = LogManager.getLogger((String)"CONVERTER");
        logger.info("Preparing to start...");
        logger.info("Loading managers...");
        logger.debug("Loading account manager implementations...");
        AccountManager.initAccountManagerServices((int)-10, (int)0, (int)-5);
        logger.debug("Selecting account manager implementation...");
        ServiceManager.selectServiceImplementation(AccountManager.class);
        logger.debug("Loading account manager...");
        AccountManager.getInstance().loadManager();
        logger.debug("Loading common data manager implementations...");
        CommonDataManager.initCommonDataManagerServices((int)-10, (int)0, (int)-5);
        logger.debug("Selecting common data manager implementation...");
        ServiceManager.selectServiceImplementation(CommonDataManager.class);
        logger.debug("Loading common data manager...");
        CommonDataManager.getInstance().loadManager();
        logger.debug("Setting up item manager...");
        ServiceManager.registerServiceImplementation(ItemManager.class, (AbstractService)new ItemManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(ItemManager.class);
        logger.info("Indexing...");
        AccountManager.getInstance().runForAllAccounts(acc -> {
            ++accountCount;
            return true;
        });
        logger.info("Repairing data of " + accountCount + " accounts...");
        AccountManager.getInstance().runForAllAccounts(acc -> {
            logger.info("[ " + ++index + " / " + accountCount + " ] Repairing data of " + acc.getUsername());
            InventoryFixTool.repairInventories(acc.getAccountData(), logger);
            logger.info("[ " + index + " / " + accountCount + " ] Repairing data of all saves of " + acc.getUsername());
            for (String id : acc.getSaveIDs()) {
                AccountSaveContainer save = acc.getSave(id);
                logger.info("[ " + index + " / " + accountCount + " ] Repairing data of save " + save.getUsername());
                InventoryFixTool.repairInventories(save.getSaveData(), logger);
            }
            return true;
        });
    }

    private static void repairInventories(AccountDataContainer data, Logger logger) {
        try {
            data = data.getChildContainer("commoninventories");
            for (String key : data.getChildContainers()) {
                if (!key.startsWith("c-")) continue;
                int containerID = Integer.parseInt(key.substring(2));
                AccountDataContainer container = data.getChildContainer("c-" + containerID);
                for (String key2 : container.getChildContainers()) {
                    if (!key2.startsWith("d-")) continue;
                    int defID = Integer.parseInt(key2.substring(2));
                    AccountDataContainer defCont = container.getChildContainer("d-" + defID);
                    for (String key3 : defCont.getEntryKeys()) {
                        if (!key3.startsWith("u-")) continue;
                        int uniqueID = Integer.parseInt(key3.substring(3));
                        container.setEntry("u-" + uniqueID, (JsonElement)new JsonPrimitive((Number)defID));
                    }
                }
            }
        }
        catch (IOException e) {
            logger.fatal("Failed to repair data of account " + data.getAccount().getUsername(), (Throwable)e);
            System.exit(1);
        }
    }
}

