/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.http.handlers.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.Function;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionResult;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.util.SimpleBinaryMessageClient;
import org.asf.edge.commonapi.EdgeCommonApiServer;

public class AccountManagerAPI
extends EdgeWebService<EdgeCommonApiServer> {
    private static AccountManager manager;

    public AccountManagerAPI(EdgeCommonApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new AccountManagerAPI((EdgeCommonApiServer)this.getServerInstance());
    }

    public String path() {
        return "/accountmanager";
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void verifyToken(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("token")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        resp.addProperty("result", (Number)manager.verifyToken(payload.get("token").getAsString()).ordinal());
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void signToken(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("token")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        resp.addProperty("result", Base64.getEncoder().encodeToString(manager.signToken(payload.get("token").getAsString())));
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void isValidUsername(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("username")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        resp.addProperty("result", Boolean.valueOf(manager.isValidUsername(payload.get("username").getAsString())));
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void isValidPassword(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("password")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        resp.addProperty("result", Boolean.valueOf(manager.isValidPassword(payload.get("password").getAsString())));
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void isUsernameTaken(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("username")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        resp.addProperty("result", Boolean.valueOf(manager.isUsernameTaken(payload.get("username").getAsString())));
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getAccountID(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("username")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        String id = manager.getAccountID(payload.get("username").getAsString());
        resp.addProperty("success", Boolean.valueOf(id != null));
        if (id != null) {
            resp.addProperty("id", id);
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getAccountIdBySaveUsername(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("username")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        String id = manager.getAccountIdBySaveUsername(payload.get("username").getAsString());
        resp.addProperty("success", Boolean.valueOf(id != null));
        if (id != null) {
            resp.addProperty("id", id);
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getAccountIDByEmail(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("email")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        String id = manager.getAccountIDByEmail(payload.get("email").getAsString());
        resp.addProperty("success", Boolean.valueOf(id != null));
        if (id != null) {
            resp.addProperty("id", id);
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void verifyPassword(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("password")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        resp.addProperty("result", Boolean.valueOf(manager.verifyPassword(payload.get("id").getAsString(), payload.get("password").getAsString())));
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void accountExists(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        resp.addProperty("result", Boolean.valueOf(manager.accountExists(payload.get("id").getAsString())));
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getAccount(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        resp.addProperty("success", Boolean.valueOf(acc != null));
        if (acc != null) {
            resp.addProperty("username", acc.getUsername());
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getGuestAccount(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("guestID")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getGuestAccount(payload.get("guestID").getAsString());
        JsonObject resp = new JsonObject();
        resp.addProperty("success", Boolean.valueOf(acc != null));
        if (acc != null) {
            resp.addProperty("id", acc.getAccountID());
            resp.addProperty("username", acc.getUsername());
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/getDataEntry")
    public void getDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("key")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            JsonElement val = acc.getAccountData().unsafeAccessor().get(payload.get("key").getAsString());
            resp.addProperty("success", Boolean.valueOf(val != null));
            if (val != null) {
                resp.add("entryValue", val);
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/setDataEntry")
    public void setDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("key") && payload.has("value"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            acc.getAccountData().unsafeAccessor().set(payload.get("key").getAsString(), payload.get("value"));
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/createDataEntry")
    public void createDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("key") && payload.has("root") && payload.has("value"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            acc.getAccountData().unsafeAccessor().create(payload.get("key").getAsString(), payload.get("root").getAsString(), payload.get("value"));
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/dataEntryExists")
    public void dataEntryExists(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("key")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("result", Boolean.valueOf(acc.getAccountData().unsafeAccessor().exists(payload.get("key").getAsString())));
        } else {
            resp.addProperty("result", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/deleteDataEntry")
    public void deleteDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("key")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            acc.getAccountData().unsafeAccessor().delete(payload.get("key").getAsString());
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"}, value="accounts/getChildContainers")
    public FunctionResult getChildContainers(FunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("key")) {
            return this.response(400, "Bad request");
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            String[] containers = acc.getAccountData().unsafeAccessor().getChildContainers(payload.get("key").getAsString());
            JsonArray arr = new JsonArray();
            for (String cont : containers) {
                arr.add(cont);
            }
            resp.addProperty("success", Boolean.valueOf(true));
            resp.add("result", (JsonElement)arr);
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"}, value="accounts/getEntryKeys")
    public FunctionResult getEntryKeys(FunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("key")) {
            return this.response(400, "Bad request");
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            String[] keys = acc.getAccountData().unsafeAccessor().getEntryKeys(payload.get("key").getAsString());
            JsonArray arr = new JsonArray();
            for (String cont : keys) {
                arr.add(cont);
            }
            resp.addProperty("success", Boolean.valueOf(true));
            resp.add("result", (JsonElement)arr);
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        return this.ok("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/deleteAccount")
    public void deleteAccount(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            acc.deleteAccount();
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/updateLastLoginTime")
    public void updateLastLoginTime(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            acc.updateLastLoginTime();
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/setStrictChatFilterEnabled")
    public void setStrictChatFilterEnabled(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("state")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            acc.setStrictChatFilterEnabled(payload.get("state").getAsBoolean());
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/setChatEnabled")
    public void setChatEnabled(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("state")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            acc.setChatEnabled(payload.get("state").getAsBoolean());
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/setMultiplayerEnabled")
    public void setMultiplayerEnabled(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("state")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            acc.setMultiplayerEnabled(payload.get("state").getAsBoolean());
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/isStrictChatFilterEnabled")
    public void isStrictChatFilterEnabled(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("result", Boolean.valueOf(acc.isStrictChatFilterEnabled()));
        } else {
            resp.addProperty("result", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/isChatEnabled")
    public void isChatEnabled(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("result", Boolean.valueOf(acc.isChatEnabled()));
        } else {
            resp.addProperty("result", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/isMultiplayerEnabled")
    public void isMultiplayerEnabled(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("result", Boolean.valueOf(acc.isMultiplayerEnabled()));
        } else {
            resp.addProperty("result", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/isGuestAccount")
    public void isGuestAccount(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("result", Boolean.valueOf(acc.isGuestAccount()));
        } else {
            resp.addProperty("result", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/migrateToNormalAccountFromGuest")
    public void migrateToNormalAccountFromGuest(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("newName") && payload.has("email") && payload.has("password"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("success", Boolean.valueOf(acc.migrateToNormalAccountFromGuest(payload.get("newName").getAsString(), payload.get("email").getAsString(), payload.get("password").getAsString().toCharArray())));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/updatePassword")
    public void updatePassword(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("newPassword")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("success", Boolean.valueOf(acc.updatePassword(payload.get("newPassword").getAsString().toCharArray())));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/updateUsername")
    public void updateUsername(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("newName")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("success", Boolean.valueOf(acc.updateUsername(payload.get("newName").getAsString())));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/updateEmail")
    public void updateEmail(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("email")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("success", Boolean.valueOf(acc.updateEmail(payload.get("email").getAsString())));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/getRegistrationTimestamp")
    public void getRegistrationTimestamp(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("time", (Number)acc.getRegistrationTimestamp());
        } else {
            resp.addProperty("time", (Number)-1);
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/getLastLoginTime")
    public void getLastLoginTime(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("time", (Number)acc.getLastLoginTime());
        } else {
            resp.addProperty("time", (Number)-1);
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/getSaveIDs")
    public void getSaveIDs(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            JsonArray saveLst = new JsonArray();
            for (String save : acc.getSaveIDs()) {
                saveLst.add(save);
            }
            resp.add("saves", (JsonElement)saveLst);
        } else {
            resp.add("saves", (JsonElement)new JsonArray());
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/createSave")
    public void createSave(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("username")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.createSave(payload.get("username").getAsString());
            if (cont != null) {
                resp.addProperty("success", Boolean.valueOf(true));
                resp.addProperty("id", cont.getSaveID());
                resp.addProperty("time", (Number)cont.getCreationTime());
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/getSave")
    public void getSave(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("save")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
            if (cont != null) {
                resp.addProperty("success", Boolean.valueOf(true));
                resp.addProperty("username", cont.getUsername());
                resp.addProperty("time", (Number)cont.getCreationTime());
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/updateSaveUsername")
    public void updateSaveUsername(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("save") && payload.has("newName"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
            if (cont != null) {
                resp.addProperty("success", Boolean.valueOf(cont.updateUsername(payload.get("newName").getAsString())));
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/deleteSave")
    public void deleteSave(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("save")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
            if (cont != null) {
                cont.deleteSave();
                resp.addProperty("success", Boolean.valueOf(true));
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/getSaveDataEntry")
    public void getSaveDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("save") && payload.has("key"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
            if (cont != null) {
                JsonElement val = cont.getSaveData().unsafeAccessor().get(payload.get("key").getAsString());
                resp.addProperty("success", Boolean.valueOf(val != null));
                if (val != null) {
                    resp.add("entryValue", val);
                }
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/setSaveDataEntry")
    public void setSaveDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("save") && payload.has("key") && payload.has("value"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
            if (cont != null) {
                cont.getSaveData().unsafeAccessor().set(payload.get("key").getAsString(), payload.get("value"));
                resp.addProperty("success", Boolean.valueOf(true));
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/createSaveDataEntry")
    public void createSaveDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("save") && payload.has("root") && payload.has("key") && payload.has("value"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
            if (cont != null) {
                cont.getSaveData().unsafeAccessor().create(payload.get("key").getAsString(), payload.get("root").getAsString(), payload.get("value"));
                resp.addProperty("success", Boolean.valueOf(true));
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/saveDataEntryExists")
    public void saveDataEntryExists(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("save") && payload.has("key"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
            if (cont != null) {
                resp.addProperty("result", Boolean.valueOf(cont.getSaveData().unsafeAccessor().exists(payload.get("key").getAsString())));
            } else {
                resp.addProperty("result", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("result", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/deleteSaveDataEntry")
    public void deleteSaveDataEntry(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("save") && payload.has("key"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
            if (cont != null) {
                cont.getSaveData().unsafeAccessor().delete(payload.get("key").getAsString());
                resp.addProperty("success", Boolean.valueOf(true));
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"}, value="accounts/deleteSaveContainer")
    public FunctionResult deleteSaveContainer(FunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("save") && payload.has("root"))) {
            return this.response(400, "Bad request");
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
            if (cont != null) {
                cont.getSaveData().unsafeAccessor().deleteContainer(payload.get("root").getAsString());
                resp.addProperty("success", Boolean.valueOf(true));
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"}, value="accounts/getChildSaveContainers")
    public FunctionResult getChildSaveContainers(FunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("save") && payload.has("key"))) {
            return this.response(400, "Bad request");
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
            if (cont != null) {
                String[] containers = cont.getSaveData().unsafeAccessor().getChildContainers(payload.get("key").getAsString());
                JsonArray arr = new JsonArray();
                for (String conta : containers) {
                    arr.add(conta);
                }
                resp.addProperty("success", Boolean.valueOf(true));
                resp.add("result", (JsonElement)arr);
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"}, value="accounts/getSaveEntryKeys")
    public FunctionResult getSaveEntryKeys(FunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("save") && payload.has("key"))) {
            return this.response(400, "Bad request");
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
            if (cont != null) {
                String[] keys = acc.getAccountData().unsafeAccessor().getEntryKeys(payload.get("key").getAsString());
                JsonArray arr = new JsonArray();
                for (String conta : keys) {
                    arr.add(conta);
                }
                resp.addProperty("success", Boolean.valueOf(true));
                resp.add("result", (JsonElement)arr);
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        return this.ok("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void registerGuestAccount(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("guestID")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.registerGuestAccount(payload.get("guestID").getAsString());
        JsonObject resp = new JsonObject();
        resp.addProperty("success", Boolean.valueOf(acc != null));
        if (acc != null) {
            resp.addProperty("id", acc.getAccountID());
            resp.addProperty("username", acc.getUsername());
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void registerAccount(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("username") && payload.has("email") && payload.has("password"))) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.registerAccount(payload.get("username").getAsString(), payload.get("email").getAsString(), payload.get("password").getAsString().toCharArray());
        JsonObject resp = new JsonObject();
        resp.addProperty("success", Boolean.valueOf(acc != null));
        if (acc != null) {
            resp.addProperty("id", acc.getAccountID());
            resp.addProperty("username", acc.getUsername());
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/getAccountEmail")
    public void getAccountEmail(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            String email = acc.getAccountEmail();
            if (email != null) {
                resp.addProperty("success", Boolean.valueOf(true));
                resp.addProperty("email", email);
            } else {
                resp.addProperty("success", Boolean.valueOf(false));
            }
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getSaveByID(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("save")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        AccountSaveContainer cont = manager.getSaveByID(payload.get("save").getAsString());
        if (cont != null) {
            resp.addProperty("success", Boolean.valueOf(true));
            resp.addProperty("accid", cont.getAccount().getAccountID());
            resp.addProperty("username", cont.getSaveID());
            resp.addProperty("time", (Number)cont.getCreationTime());
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getOnlinePlayerIDs(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject resp = new JsonObject();
        JsonArray players = new JsonArray();
        for (String save : manager.getOnlinePlayerIDs()) {
            players.add(save);
        }
        resp.add("players", (JsonElement)players);
        this.setResponseContent("text/json", resp.toString());
    }

    @LegacyFunction(allowedMethods={"POST"}, value="accounts/isOnline")
    public void isOnline(LegacyFunctionInfo func) throws JsonSyntaxException, IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id")) {
            this.getResponse().setResponseStatus(400, "Bad request");
            return;
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            resp.addProperty("result", Boolean.valueOf(acc.isOnline()));
        } else {
            resp.addProperty("result", Boolean.valueOf(false));
        }
        this.setResponseContent("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult runForAllAccounts(FunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasHeader("Upgrade") || !this.getRequest().getHeaderValue("Upgrade").equals("EDGEBINPROT/ACCMANAGER/RUNFORALLACCOUNTS")) {
            return this.response(400, "Bad request");
        }
        this.setResponseHeader("X-Response-ID", UUID.randomUUID().toString());
        this.setResponseHeader("Upgrade", "EDGEBINPROT/ACCMANAGER/RUNFORALLACCOUNTS");
        AsyncTaskManager.runAsync(() -> {
            while (!(!func.getClient().isConnected() || func.getResponse().hasHeader("Upgraded") && func.getResponse().getHeaderValue("Upgraded").equalsIgnoreCase("true"))) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (func.getClient().isConnected()) {
                SimpleBinaryMessageClient client = new SimpleBinaryMessageClient((packet, cl) -> {
                    FuncResult res = new FuncResult();
                    res.continueRun = packet.data[0] == 1;
                    cl.container = res;
                    return true;
                }, func.getClient().getInputStream(), func.getClient().getOutputStream());
                client.startAsync();
                manager.runForAllAccounts(t -> {
                    boolean res = true;
                    client.container = null;
                    try {
                        client.send(t.getAccountID().getBytes("UTF-8"));
                    }
                    catch (IOException e) {
                        return false;
                    }
                    while (client.container == null && client.isConnected()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    if (client.container == null) {
                        return false;
                    }
                    res = ((FuncResult)client.container).continueRun;
                    return res;
                });
                client.stop();
            }
        });
        return this.response(101, "Switching Protocols");
    }

    @Function(allowedMethods={"POST"}, value="accounts/runForDataChildren")
    public FunctionResult runForDataChildren(FunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasHeader("Upgrade") || !this.getRequest().getHeaderValue("Upgrade").equals("EDGEBINPROT/ACCMANAGER/RUNFORCHILDREN")) {
            return this.response(400, "Bad request");
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("root")) {
            return this.response(400, "Bad request");
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        if (acc == null) {
            return this.response(404, "Account not found");
        }
        this.setResponseHeader("X-Response-ID", UUID.randomUUID().toString());
        this.setResponseHeader("Upgrade", "EDGEBINPROT/ACCMANAGER/RUNFORCHILDREN");
        AsyncTaskManager.runAsync(() -> {
            while (!(!func.getClient().isConnected() || func.getResponse().hasHeader("Upgraded") && func.getResponse().getHeaderValue("Upgraded").equalsIgnoreCase("true"))) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (func.getClient().isConnected()) {
                SimpleBinaryMessageClient client = new SimpleBinaryMessageClient((packet, cl) -> {
                    FuncResult res = new FuncResult();
                    res.continueRun = packet.data[0] == 1;
                    cl.container = res;
                    return true;
                }, func.getClient().getInputStream(), func.getClient().getOutputStream());
                client.startAsync();
                try {
                    acc.getAccountData().unsafeAccessor().runForChildren(t -> {
                        boolean res = true;
                        client.container = null;
                        try {
                            client.send(t.getBytes("UTF-8"));
                        }
                        catch (IOException e) {
                            return false;
                        }
                        while (client.container == null && client.isConnected()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (client.container == null) {
                            return false;
                        }
                        res = ((FuncResult)client.container).continueRun;
                        return res;
                    }, payload.get("root").getAsString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                client.stop();
            }
        });
        return this.response(101, "Switching Protocols");
    }

    @Function(allowedMethods={"POST"}, value="accounts/runForDataEntries")
    public FunctionResult runForDataEntries(FunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasHeader("Upgrade") || !this.getRequest().getHeaderValue("Upgrade").equals("EDGEBINPROT/ACCMANAGER/RUNFOR")) {
            return this.response(400, "Bad request");
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("root")) {
            return this.response(400, "Bad request");
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        if (acc == null) {
            return this.response(404, "Account not found");
        }
        this.setResponseHeader("X-Response-ID", UUID.randomUUID().toString());
        this.setResponseHeader("Upgrade", "EDGEBINPROT/ACCMANAGER/RUNFOR");
        AsyncTaskManager.runAsync(() -> {
            while (!(!func.getClient().isConnected() || func.getResponse().hasHeader("Upgraded") && func.getResponse().getHeaderValue("Upgraded").equalsIgnoreCase("true"))) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (func.getClient().isConnected()) {
                SimpleBinaryMessageClient client = new SimpleBinaryMessageClient((packet, cl) -> {
                    FuncResult res = new FuncResult();
                    res.continueRun = packet.data[0] == 1;
                    cl.container = res;
                    return true;
                }, func.getClient().getInputStream(), func.getClient().getOutputStream());
                client.startAsync();
                try {
                    acc.getAccountData().unsafeAccessor().runFor((name, data) -> {
                        boolean res = true;
                        client.container = null;
                        try {
                            ByteArrayOutputStream resD = new ByteArrayOutputStream();
                            byte[] b = name.getBytes("UTF-8");
                            resD.write(ByteBuffer.allocate(4).putInt(b.length).array());
                            resD.write(b);
                            b = data.toString().getBytes("UTF-8");
                            resD.write(ByteBuffer.allocate(4).putInt(b.length).array());
                            resD.write(b);
                            client.send(resD.toByteArray());
                        }
                        catch (IOException e) {
                            return false;
                        }
                        while (client.container == null && client.isConnected()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (client.container == null) {
                            return false;
                        }
                        res = ((FuncResult)client.container).continueRun;
                        return res;
                    }, payload.get("root").getAsString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                client.stop();
            }
        });
        return this.response(101, "Switching Protocols");
    }

    @Function(allowedMethods={"POST"}, value="accounts/runForSaveDataChildren")
    public FunctionResult runForSaveDataChildren(FunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasHeader("Upgrade") || !this.getRequest().getHeaderValue("Upgrade").equals("EDGEBINPROT/ACCMANAGER/RUNFORCHILDREN")) {
            return this.response(400, "Bad request");
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("root")) {
            return this.response(400, "Bad request");
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        if (acc == null) {
            return this.response(404, "Account not found");
        }
        AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
        if (cont == null) {
            return this.response(404, "Save not found");
        }
        this.setResponseHeader("X-Response-ID", UUID.randomUUID().toString());
        this.setResponseHeader("Upgrade", "EDGEBINPROT/ACCMANAGER/RUNFORCHILDREN");
        AsyncTaskManager.runAsync(() -> {
            while (!(!func.getClient().isConnected() || func.getResponse().hasHeader("Upgraded") && func.getResponse().getHeaderValue("Upgraded").equalsIgnoreCase("true"))) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (func.getClient().isConnected()) {
                SimpleBinaryMessageClient client = new SimpleBinaryMessageClient((packet, cl) -> {
                    FuncResult res = new FuncResult();
                    res.continueRun = packet.data[0] == 1;
                    cl.container = res;
                    return true;
                }, func.getClient().getInputStream(), func.getClient().getOutputStream());
                client.startAsync();
                try {
                    cont.getSaveData().unsafeAccessor().runForChildren(t -> {
                        boolean res = true;
                        client.container = null;
                        try {
                            client.send(t.getBytes("UTF-8"));
                        }
                        catch (IOException e) {
                            return false;
                        }
                        while (client.container == null && client.isConnected()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (client.container == null) {
                            return false;
                        }
                        res = ((FuncResult)client.container).continueRun;
                        return res;
                    }, payload.get("root").getAsString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                client.stop();
            }
        });
        return this.response(101, "Switching Protocols");
    }

    @Function(allowedMethods={"POST"}, value="accounts/runForSaveDataEntries")
    public FunctionResult runForSaveDataEntries(FunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasHeader("Upgrade") || !this.getRequest().getHeaderValue("Upgrade").equals("EDGEBINPROT/ACCMANAGER/RUNFOR")) {
            return this.response(400, "Bad request");
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!(payload.has("id") && payload.has("save") && payload.has("root"))) {
            return this.response(400, "Bad request");
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        if (acc == null) {
            return this.response(404, "Account not found");
        }
        AccountSaveContainer cont = acc.getSave(payload.get("save").getAsString());
        if (cont == null) {
            return this.response(404, "Save not found");
        }
        this.setResponseHeader("X-Response-ID", UUID.randomUUID().toString());
        this.setResponseHeader("Upgrade", "EDGEBINPROT/ACCMANAGER/RUNFOR");
        AsyncTaskManager.runAsync(() -> {
            while (!(!func.getClient().isConnected() || func.getResponse().hasHeader("Upgraded") && func.getResponse().getHeaderValue("Upgraded").equalsIgnoreCase("true"))) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (func.getClient().isConnected()) {
                SimpleBinaryMessageClient client = new SimpleBinaryMessageClient((packet, cl) -> {
                    FuncResult res = new FuncResult();
                    res.continueRun = packet.data[0] == 1;
                    cl.container = res;
                    return true;
                }, func.getClient().getInputStream(), func.getClient().getOutputStream());
                client.startAsync();
                try {
                    cont.getSaveData().unsafeAccessor().runFor((name, data) -> {
                        boolean res = true;
                        client.container = null;
                        try {
                            ByteArrayOutputStream resD = new ByteArrayOutputStream();
                            byte[] b = name.getBytes("UTF-8");
                            resD.write(ByteBuffer.allocate(4).putInt(b.length).array());
                            resD.write(b);
                            b = data.toString().getBytes("UTF-8");
                            resD.write(ByteBuffer.allocate(4).putInt(b.length).array());
                            resD.write(b);
                            client.send(resD.toByteArray());
                        }
                        catch (IOException e) {
                            return false;
                        }
                        while (client.container == null && client.isConnected()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (client.container == null) {
                            return false;
                        }
                        res = ((FuncResult)client.container).continueRun;
                        return res;
                    }, payload.get("root").getAsString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                client.stop();
            }
        });
        return this.response(101, "Switching Protocols");
    }

    @Function(allowedMethods={"POST"}, value="accounts/deleteContainer")
    public FunctionResult deleteContainer(FunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (!this.getRequest().hasRequestBody()) {
            return this.response(400, "Bad request");
        }
        JsonObject payload = JsonParser.parseString((String)this.getRequestBodyAsString()).getAsJsonObject();
        if (!payload.has("id") || !payload.has("root")) {
            return this.response(400, "Bad request");
        }
        AccountObject acc = manager.getAccount(payload.get("id").getAsString());
        JsonObject resp = new JsonObject();
        if (acc != null) {
            acc.getAccountData().unsafeAccessor().deleteContainer(payload.get("root").getAsString());
            resp.addProperty("success", Boolean.valueOf(true));
        } else {
            resp.addProperty("success", Boolean.valueOf(false));
        }
        return this.ok("text/json", resp.toString());
    }

    private class FuncResult {
        public boolean continueRun;

        private FuncResult() {
        }
    }
}

