/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.http.handlers.api.accounts;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.entities.achivements.RankMultiplierInfo;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.commonapi.EdgeCommonApiServer;
import org.asf.edge.commonapi.xmls.auth.UserInfoData;
import org.asf.edge.commonapi.xmls.data.ProfileData;
import org.asf.edge.commonapi.xmls.data.ProfileDataList;

public class ProfileWebServiceProcessor
extends EdgeWebService<EdgeCommonApiServer> {
    private static AccountManager manager;

    public ProfileWebServiceProcessor(EdgeCommonApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new ProfileWebServiceProcessor((EdgeCommonApiServer)this.getServerInstance());
    }

    public String path() {
        return "/ProfileWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        this.setResponseStatus(404, "Not found");
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getProfileTagAll(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfProfileTag", null));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getQuestions(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        SessionToken tkn = new SessionToken();
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        TokenParseResult res = tkn.parseToken(apiToken);
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountObject account = manager.getAccount(tkn.accountID);
        if (account == null || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountSaveContainer save = account.getSave(tkn.saveID);
        InputStream strm = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("questiondata.xml");
        String data = new String(strm.readAllBytes(), "UTF-8");
        strm.close();
        data = data.replace("http://media.jumpstart.com/", "RS_DATA/");
        data = data.replace("https://media.jumpstart.com/", "RS_DATA/");
        data = data.replace("http://media.schoolofdragons.com/", "RS_DATA/");
        data = data.replace("https://media.schoolofdragons.com/", "RS_DATA/");
        this.setResponseContent("text/xml", data);
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUserProfile(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        SessionToken tkn = new SessionToken();
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        TokenParseResult res = tkn.parseToken(apiToken);
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountObject account = manager.getAccount(tkn.accountID);
        if (account == null || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        ProfileData profile = this.getProfile(tkn.saveID, account, req, false);
        if (TextFilterService.getInstance().isFiltered(account.getSave(profile.id).getUsername(), true) && profile.avatar.avatarData.has("DisplayName")) {
            profile.avatar.avatarData.remove("DisplayName");
        }
        this.setResponseContent("text/xml", req.generateXmlValue("UserProfileDisplayData", (Object)profile));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUserProfileByUserID(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountSaveContainer save = account.getSave((String)req.payload.get("userId"));
        if (save == null) {
            save = manager.getSaveByID((String)req.payload.get("userId"));
            if (save == null) {
                this.setResponseStatus(404, "Not found");
                return;
            }
            ProfileData profile = this.getProfile(save.getSaveID(), save.getAccount(), req, true);
            if (TextFilterService.getInstance().isFiltered(save.getUsername(), true) && profile.avatar.avatarData.has("DisplayName")) {
                profile.avatar.avatarData.set("DisplayName", (JsonNode)new TextNode(TextFilterService.getInstance().filterString(save.getUsername(), account.isStrictChatFilterEnabled())));
            }
            this.setResponseContent("text/xml", req.generateXmlValue("UserProfileDisplayData", (Object)profile));
            return;
        }
        ProfileData profile = this.getProfile(save.getSaveID(), account, req, false);
        if (TextFilterService.getInstance().isFiltered(account.getSave(profile.id).getUsername(), true) && profile.avatar.avatarData.has("DisplayName")) {
            profile.avatar.avatarData.remove("DisplayName");
        }
        this.setResponseContent("text/xml", req.generateXmlValue("UserProfileDisplayData", (Object)profile));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getDetailedChildList(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        SessionToken tkn = new SessionToken();
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("parentApiToken")).toUpperCase());
        TokenParseResult res = tkn.parseToken(apiToken);
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountObject account = manager.getAccount(tkn.accountID);
        if (account == null) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        ProfileDataList lst = new ProfileDataList();
        lst.profiles = (ProfileData[])Stream.of(account.getSaveIDs()).map(id -> {
            try {
                return this.getProfile((String)id, account, req, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).toArray(ProfileData[]::new);
        if (lst.profiles.length != 0) {
            this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfUserProfileDisplayData", (Object)lst));
        } else {
            this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfUserProfileDisplayData", null));
        }
    }

    private ProfileData getProfile(String saveID, AccountObject account, EdgeWebService.ServiceRequestInfo req, boolean minimal) throws IOException {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        AccountSaveContainer save = account.getSave(saveID);
        AccountDataContainer data = save.getSaveData();
        ProfileData profile = new ProfileData();
        profile.avatar = new ProfileData.AvatarBlock();
        profile.id = save.getSaveID();
        if (data.entryExists("avatar")) {
            profile.avatar.avatarData = (ObjectNode)req.parseXmlValue(data.getEntry("avatar").getAsString(), ObjectNode.class);
        }
        UserInfoData info = new UserInfoData();
        info.userID = save.getSaveID();
        if (!minimal) {
            info.parentUserID = account.getAccountID();
        }
        info.username = save.getUsername();
        info.chatEnabled = account.isChatEnabled();
        info.multiplayerEnabled = account.isMultiplayerEnabled();
        info.registrationDate = fmt.format(new Date(account.getRegistrationTimestamp()));
        info.creationDate = fmt.format(new Date(save.getCreationTime()));
        profile.avatar.userInfo = info;
        if (!minimal) {
            AccountDataContainer currency = data.getChildContainer("currency");
            RankMultiplierInfo[] currencyAccWide = account.getAccountData().getChildContainer("currency");
            if (!currencyAccWide.entryExists("gems")) {
                currencyAccWide.setEntry("gems", (JsonElement)new JsonPrimitive((Number)0));
            }
            if (!currency.entryExists("coins")) {
                currency.setEntry("coins", (JsonElement)new JsonPrimitive((Number)300));
            }
            profile.gemCount = currencyAccWide.getEntry("gems").getAsInt();
            profile.coinCount = currency.getEntry("coins").getAsInt();
        }
        if (!minimal) {
            ArrayList<ProfileData.AvatarBlock.RewardMultiplierBlock> multipliers = new ArrayList<ProfileData.AvatarBlock.RewardMultiplierBlock>();
            for (RankMultiplierInfo rankMultiplierInfo : AchievementManager.getInstance().getUserRankMultipliers(save)) {
                ProfileData.AvatarBlock.RewardMultiplierBlock multiplier = new ProfileData.AvatarBlock.RewardMultiplierBlock();
                multiplier.expiryTime = fmt.format(new Date(rankMultiplierInfo.getExpiryTime()));
                multiplier.multiplierFactor = rankMultiplierInfo.getMultiplicationFactor();
                multiplier.typeID = rankMultiplierInfo.getPointType().getPointTypeID();
                multipliers.add(multiplier);
            }
            profile.avatar.rewardMultipliers = (ProfileData.AvatarBlock.RewardMultiplierBlock[])multipliers.toArray(ProfileData.AvatarBlock.RewardMultiplierBlock[]::new);
        }
        if (!minimal) {
            profile.avatar.subscription = new ProfileData.AvatarBlock.SubscriptionBlock();
            profile.avatar.subscription.accountID = account.getAccountID();
        }
        ArrayList<ProfileData.AvatarBlock.AchievementBlock> ranks = new ArrayList<ProfileData.AvatarBlock.AchievementBlock>();
        for (RankMultiplierInfo rankMultiplierInfo : AchievementManager.getInstance().getRanks(save, saveID)) {
            ProfileData.AvatarBlock.AchievementBlock block = new ProfileData.AvatarBlock.AchievementBlock();
            block.saveID = rankMultiplierInfo.getEntityID();
            block.pointsTotal = rankMultiplierInfo.getTotalScore();
            block.pointTypeID = rankMultiplierInfo.getTypeID().getPointTypeID();
            block.rank = AchievementManager.getInstance().getRankIndex(rankMultiplierInfo.getRank()) + 1;
            ranks.add(block);
        }
        profile.avatar.achievements = (ProfileData.AvatarBlock.AchievementBlock[])ranks.toArray(ProfileData.AvatarBlock.AchievementBlock[]::new);
        if (!minimal) {
            profile.answerData = new ProfileData.AnswerBlock();
            profile.answerData.userID = save.getSaveID();
            if (!data.entryExists("answerdata")) {
                data.setEntry("answerdata", (JsonElement)new JsonObject());
            }
            JsonObject answerMap = data.getEntry("answerdata").getAsJsonObject();
            profile.answerData.answers = new ProfileData.AnswerBlock.AnswerDataBlock[answerMap.size()];
            int i = 0;
            for (String string : answerMap.keySet()) {
                ProfileData.AnswerBlock.AnswerDataBlock a = new ProfileData.AnswerBlock.AnswerDataBlock();
                a.answerID = answerMap.get(string).getAsInt();
                a.questionID = Integer.parseInt(string);
                profile.answerData.answers[i++] = a;
            }
        }
        if (TextFilterService.getInstance().isFiltered(save.getUsername(), true) && profile.avatar.avatarData != null && profile.avatar.avatarData.has("DisplayName")) {
            profile.avatar.avatarData.set("DisplayName", (JsonNode)new TextNode("Viking-" + save.getSaveID()));
        }
        return profile;
    }
}

