/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.textfilter.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.events.textfilter.TextFilterLoadEvent;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.textfilter.FilterMode;
import org.asf.edge.common.services.textfilter.FilterSeverity;
import org.asf.edge.common.services.textfilter.PhraseFilter;
import org.asf.edge.common.services.textfilter.PhraseFilterSet;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.common.services.textfilter.result.FilterResult;
import org.asf.edge.common.services.textfilter.result.WordMatch;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class TextFilterServiceImpl
extends TextFilterService {
    private HashMap<String, PhraseFilterSet> filters = new HashMap();
    private long lastReloadTime;

    @Override
    public void initService() {
        CommonDataContainer cont = CommonDataManager.getInstance().getContainer("TEXTFILTER");
        try {
            if (!cont.entryExists("lastreload")) {
                this.lastReloadTime = System.currentTimeMillis();
                cont.setEntry("lastreload", (JsonElement)new JsonPrimitive((Number)this.lastReloadTime));
            } else {
                this.lastReloadTime = cont.getEntry("lastreload").getAsLong();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AsyncTaskManager.runAsync(() -> {
            while (true) {
                try {
                    long reload = cont.getEntry("lastreload").getAsLong();
                    if (reload > this.lastReloadTime) {
                        this.lastReloadTime = reload;
                        this.loadData();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        });
        this.loadData();
    }

    private void loadData() {
        HashMap<String, PhraseFilterSet> filters = new HashMap<String, PhraseFilterSet>();
        try {
            File filter = new File("textfilter");
            if (!filter.exists()) {
                filter.mkdirs();
                InputStream strm = this.getClass().getClassLoader().getResourceAsStream("defaultfilters/alwaysfilter.etfd");
                FileOutputStream strmO = new FileOutputStream(new File(filter, "alwaysfilter.etfd"));
                strm.transferTo(strmO);
                strmO.close();
                strm.close();
                strm = this.getClass().getClassLoader().getResourceAsStream("defaultfilters/instamute.etfd");
                strmO = new FileOutputStream(new File(filter, "instamute.etfd"));
                strm.transferTo(strmO);
                strmO.close();
                strm.close();
                strm = this.getClass().getClassLoader().getResourceAsStream("defaultfilters/userfilter.etfd");
                strmO = new FileOutputStream(new File(filter, "userfilter.etfd"));
                strm.transferTo(strmO);
                strmO.close();
                strm.close();
            }
            this.loadFilters(filter, filters);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.filters = filters;
        EventBus.getInstance().dispatchEvent((EventObject)new TextFilterLoadEvent(this));
    }

    private void loadFilters(File filter, HashMap<String, PhraseFilterSet> filters) {
        for (File d : filter.listFiles(t -> t.isDirectory())) {
            this.loadFilters(d, filters);
        }
        for (File f : filter.listFiles(t -> t.isFile() && t.getName().endsWith(".etfd"))) {
            try {
                String name = null;
                String desc = null;
                String reason = null;
                FilterSeverity severity = FilterSeverity.NONE;
                boolean inBlock = false;
                String phrase = null;
                FilterSeverity phraseSeverity = FilterSeverity.NONE;
                String phraseReason = null;
                ArrayList<String> variants = new ArrayList<String>();
                ArrayList<FilterMode> modes = new ArrayList<FilterMode>();
                PhraseFilterSet set = null;
                int ln = 0;
                for (String line : Files.readAllLines(f.toPath())) {
                    String command;
                    ++ln;
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    while (line.startsWith(" ")) {
                        line = line.substring(1);
                    }
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    String args = command = line.trim();
                    if (!command.equals("Endphrase") && !command.contains(" ")) {
                        throw new IOException("No argument for command " + command + " (" + f.getPath() + ", line " + ln + ")");
                    }
                    if (!command.equals("Endphrase")) {
                        if ((args = args.substring(args.indexOf(" ") + 1).trim()).isBlank()) {
                            throw new IOException("No argument for command " + command + " (" + f.getPath() + ", line " + ln + ")");
                        }
                        command = command.substring(0, command.indexOf(" "));
                    }
                    switch (command.toLowerCase()) {
                        case "name": {
                            name = args;
                            break;
                        }
                        case "description": {
                            desc = args;
                            break;
                        }
                        case "reason": {
                            if (!inBlock) {
                                reason = args;
                                break;
                            }
                            phraseReason = args;
                            break;
                        }
                        case "severity": {
                            FilterSeverity s = switch (args.toLowerCase()) {
                                case "always_filtered" -> FilterSeverity.ALWAYS_FILTERED;
                                case "user_strict_mode" -> FilterSeverity.USER_STRICT_MODE;
                                case "instamute" -> FilterSeverity.INSTAMUTE;
                                default -> throw new IOException("Invalid severity: " + args + " (" + f.getPath() + ", line " + ln + ")");
                            };
                            if (inBlock) {
                                phraseSeverity = s;
                                break;
                            }
                            severity = s;
                            break;
                        }
                        case "variant": {
                            variants.add(args);
                            break;
                        }
                        case "mode": {
                            FilterMode m = switch (args.toLowerCase()) {
                                case "whole_phrase" -> FilterMode.WHOLE_PHRASE;
                                case "phrase_combined" -> FilterMode.PHRASE_COMBINED;
                                case "word_contains" -> FilterMode.WORD_CONTAINS;
                                case "word_combined" -> FilterMode.WORD_COMBINED;
                                default -> throw new IOException("Invalid mode: " + args + " (" + f.getPath() + ", line " + ln + ")");
                            };
                            if (!inBlock) {
                                throw new IOException("Unexpected mode command (" + f.getPath() + ", line " + ln + ")");
                            }
                            modes.add(m);
                            break;
                        }
                        case "phrase": {
                            if (name == null) {
                                throw new IOException("No set name assigned (" + f.getPath() + ", line " + ln + ")");
                            }
                            if (desc == null) {
                                throw new IOException("No set description assigned (" + f.getPath() + ", line " + ln + ")");
                            }
                            if (reason == null) {
                                throw new IOException("No set reason assigned (" + f.getPath() + ", line " + ln + ")");
                            }
                            if (set == null) {
                                set = new PhraseFilterSet(name, desc, reason);
                            }
                            phraseSeverity = severity;
                            phraseReason = reason;
                            phrase = args;
                            inBlock = true;
                            break;
                        }
                        case "endphrase": {
                            if (!inBlock) {
                                throw new IOException("Cannot end a nonexistent phrase (" + f.getPath() + ", line " + ln + ")");
                            }
                            if (phraseSeverity == FilterSeverity.NONE) {
                                throw new IOException("No phrase severity assigned (" + f.getPath() + ", line " + ln + ")");
                            }
                            if (modes.size() == 0) {
                                throw new IOException("No phrase filter modes assigned (" + f.getPath() + ", line " + ln + ")");
                            }
                            set.addPhraseFilter(phraseSeverity, (FilterMode[])modes.toArray(FilterMode[]::new), phraseReason, phrase, (String[])variants.toArray(String[]::new));
                            modes.clear();
                            variants.clear();
                            phraseReason = null;
                            phrase = null;
                            phraseSeverity = FilterSeverity.NONE;
                            inBlock = false;
                        }
                    }
                }
                if (inBlock) {
                    throw new IOException("Unclosed filter phrase block (" + f.getPath() + ", line " + ln + ")");
                }
                if (name == null) {
                    throw new IOException("No set name assigned (" + f.getPath() + ", line " + ln + ")");
                }
                if (desc == null) {
                    throw new IOException("No set description assigned (" + f.getPath() + ", line " + ln + ")");
                }
                if (reason == null) {
                    throw new IOException("No set reason assigned (" + f.getPath() + ", line " + ln + ")");
                }
                if (set == null) {
                    set = new PhraseFilterSet(name, desc, reason);
                }
                filters.put(set.getSetName().toLowerCase(), set);
            }
            catch (IOException e) {
                LogManager.getLogger().error("Failed to load filter: " + f.getPath(), (Throwable)e);
            }
        }
    }

    @Override
    public PhraseFilterSet[] getFilterSets() {
        return (PhraseFilterSet[])this.filters.values().toArray(PhraseFilterSet[]::new);
    }

    @Override
    public PhraseFilterSet getFilterSet(String name) {
        return this.filters.get(name.toLowerCase());
    }

    @Override
    public void addFilterSet(PhraseFilterSet set) {
        if (this.filters.containsKey(set.getSetName().toLowerCase())) {
            throw new IllegalArgumentException("Filter with name '" + set.getSetName() + "' already exists");
        }
        this.filters.put(set.getSetName().toLowerCase(), set);
    }

    private boolean match(FilterMode mode, String text, String filterWord, String filterVariant) {
        if (filterVariant.contains(" ")) {
            String textFull = " " + text + " ";
            if ((mode == FilterMode.WHOLE_PHRASE || mode == FilterMode.PHRASE_COMBINED) && textFull.toLowerCase().contains(" " + filterVariant.toLowerCase() + " ")) {
                return true;
            }
            if (mode == FilterMode.PHRASE_COMBINED) {
                if (textFull.toLowerCase().contains(" " + filterVariant.replace(" ", "").toLowerCase() + " ")) {
                    return true;
                }
            } else if (mode == FilterMode.WORD_CONTAINS || mode == FilterMode.WORD_COMBINED) {
                boolean match = false;
                boolean foundStart = false;
                String[] variantWords = filterVariant.split(" ");
                int i = 1;
                if (variantWords.length != 0) {
                    String firstVariant = variantWords[0];
                    for (String word : text.split(" ")) {
                        if (!foundStart) {
                            if (!word.toLowerCase().contains(firstVariant.toLowerCase())) continue;
                            foundStart = true;
                            match = true;
                            continue;
                        }
                        if (i == variantWords.length) break;
                        if (word.toLowerCase().contains(variantWords[i++].toLowerCase())) continue;
                        match = false;
                        foundStart = false;
                        i = 1;
                    }
                    if (i == variantWords.length && match) {
                        return true;
                    }
                }
            }
            if (mode == FilterMode.WORD_COMBINED && this.match(FilterMode.WORD_CONTAINS, text, filterWord, filterVariant.replace(" ", "").toLowerCase())) {
                return true;
            }
        }
        return filterWord != null && !filterVariant.contains(" ") && (mode == FilterMode.WHOLE_PHRASE || mode == FilterMode.PHRASE_COMBINED ? filterWord.equalsIgnoreCase(filterVariant) : (mode == FilterMode.PHRASE_COMBINED ? filterWord.equalsIgnoreCase(filterVariant.replace(" ", "").toLowerCase()) : (mode == FilterMode.WORD_CONTAINS || mode == FilterMode.WORD_COMBINED ? filterWord.contains(filterVariant) : mode == FilterMode.WORD_COMBINED && filterWord.toLowerCase().contains(filterVariant.replace(" ", "").toLowerCase()))));
    }

    @Override
    public boolean isFiltered(String text, boolean strictMode) {
        if (this.filters.values().stream().anyMatch(t -> Stream.of(t.getFilteredPhrases()).anyMatch(filter -> {
            if (strictMode || filter.getSeverity() != FilterSeverity.USER_STRICT_MODE) {
                for (FilterMode mode : filter.getModes()) {
                    if (mode == FilterMode.WHOLE_PHRASE || mode == FilterMode.PHRASE_COMBINED || mode == FilterMode.WORD_CONTAINS || mode == FilterMode.WORD_COMBINED) continue;
                    if (this.match(mode, text, null, filter.getPhrase())) {
                        return true;
                    }
                    for (String variant : filter.getVariants()) {
                        if (!this.match(mode, null, text, variant)) continue;
                        return true;
                    }
                }
            }
            return false;
        }))) {
            return true;
        }
        for (String word : text.split(" ")) {
            String filterWord = word.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
            if (!this.filters.values().stream().anyMatch(t -> Stream.of(t.getFilteredPhrases()).anyMatch(filter -> {
                if (strictMode || filter.getSeverity() != FilterSeverity.USER_STRICT_MODE) {
                    for (FilterMode mode : filter.getModes()) {
                        if (mode != FilterMode.WHOLE_PHRASE && mode != FilterMode.PHRASE_COMBINED && mode != FilterMode.WORD_CONTAINS && mode != FilterMode.WORD_COMBINED) continue;
                        if (this.match(mode, text, filterWord, filter.getPhrase())) {
                            return true;
                        }
                        for (String variant : filter.getVariants()) {
                            if (!this.match(mode, text, filterWord, variant)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldFilterMute(String text) {
        if (this.filters.values().stream().anyMatch(t -> Stream.of(t.getFilteredPhrases()).anyMatch(filter -> {
            if (filter.getSeverity() == FilterSeverity.INSTAMUTE) {
                for (FilterMode mode : filter.getModes()) {
                    if (mode == FilterMode.WHOLE_PHRASE || mode == FilterMode.PHRASE_COMBINED || mode == FilterMode.WORD_CONTAINS || mode == FilterMode.WORD_COMBINED) continue;
                    if (this.match(mode, text, null, filter.getPhrase())) {
                        return true;
                    }
                    for (String variant : filter.getVariants()) {
                        if (!this.match(mode, null, text, variant)) continue;
                        return true;
                    }
                }
            }
            return false;
        }))) {
            return true;
        }
        for (String word : text.split(" ")) {
            String filterWord = word.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
            if (!this.filters.values().stream().anyMatch(t -> Stream.of(t.getFilteredPhrases()).anyMatch(filter -> {
                if (filter.getSeverity() == FilterSeverity.INSTAMUTE) {
                    for (FilterMode mode : filter.getModes()) {
                        if (mode != FilterMode.WHOLE_PHRASE && mode != FilterMode.PHRASE_COMBINED && mode != FilterMode.WORD_CONTAINS && mode != FilterMode.WORD_COMBINED) continue;
                        if (this.match(mode, text, filterWord, filter.getPhrase())) {
                            return true;
                        }
                        for (String variant : filter.getVariants()) {
                            if (!this.match(mode, text, filterWord, variant)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }))) continue;
            return true;
        }
        return false;
    }

    @Override
    public FilterResult filter(String text, boolean strictMode) {
        ArrayList<WordMatch> matches = new ArrayList<WordMatch>();
        ArrayList<String> matchedPhrases = new ArrayList<String>();
        for (PhraseFilterSet set : this.filters.values()) {
            for (PhraseFilter filter : set.getFilteredPhrases()) {
                if (!strictMode && filter.getSeverity() == FilterSeverity.USER_STRICT_MODE) continue;
                String[] phrases = filter.getAllPhrases();
                for (FilterMode mode : filter.getModes()) {
                    for (String phrase : phrases) {
                        int i2;
                        String textEnd;
                        int i;
                        boolean match;
                        if (!phrase.contains(" ")) {
                            do {
                                match = false;
                                i = 0;
                                for (String word : ((String)text).split(" ")) {
                                    if ((mode == FilterMode.WORD_CONTAINS || mode == FilterMode.WORD_COMBINED) && word.toLowerCase().contains(phrase.toLowerCase()) || (mode == FilterMode.WHOLE_PHRASE || mode == FilterMode.PHRASE_COMBINED) && word.equalsIgnoreCase(phrase)) {
                                        Object textStart = ((String)text).substring(0, i);
                                        textEnd = ((String)text).substring(i + word.length());
                                        for (i2 = 0; i2 < word.length(); ++i2) {
                                            textStart = (String)textStart + "#";
                                        }
                                        text = (String)textStart + textEnd;
                                        if (!matchedPhrases.contains(phrase.toLowerCase())) {
                                            matchedPhrases.add(phrase.toLowerCase());
                                            matches.add(new WordMatch(filter, phrase));
                                        }
                                        match = true;
                                    }
                                    i += word.length() + 1;
                                }
                            } while (match);
                        } else {
                            String[] variantWords = phrase.split(" ");
                            String[] words = ((String)text).split(" ");
                            while (true) {
                                int i3 = 1;
                                boolean match2 = false;
                                boolean foundStart = false;
                                int startIndex = 0;
                                int endIndex = 0;
                                if (variantWords.length == 0) continue;
                                String firstVariant = variantWords[0];
                                int ind = 0;
                                for (String word : words) {
                                    if (!foundStart) {
                                        if ((mode == FilterMode.WORD_CONTAINS || mode == FilterMode.WORD_COMBINED) && word.toLowerCase().contains(firstVariant.toLowerCase()) || (mode == FilterMode.WHOLE_PHRASE || mode == FilterMode.PHRASE_COMBINED) && word.equalsIgnoreCase(firstVariant)) {
                                            foundStart = true;
                                            startIndex = ind;
                                            match2 = true;
                                        }
                                    } else {
                                        if (i3 == variantWords.length) break;
                                        if ((mode == FilterMode.WORD_CONTAINS || mode == FilterMode.WORD_COMBINED) && !word.toLowerCase().contains(variantWords[i3++].toLowerCase()) || (mode == FilterMode.WHOLE_PHRASE || mode == FilterMode.PHRASE_COMBINED) && !word.equalsIgnoreCase(variantWords[i3++])) {
                                            match2 = false;
                                            foundStart = false;
                                            i3 = 1;
                                        }
                                    }
                                    ++ind;
                                }
                                if (i3 == variantWords.length) {
                                    endIndex = ind - 1;
                                    if (match2) {
                                        int ind2 = 0;
                                        int ind3 = 0;
                                        Object textStart = "";
                                        String textEnd2 = "";
                                        boolean startFound = false;
                                        for (String word : words) {
                                            int i22;
                                            if (ind2 == startIndex) {
                                                textStart = ((String)text).substring(0, ind3);
                                                startFound = true;
                                                for (i22 = 0; i22 < word.length(); ++i22) {
                                                    textStart = (String)textStart + "#";
                                                }
                                            } else if (ind2 == endIndex) {
                                                textEnd2 = ((String)text).substring(ind3 + word.length());
                                                startFound = false;
                                                textStart = (String)textStart + " ";
                                                for (i22 = 0; i22 < word.length(); ++i22) {
                                                    textStart = (String)textStart + "#";
                                                }
                                            } else if (startFound) {
                                                textStart = (String)textStart + " ";
                                                for (i22 = 0; i22 < word.length(); ++i22) {
                                                    textStart = (String)textStart + "#";
                                                }
                                            }
                                            ind3 += word.length() + 1;
                                            ++ind2;
                                        }
                                        text = (String)textStart + textEnd2;
                                        words = ((String)text).split(" ");
                                        if (!matchedPhrases.contains(phrase.toLowerCase())) {
                                            matchedPhrases.add(phrase.toLowerCase());
                                            matches.add(new WordMatch(filter, phrase));
                                        }
                                    }
                                }
                                if (i3 != variantWords.length) {
                                    match2 = false;
                                }
                                if (!match2) break;
                            }
                        }
                        if (mode != FilterMode.WORD_COMBINED && mode != FilterMode.PHRASE_COMBINED) continue;
                        phrase = phrase.replace(" ", "");
                        do {
                            match = false;
                            i = 0;
                            for (String word : ((String)text).split(" ")) {
                                if (mode == FilterMode.WORD_COMBINED && word.toLowerCase().contains(phrase.toLowerCase()) || mode == FilterMode.PHRASE_COMBINED && word.equalsIgnoreCase(phrase)) {
                                    Object textStart = ((String)text).substring(0, i);
                                    textEnd = ((String)text).substring(i + word.length());
                                    for (i2 = 0; i2 < word.length(); ++i2) {
                                        textStart = (String)textStart + "#";
                                    }
                                    text = (String)textStart + textEnd;
                                    if (!matchedPhrases.contains(phrase.toLowerCase())) {
                                        matchedPhrases.add(phrase.toLowerCase());
                                        matches.add(new WordMatch(filter, phrase));
                                    }
                                    match = true;
                                }
                                i += word.length() + 1;
                            }
                        } while (match);
                    }
                }
            }
        }
        return new FilterResult((WordMatch[])matches.toArray(WordMatch[]::new), (String)text);
    }

    @Override
    public void reload() {
        this.loadData();
    }
}

