/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.BasicAccountManager;
import org.asf.edge.common.services.accounts.impl.BasicAccountObject;
import org.asf.edge.common.services.minigamedata.MinigameDataManager;
import org.asf.edge.common.services.textfilter.TextFilterService;

public abstract class BasicAccountSaveContainer
extends AccountSaveContainer {
    private long time;
    private String saveID;
    private String username;
    private String accID;
    private Logger logger = LogManager.getLogger((String)"AccountManager");
    private BasicAccountManager manager;
    private BasicAccountObject acc;
    private AccountDataContainer data;

    public BasicAccountSaveContainer(String saveID, long time, String username, String accID, BasicAccountManager manager, BasicAccountObject acc) {
        this.acc = acc;
        this.manager = manager;
        this.saveID = saveID;
        this.time = time;
        this.username = username;
        this.accID = accID;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected BasicAccountManager getManager() {
        return this.manager;
    }

    protected BasicAccountObject getAccountObject() {
        return this.acc;
    }

    protected String getAccountID() {
        return this.accID;
    }

    public abstract boolean performUpdateUsername(String var1);

    protected abstract AccountDataContainer retrieveSaveData();

    @Override
    public long getCreationTime() {
        return this.time;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getSaveID() {
        return this.saveID;
    }

    @Override
    public AccountObject getAccount() {
        return this.acc;
    }

    @Override
    public boolean updateUsername(String name) {
        if (name.equalsIgnoreCase(this.username)) {
            return true;
        }
        if (!this.manager.isValidUsername(name)) {
            return false;
        }
        if (!this.acc.getUsername().equalsIgnoreCase(name) && this.manager.isUsernameTaken(name)) {
            return false;
        }
        BasicAccountObject accF = this.acc;
        if (Stream.of(this.acc.getSaveIDs()).map(t -> accF.getSave((String)t)).anyMatch(t -> {
            try {
                return t.getUsername().equalsIgnoreCase(name) && t.getSaveData().entryExists("avatar");
            }
            catch (IOException e) {
                return false;
            }
        })) {
            return false;
        }
        if (TextFilterService.getInstance().isFiltered(name, true)) {
            return false;
        }
        if (this.performUpdateUsername(name)) {
            this.username = name;
            return true;
        }
        return false;
    }

    protected abstract void doDeleteSave();

    @Override
    public void deleteSave() {
        this.doDeleteSave();
        MinigameDataManager.getInstance().deleteDataFor(this.saveID);
        this.acc.refreshSaveList();
    }

    @Override
    public AccountDataContainer getSaveData() {
        if (this.data == null) {
            this.data = this.retrieveSaveData();
        }
        return this.data;
    }
}

