/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.mmoserver.networking.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.mmoserver.networking.SmartfoxClient;
import org.asf.edge.mmoserver.networking.SmartfoxServer;
import org.asf.edge.mmoserver.networking.bitswarm.BitswarmClient;
import org.asf.edge.mmoserver.networking.impl.BitswarmSmartfoxClient;

public class BitswarmSmartfoxServer
extends SmartfoxServer {
    private String address;
    private int port;
    private ServerSocket sockTcp;
    private boolean connected = false;
    private ArrayList<BitswarmClientContainer> clients = new ArrayList();

    public BitswarmSmartfoxServer(String address, int port) {
        this.address = address;
        this.port = port;
    }

    @Override
    public boolean isRunning() {
        return this.connected;
    }

    @Override
    public void start() throws IOException {
        if (this.sockTcp != null) {
            throw new IOException("Server is already started");
        }
        this.sockTcp = new ServerSocket(this.port, 0, InetAddress.getByName(this.address));
        this.connected = true;
        AsyncTaskManager.runAsync(() -> {
            while (this.isRunning()) {
                Socket sock;
                try {
                    sock = this.sockTcp.accept();
                }
                catch (IOException e) {
                    continue;
                }
                this.getLogger().debug("Client connected: " + sock.getRemoteSocketAddress());
                AsyncTaskManager.runAsync(() -> {
                    try {
                        BitswarmClient bsCl = new BitswarmClient(sock.getInputStream(), sock.getOutputStream());
                        BitswarmSmartfoxClient sfsCl = new BitswarmSmartfoxClient(bsCl, sock, this);
                        if (!this.isRunning()) {
                            throw new IOException("Closed");
                        }
                        BitswarmClientContainer client = new BitswarmClientContainer();
                        client.socket = sock;
                        client.bitswarmClient = bsCl;
                        client.sfsClient = sfsCl;
                        sfsCl.container = client;
                        ArrayList<BitswarmClientContainer> arrayList = this.clients;
                        synchronized (arrayList) {
                            this.clients.add(client);
                        }
                        this.onClientAccepted(sfsCl);
                    }
                    catch (IOException e) {
                        try {
                            sock.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopForced() throws IOException {
        if (!this.connected) {
            return;
        }
        this.getLogger().debug("Stopping server...");
        this.connected = false;
        try {
            this.sockTcp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getLogger().debug("Disconnecting clients...");
        BitswarmClientContainer[] bitswarmClientContainerArray = this.clients;
        synchronized (this.clients) {
            BitswarmClientContainer[] clientLst = (BitswarmClientContainer[])this.clients.toArray(BitswarmClientContainer[]::new);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            for (BitswarmClientContainer client : clientLst) {
                try {
                    client.sfsClient.callDisconnectEventsInternal();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    client.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.clients.clear();
            this.sockTcp = null;
            this.getLogger().debug("SFS server closed!");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        if (!this.connected) {
            return;
        }
        this.getLogger().debug("Stopping server...");
        this.connected = false;
        try {
            this.sockTcp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getLogger().debug("Disconnecting clients...");
        BitswarmClientContainer[] bitswarmClientContainerArray = this.clients;
        synchronized (this.clients) {
            BitswarmClientContainer[] clientLst = (BitswarmClientContainer[])this.clients.toArray(BitswarmClientContainer[]::new);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            for (BitswarmClientContainer client : clientLst) {
                try {
                    client.sfsClient.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.clients.clear();
            this.sockTcp = null;
            this.getLogger().debug("SFS server closed!");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmartfoxClient[] getClients() {
        ArrayList<BitswarmClientContainer> arrayList = this.clients;
        synchronized (arrayList) {
            return (SmartfoxClient[])this.clients.stream().map(t -> t.sfsClient).toArray(SmartfoxClient[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientDisconnect(BitswarmSmartfoxClient client) {
        ArrayList<BitswarmClientContainer> arrayList = this.clients;
        synchronized (arrayList) {
            this.clients.remove(client.container);
        }
        this.getLogger().debug("Client disconnected: " + client.getRemoteAddress());
        try {
            client.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class BitswarmClientContainer {
        public Socket socket;
        public BitswarmClient bitswarmClient;
        public BitswarmSmartfoxClient sfsClient;

        BitswarmClientContainer() {
        }
    }
}

