/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.http.handlers.gameplayapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.gameplayapi.EdgeGameplayApiServer;
import org.asf.edge.gameplayapi.util.InventoryUtils;
import org.asf.edge.gameplayapi.xmls.dragons.DragonData;
import org.asf.edge.gameplayapi.xmls.dragons.PetUpdateRequestData;
import org.asf.edge.gameplayapi.xmls.dragons.PetUpdateResponseData;

public class ContentWebServiceV3Processor
extends EdgeWebService<EdgeGameplayApiServer> {
    private static AccountManager manager;
    private static ItemManager itemManager;

    public ContentWebServiceV3Processor(EdgeGameplayApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new ContentWebServiceV3Processor((EdgeGameplayApiServer)this.getServerInstance());
    }

    public String path() {
        return "/v3/ContentWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        this.setResponseStatus(404, "Not found");
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setRaisedPet(LegacyFunctionInfo func) throws IOException {
        String newName;
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        PetUpdateRequestData request = (PetUpdateRequestData)req.parseXmlValue((String)req.payload.get("request"), PetUpdateRequestData.class);
        AccountSaveContainer save = account.getSave(tkn.saveID);
        AccountDataContainer data = save.getSaveData();
        PetUpdateResponseData resp = new PetUpdateResponseData();
        resp.raisedPetSetResult = 1;
        data = data.getChildContainer("dragons");
        JsonArray dragonIds = new JsonArray();
        if (data.entryExists("dragonlist")) {
            dragonIds = data.getEntry("dragonlist").getAsJsonArray();
        } else {
            data.setEntry("dragonlist", (JsonElement)dragonIds);
        }
        int id = request.dragonData.id;
        if (!data.entryExists("dragon-" + id)) {
            resp.raisedPetSetResult = 3;
            resp.errorMessage = "Dragon ID not found";
            this.setResponseContent("text/xml", req.generateXmlValue("SetRaisedPetResponse", (Object)resp));
            return;
        }
        if (TextFilterService.getInstance().isFiltered(request.dragonData.name, true)) {
            resp.raisedPetSetResult = 4;
            resp.errorMessage = "Invalid name";
            this.setResponseContent("text/xml", req.generateXmlValue("SetRaisedPetResponse", (Object)resp));
            return;
        }
        DragonData cdragon = (DragonData)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), DragonData.class);
        if (!(cdragon.name.equals(request.dragonData.name) || (newName = request.dragonData.name).length() <= 100 && newName.replace(" ", "").length() >= 1)) {
            resp.raisedPetSetResult = 4;
            resp.errorMessage = "Invalid name";
            this.setResponseContent("text/xml", req.generateXmlValue("SetRaisedPetResponse", (Object)resp));
            return;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        DragonData dragonUpdate = request.dragonData;
        if (dragonUpdate.accessories != null) {
            cdragon.accessories = dragonUpdate.accessories;
        }
        if (dragonUpdate.attributes != null) {
            if (cdragon.attributes == null) {
                cdragon.attributes = new ObjectNode[0];
            }
            for (ObjectNode attr : dragonUpdate.attributes) {
                String key = attr.get("k").asText();
                Optional<ObjectNode> optA = Stream.of(cdragon.attributes).filter(t -> t.get("k").asText().equals(key)).findFirst();
                if (optA.isPresent()) {
                    optA.get().set("v", attr.get("v"));
                    optA.get().set("dt", attr.get("dt"));
                    continue;
                }
                int i = 0;
                ObjectNode[] newA = new ObjectNode[cdragon.attributes.length + 1];
                for (i = 0; i < cdragon.attributes.length; ++i) {
                    newA[i] = cdragon.attributes[i];
                }
                newA[i] = attr;
                cdragon.attributes = newA;
            }
        }
        if (dragonUpdate.colors != null) {
            cdragon.colors = dragonUpdate.colors;
        }
        if (dragonUpdate.gender != null) {
            cdragon.gender = dragonUpdate.gender;
        }
        if (dragonUpdate.geometry != null) {
            cdragon.geometry = dragonUpdate.geometry;
        }
        if (dragonUpdate.texture != null) {
            cdragon.texture = dragonUpdate.texture;
        }
        if (dragonUpdate.skills != null) {
            cdragon.skills = dragonUpdate.skills;
        }
        if (dragonUpdate.growthState != null) {
            cdragon.growthState = dragonUpdate.growthState;
        }
        if (dragonUpdate.imagePosition != null) {
            cdragon.imagePosition = dragonUpdate.imagePosition;
        }
        if (dragonUpdate.states != null) {
            cdragon.states = dragonUpdate.states;
        }
        if (dragonUpdate.typeID != null) {
            cdragon.typeID = dragonUpdate.typeID;
        }
        if (dragonUpdate.name != null) {
            cdragon.name = dragonUpdate.name;
        }
        cdragon.updateDate = fmt.format(new Date());
        if (request.setAsSelected) {
            for (JsonElement ele : dragonIds) {
                String did = ele.getAsString();
                ObjectNode ddragon = (ObjectNode)req.parseXmlValue(data.getEntry("dragon-" + did).getAsString(), ObjectNode.class);
                if (!ddragon.get("is").asBoolean()) continue;
                ddragon.set("is", (JsonNode)BooleanNode.FALSE);
                data.setEntry("dragon-" + did, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)ddragon)));
            }
            cdragon.isSelected = true;
        }
        data.setEntry("dragon-" + id, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)cdragon)));
        if (request.commonInventoryRequests != null && request.commonInventoryRequests.length != 0) {
            resp.inventoryUpdate = InventoryUtils.processCommonInventorySet(request.commonInventoryRequests, save.getSaveData(), request.containerID == -1 ? 1 : request.containerID);
        }
        this.setResponseContent("text/xml", req.generateXmlValue("SetRaisedPetResponse", (Object)resp));
    }
}

