/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.ConnectiveHttpServer;
import org.asf.connective.ContentSource;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.services.achievements.impl.AchievementManagerImpl;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.items.impl.ItemManagerImpl;
import org.asf.edge.common.services.leaderboard.LeaderboardManager;
import org.asf.edge.common.services.leaderboard.impl.LeaderboardManagerImpl;
import org.asf.edge.common.services.messages.WsMessageService;
import org.asf.edge.common.services.messages.impl.WsMessageServiceImpl;
import org.asf.edge.common.services.minigamedata.MinigameDataManager;
import org.asf.edge.common.services.minigamedata.impl.MinigameDataManagerImpl;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.common.util.LogWindow;
import org.asf.edge.gameplayapi.commands.CommandContext;
import org.asf.edge.gameplayapi.config.GameplayApiServerConfig;
import org.asf.edge.gameplayapi.events.server.GameplayApiServerSetupEvent;
import org.asf.edge.gameplayapi.events.server.GameplayApiServerStartupEvent;
import org.asf.edge.gameplayapi.http.CaseInsensitiveContentSource;
import org.asf.edge.gameplayapi.http.handlers.achievements.AchievementWebServiceV1Processor;
import org.asf.edge.gameplayapi.http.handlers.achievements.AchievementWebServiceV2Processor;
import org.asf.edge.gameplayapi.http.handlers.edgespecific.EdgeApiService;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.ChallengeWebServiceProcessor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.ContentWebServiceV1Processor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.ContentWebServiceV2Processor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.ContentWebServiceV3Processor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.ContentWebServiceV4Processor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.InviteFriendWebServiceProcessor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.MissionWebServiceProcessor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.MobileStoreWebServiceProcessor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.PaymentWebServiceV1Processor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.PaymentWebServiceV2Processor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.RatingWebServiceV1Processor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.RatingWebServiceV2Processor;
import org.asf.edge.gameplayapi.http.handlers.gameplayapi.ScoreWebServiceProcessor;
import org.asf.edge.gameplayapi.http.handlers.itemstore.ItemStoreWebServiceProcessor;
import org.asf.edge.gameplayapi.permissions.PermissionContext;
import org.asf.edge.gameplayapi.permissions.PermissionLevel;
import org.asf.edge.gameplayapi.services.quests.QuestManager;
import org.asf.edge.gameplayapi.services.quests.impl.QuestManagerImpl;
import org.asf.edge.gameplayapi.util.InventoryUtils;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class EdgeGameplayApiServer
implements IBaseServer {
    public static final String GAMEPLAY_API_VERSION = "1.0.0.A2";
    private Logger logger;
    private GameplayApiServerConfig config;
    private ConnectiveHttpServer server;
    private CommandContext cmdCtx;
    private String accountID;
    private long lastRestartTime;
    private long lastShutdownTime;

    public String getVersion() {
        return GAMEPLAY_API_VERSION;
    }

    static void printSplash() {
        System.out.println("-------------------------------------------------------------");
        System.out.println("                                                             ");
        System.out.println("    EDGE - Fan-made server software for School of Dragons    ");
        System.out.println("            Gameplay API Server Version: 1.0.0.A2            ");
        System.out.println("                                                             ");
        System.out.println("-------------------------------------------------------------");
        System.out.println("");
        System.out.println("This server implements the following endpoints:");
        System.out.println(" - contentserver.api.jumpstart.com");
        System.out.println(" - itemstoremission.api.jumpstart.com");
        System.out.println(" - achievement.api.jumpstart.com");
        System.out.println("");
    }

    public EdgeGameplayApiServer(GameplayApiServerConfig config) {
        this.config = config;
        this.logger = LogManager.getLogger((String)"GAMEPLAYAPI");
    }

    public ConnectiveHttpServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public GameplayApiServerConfig getConfiguration() {
        return this.config;
    }

    public void setupServer() throws IOException {
        if (this.config.server == null) {
            if (this.config.https) {
                props = new HashMap<String, String>();
                props.put("address", this.config.listenAddress);
                props.put("port", Integer.toString(this.config.listenPort));
                props.put("keystore", this.config.tlsKeystore);
                props.put("keystore-password", this.config.tlsKeystorePassword);
                this.config.server = ConnectiveHttpServer.createNetworked((String)"HTTPS/1.1", props);
                this.logger.info("Edge gameplay api HTTPS server created with listen address " + this.config.listenAddress + " and port " + this.config.listenPort);
            } else {
                props = new HashMap();
                props.put("address", this.config.listenAddress);
                props.put("port", Integer.toString(this.config.listenPort));
                this.config.server = ConnectiveHttpServer.createNetworked((String)"HTTP/1.1", props);
                this.logger.info("Edge gameplay api HTTP server created with listen address " + this.config.listenAddress + " and port " + this.config.listenPort);
            }
        }
        this.server = this.config.server;
        this.logger.debug("Adding case-insensitive content source...");
        this.server.setContentSource((ContentSource)new CaseInsensitiveContentSource());
        this.logger.debug("Dispatching event...");
        EventBus.getInstance().dispatchEvent((EventObject)new GameplayApiServerSetupEvent(this.config, this));
        this.logger.debug("Configuring server request handlers...");
        this.server.registerProcessor((HttpPushProcessor)new ContentWebServiceV1Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new ContentWebServiceV2Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new ContentWebServiceV3Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new ContentWebServiceV4Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new RatingWebServiceV1Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new RatingWebServiceV2Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new ChallengeWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new InviteFriendWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new MobileStoreWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new PaymentWebServiceV1Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new PaymentWebServiceV2Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new ScoreWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new ItemStoreWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new MissionWebServiceProcessor(this));
        this.server.registerProcessor((HttpPushProcessor)new AchievementWebServiceV1Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new AchievementWebServiceV2Processor(this));
        this.server.registerProcessor((HttpPushProcessor)new EdgeApiService(this));
        this.logger.info("Binding command handler to GUI terminal...");
        LogWindow.commandCallback = t -> this.executeConsoleCommand((String)t);
        this.logger.info("Setting up item manager...");
        ServiceManager.registerServiceImplementation(ItemManager.class, (AbstractService)new ItemManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(ItemManager.class);
        InventoryUtils.init();
        this.logger.info("Setting up quest manager...");
        ServiceManager.registerServiceImplementation(QuestManager.class, (AbstractService)new QuestManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(QuestManager.class);
        this.logger.info("Setting up achievement manager...");
        ServiceManager.registerServiceImplementation(AchievementManager.class, (AbstractService)new AchievementManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(AchievementManager.class);
        this.logger.info("Setting up message service...");
        ServiceManager.registerServiceImplementation(WsMessageService.class, (AbstractService)new WsMessageServiceImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(WsMessageService.class);
        this.logger.info("Setting up leaderboard manager...");
        ServiceManager.registerServiceImplementation(LeaderboardManager.class, (AbstractService)new LeaderboardManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(LeaderboardManager.class);
        LeaderboardManager.getInstance().registerLeaderboard("UDT");
        this.logger.info("Setting up minigame data manager...");
        ServiceManager.registerServiceImplementation(MinigameDataManager.class, (AbstractService)new MinigameDataManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(MinigameDataManager.class);
        this.logger.info("Loading text filter...");
        TextFilterService.getInstance();
        this.logger.info("Starting shutdown and restart watchdog...");
        CommonDataContainer cont = CommonDataManager.getInstance().getContainer("EDGECOMMON");
        try {
            if (!cont.entryExists("shutdown")) {
                this.lastShutdownTime = System.currentTimeMillis();
                cont.setEntry("shutdown", (JsonElement)new JsonPrimitive((Number)this.lastShutdownTime));
            } else {
                this.lastShutdownTime = cont.getEntry("shutdown").getAsLong();
            }
            if (!cont.entryExists("restart")) {
                this.lastRestartTime = System.currentTimeMillis();
                cont.setEntry("restart", (JsonElement)new JsonPrimitive((Number)this.lastRestartTime));
            } else {
                this.lastRestartTime = cont.getEntry("restart").getAsLong();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AsyncTaskManager.runAsync(() -> {
            while (true) {
                try {
                    long shutdown = cont.getEntry("shutdown").getAsLong();
                    if (shutdown > this.lastShutdownTime && this.isRunning()) {
                        this.stopServer();
                        break;
                    }
                    long restart = cont.getEntry("restart").getAsLong();
                    if (restart > this.lastRestartTime && this.isRunning()) {
                        CommonInit.restartPending = true;
                        this.stopServer();
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    private void executeConsoleCommand(String command) {
        ArrayList<String> args;
        if (command.isEmpty()) {
            return;
        }
        AccountObject acc = null;
        if (this.accountID != null) {
            acc = AccountManager.getInstance().getAccount(this.accountID);
        }
        if (acc == null) {
            this.accountID = null;
            this.cmdCtx = null;
        }
        if ((args = this.parseCommand(command)).size() == 0) {
            return;
        }
        String cmd = (String)args.remove(0);
        switch (cmd.toLowerCase()) {
            case "makeadmin": {
                if (args.size() < 1) {
                    this.logger.error("Usage: makeadmin \"<username>\"");
                    return;
                }
                String id = AccountManager.getInstance().getAccountID((String)args.get(0));
                if (id == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                AccountObject acc2 = AccountManager.getInstance().getAccount(id);
                if (acc2 == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                PermissionContext.getFor(acc2).setPermissionLevel(PermissionLevel.ADMINISTRATOR);
                this.logger.info("Made " + acc2.getUsername() + " admin.");
                if (!acc.getAccountID().equals(acc2.getAccountID())) break;
                acc = acc2;
                this.cmdCtx = CommandContext.getFor(acc);
                break;
            }
            case "makemoderator": {
                if (args.size() < 1) {
                    this.logger.error("Usage: makemoderator \"<username>\"");
                    return;
                }
                String id = AccountManager.getInstance().getAccountID((String)args.get(0));
                if (id == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                AccountObject acc2 = AccountManager.getInstance().getAccount(id);
                if (acc2 == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                PermissionContext.getFor(acc2).setPermissionLevel(PermissionLevel.MODERATOR);
                this.logger.info("Made " + acc2.getUsername() + " moderator.");
                if (!acc.getAccountID().equals(acc2.getAccountID())) break;
                acc = acc2;
                this.cmdCtx = CommandContext.getFor(acc);
                break;
            }
            case "maketrialmod": {
                if (args.size() < 1) {
                    this.logger.error("Usage: maketrialmod \"<username>\"");
                    return;
                }
                String id = AccountManager.getInstance().getAccountID((String)args.get(0));
                if (id == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                AccountObject acc2 = AccountManager.getInstance().getAccount(id);
                if (acc2 == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                PermissionContext.getFor(acc2).setPermissionLevel(PermissionLevel.TRIAL_MODERATOR);
                this.logger.info("Made " + acc2.getUsername() + " trial moderator.");
                if (!acc.getAccountID().equals(acc2.getAccountID())) break;
                acc = acc2;
                this.cmdCtx = CommandContext.getFor(acc);
                break;
            }
            case "makedeveloper": {
                if (args.size() < 1) {
                    this.logger.error("Usage: makedeveloper \"<username>\"");
                    return;
                }
                String id = AccountManager.getInstance().getAccountID((String)args.get(0));
                if (id == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                AccountObject acc2 = AccountManager.getInstance().getAccount(id);
                if (acc2 == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                PermissionContext.getFor(acc2).setPermissionLevel(PermissionLevel.DEVELOPER);
                this.logger.info("Made " + acc2.getUsername() + " developer.");
                if (!acc.getAccountID().equals(acc2.getAccountID())) break;
                acc = acc2;
                this.cmdCtx = CommandContext.getFor(acc);
                break;
            }
            case "makeoperator": {
                if (args.size() < 1) {
                    this.logger.error("Usage: makeoperator \"<username>\"");
                    return;
                }
                String id = AccountManager.getInstance().getAccountID((String)args.get(0));
                if (id == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                AccountObject acc2 = AccountManager.getInstance().getAccount(id);
                if (acc2 == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                PermissionContext.getFor(acc2).setPermissionLevel(PermissionLevel.OPERATOR);
                this.logger.info("Made " + acc2.getUsername() + " operator.");
                if (!acc.getAccountID().equals(acc2.getAccountID())) break;
                acc = acc2;
                this.cmdCtx = CommandContext.getFor(acc);
                break;
            }
            case "stripperms": {
                if (args.size() < 1) {
                    this.logger.error("Usage: stripperms \"<username>\"");
                    return;
                }
                String id = AccountManager.getInstance().getAccountID((String)args.get(0));
                if (id == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                AccountObject acc2 = AccountManager.getInstance().getAccount(id);
                if (acc2 == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                PermissionContext.getFor(acc2).setPermissionLevel(acc2.isGuestAccount() ? PermissionLevel.GUEST : PermissionLevel.PLAYER);
                this.logger.info("Stripped permissions of " + acc2.getUsername() + ".");
                if (!acc.getAccountID().equals(acc2.getAccountID())) break;
                acc = acc2;
                this.cmdCtx = CommandContext.getFor(acc);
                break;
            }
            case "login-as": {
                if (args.size() < 1) {
                    this.logger.error("Usage: login-as \"<username>\"");
                    return;
                }
                String id = AccountManager.getInstance().getAccountID((String)args.get(0));
                if (id == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                acc = AccountManager.getInstance().getAccount(id);
                if (acc == null) {
                    this.logger.error("Username not recognized: " + (String)args.get(0));
                    return;
                }
                this.accountID = id;
                this.cmdCtx = CommandContext.getFor(acc);
                this.logger.info("Logged into the console as " + acc.getUsername());
                this.logger.info("You have access to " + this.cmdCtx.getPermissions().getPermissionLevel().toString().toLowerCase() + " commands.");
                break;
            }
            default: {
                if (this.cmdCtx == null) {
                    this.logger.error("Please use 'login-as \"<username>\"' before using commands.");
                    return;
                }
                this.cmdCtx.runCommand(command, t -> this.logger.info(t));
            }
        }
    }

    private ArrayList<String> parseCommand(String args) {
        ArrayList<String> args3 = new ArrayList<String>();
        char[] argarray = args.toCharArray();
        boolean ignorespaces = false;
        boolean hasData = false;
        Object last = "";
        int i = 0;
        for (char c : args.toCharArray()) {
            if (c == '\"' && (i == 0 || argarray[i - 1] != '\\')) {
                if (ignorespaces) {
                    ignorespaces = false;
                } else {
                    hasData = true;
                    ignorespaces = true;
                }
            } else if (!(c != ' ' || ignorespaces || i != 0 && argarray[i - 1] == '\\')) {
                if (hasData) {
                    args3.add((String)last);
                }
                hasData = false;
                last = "";
            } else if (c != '\\' || i + 1 < argarray.length && argarray[i + 1] != '\"' && (argarray[i + 1] != ' ' || ignorespaces)) {
                hasData = true;
                last = (String)last + c;
            }
            ++i;
        }
        if (!((String)last).isEmpty()) {
            args3.add((String)last);
        }
        return args3;
    }

    public void startServer() throws IOException {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (this.server.isRunning()) {
            throw new IllegalArgumentException("Server is already running");
        }
        this.logger.info("Starting the Gameplay API server...");
        this.server.start();
        EventBus.getInstance().dispatchEvent((EventObject)new GameplayApiServerStartupEvent(this.config, this));
        this.logger.info("Gameplay API server started successfully!");
    }

    public void stopServer() {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (!this.server.isRunning()) {
            throw new IllegalArgumentException("Server is not running");
        }
        this.logger.info("Shutting down the Gameplay API server...");
        try {
            this.server.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("Gameplay API server stopped successfully!");
    }

    public void killServer() {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (!this.server.isRunning()) {
            throw new IllegalArgumentException("Server is not running");
        }
        this.logger.info("Forcefully shutting down the Gameplay API server!");
        try {
            this.server.stopForced();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("Gameplay API server stopped successfully!");
    }

    public boolean isRunning() {
        if (this.server == null) {
            return false;
        }
        return this.server.isRunning();
    }

    public void waitForExit() {
        while (this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

