/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.contentserver;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.ConnectiveHttpServer;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.contentserver.config.ContentServerConfig;
import org.asf.edge.contentserver.events.server.ContentServerSetupEvent;
import org.asf.edge.contentserver.events.server.ContentServerStartupEvent;
import org.asf.edge.contentserver.http.ContentServerRequestHandler;
import org.asf.edge.contentserver.http.postprocessors.ApplicationManifestPreProcessor;
import org.asf.edge.contentserver.http.postprocessors.ServerDownPreprocessor;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class EdgeContentServer
implements IBaseServer {
    public static final String CONTENT_SERVER_VERSION = "1.0.0.A2";
    private Logger logger;
    private ContentServerConfig config;
    private ConnectiveHttpServer server;

    public String getVersion() {
        return CONTENT_SERVER_VERSION;
    }

    static void printSplash() {
        System.out.println("-------------------------------------------------------------");
        System.out.println("                                                             ");
        System.out.println("    EDGE - Fan-made server software for School of Dragons    ");
        System.out.println("               Content Server Version 1.0.0.A2               ");
        System.out.println("                                                             ");
        System.out.println("-------------------------------------------------------------");
        System.out.println("");
        System.out.println("This server implements the following endpoints:");
        System.out.println(" - media.schoolofdragons.com");
        System.out.println("");
    }

    public EdgeContentServer(ContentServerConfig config) {
        this.config = config;
        this.logger = LogManager.getLogger((String)"CONTENTSERVER");
    }

    public ConnectiveHttpServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ContentServerConfig getConfiguration() {
        return this.config;
    }

    public void setupServer() throws IOException {
        if (this.config.server == null) {
            if (this.config.https) {
                props = new HashMap<String, String>();
                props.put("address", this.config.listenAddress);
                props.put("port", Integer.toString(this.config.listenPort));
                props.put("keystore", this.config.tlsKeystore);
                props.put("keystore-password", this.config.tlsKeystorePassword);
                this.config.server = ConnectiveHttpServer.createNetworked((String)"HTTPS/1.1", props);
                this.logger.info("Edge content HTTPS server created with listen address " + this.config.listenAddress + " and port " + this.config.listenPort);
            } else {
                props = new HashMap();
                props.put("address", this.config.listenAddress);
                props.put("port", Integer.toString(this.config.listenPort));
                this.config.server = ConnectiveHttpServer.createNetworked((String)"HTTP/1.1", props);
                this.logger.info("Edge content HTTP server created with listen address " + this.config.listenAddress + " and port " + this.config.listenPort);
            }
        }
        this.server = this.config.server;
        File dataPath = new File(this.config.contentDataPath);
        if (!dataPath.exists()) {
            this.logger.debug("Creating data folder...");
            if (!dataPath.mkdirs()) {
                throw new IOException("Failed to create directory: " + dataPath);
            }
        }
        this.logger.debug("Dispatching event...");
        EventBus.getInstance().dispatchEvent((EventObject)new ContentServerSetupEvent(this.config, this));
        this.logger.debug("Configuring server request handlers...");
        this.server.registerProcessor((HttpPushProcessor)new ContentServerRequestHandler(dataPath, this.config.contentRequestListenPath, new ContentServerRequestHandler.IPreProcessor[]{new ApplicationManifestPreProcessor(), new ServerDownPreprocessor(this.config)}, this));
    }

    public void startServer() throws IOException {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (this.server.isRunning()) {
            throw new IllegalArgumentException("Server is already running");
        }
        this.logger.info("Starting the content delivery server...");
        this.server.start();
        EventBus.getInstance().dispatchEvent((EventObject)new ContentServerStartupEvent(this.config, this));
        this.logger.info("Content delivery server started successfully!");
    }

    public void stopServer() {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (!this.server.isRunning()) {
            throw new IllegalArgumentException("Server is not running");
        }
        this.logger.info("Shutting down the content delivery server...");
        try {
            this.server.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("Content delivery server stopped successfully!");
    }

    public void killServer() {
        if (this.server == null) {
            throw new IllegalArgumentException("Server has not been set up");
        }
        if (!this.server.isRunning()) {
            throw new IllegalArgumentException("Server is not running");
        }
        this.logger.info("Forcefully shutting down the content delivery server!");
        try {
            this.server.stopForced();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("Content delivery server stopped successfully!");
    }

    public boolean isRunning() {
        if (this.server == null) {
            return false;
        }
        return this.server.isRunning();
    }

    public void waitForExit() {
        while (this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

