/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SnifferViewer {
    private JTabbedPane tabbedPane;
    private JFrame frmEdgeSnifferLog;
    private ArrayList<SnifferDataBlock> sniffData = new ArrayList();
    private FileInputStream lastSniffData = null;
    private JScrollPane scrollPane_1;
    private JScrollPane scrollPane_2;
    private JTextPane textRequestInfo;
    private JTextPane textResponseInfo;
    private JList<SnifferDataBlock> list;
    private JTextField urlBox;
    private JTextField methodBox;
    private JTextField statusBox;
    private JTextField statusMessageBox;
    private JTextField searchBox;

    public static void main(String[] args) {
        try {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e1) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SnifferViewer window = new SnifferViewer();
                    window.frmEdgeSnifferLog.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public SnifferViewer() {
        this.initialize();
    }

    private void initialize() {
        this.frmEdgeSnifferLog = new JFrame();
        this.frmEdgeSnifferLog.setTitle("EDGE Sniffer Log Viewer");
        this.frmEdgeSnifferLog.setBounds(100, 100, 1003, 670);
        this.frmEdgeSnifferLog.setDefaultCloseOperation(3);
        this.frmEdgeSnifferLog.setLocationRelativeTo(null);
        JPanel panel = new JPanel();
        panel.setBorder(new BevelBorder(1, null, null, null, null));
        panel.setPreferredSize(new Dimension(350, 10));
        this.frmEdgeSnifferLog.getContentPane().add((Component)panel, "West");
        panel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(new BevelBorder(1, null, null, null, null));
        scrollPane.setVerticalScrollBarPolicy(22);
        panel.add((Component)scrollPane, "Center");
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SnifferViewer.this.setSelectedBlock(SnifferViewer.this.list.getSelectedValue());
            }
        });
        scrollPane.setViewportView(this.list);
        JPanel panel_3 = new JPanel();
        panel_3.setBorder(new BevelBorder(1, null, null, null, null));
        panel.add((Component)panel_3, "South");
        JButton btnNewButton = new JButton("Load file...");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileDialog chooser = new FileDialog((Frame)SnifferViewer.this.frmEdgeSnifferLog, "Open log file", 0);
                chooser.setFilenameFilter((dir, name) -> name.endsWith(".log") || new File(dir, name).isDirectory());
                chooser.setMultipleMode(false);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    SnifferViewer.this.loadSniffFile(chooser.getFiles()[0]);
                }
            }
        });
        panel_3.add(btnNewButton);
        JPanel panel_7 = new JPanel();
        panel_7.setBorder(new BevelBorder(1, null, null, null, null));
        panel.add((Component)panel_7, "North");
        panel_7.setLayout(new BorderLayout(0, 0));
        JLabel lblNewLabel = new JLabel("Packets");
        panel_7.add((Component)lblNewLabel, "North");
        this.searchBox = new JTextField();
        this.searchBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SnifferViewer.this.updateList();
            }
        });
        panel_7.add((Component)this.searchBox, "South");
        this.searchBox.setColumns(10);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new BevelBorder(1, null, null, null, null));
        this.frmEdgeSnifferLog.getContentPane().add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBorder(new BevelBorder(1, null, null, null, null));
        panel_1.add((Component)this.tabbedPane, "Center");
        JPanel panelRequest = new JPanel();
        panelRequest.setBorder(new BevelBorder(1, null, null, null, null));
        this.tabbedPane.addTab("Request", null, panelRequest, null);
        panelRequest.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new BevelBorder(1, null, null, null, null));
        panelRequest.add((Component)panel_2, "North");
        panel_2.setLayout(new BorderLayout(0, 0));
        JPanel panel_4 = new JPanel();
        panel_2.add((Component)panel_4, "North");
        panel_4.setLayout(new BorderLayout(0, 0));
        JLabel lblNewLabel_1 = new JLabel("Method and URL");
        panel_4.add((Component)lblNewLabel_1, "North");
        this.methodBox = new JTextField();
        this.methodBox.setEditable(false);
        this.methodBox.setColumns(10);
        panel_4.add((Component)this.methodBox, "West");
        this.urlBox = new JTextField();
        this.urlBox.setEditable(false);
        panel_4.add((Component)this.urlBox, "Center");
        this.urlBox.setColumns(10);
        JPanel panel_5 = new JPanel();
        panel_2.add((Component)panel_5, "Center");
        this.scrollPane_1 = new JScrollPane();
        this.scrollPane_1.setBorder(new BevelBorder(1, null, null, null, null));
        this.scrollPane_1.setVerticalScrollBarPolicy(22);
        panelRequest.add((Component)this.scrollPane_1, "Center");
        this.textRequestInfo = new JTextPane();
        this.textRequestInfo.setEditable(false);
        this.scrollPane_1.setViewportView(this.textRequestInfo);
        JPanel panelResponse = new JPanel();
        panelResponse.setBorder(new BevelBorder(1, null, null, null, null));
        this.tabbedPane.addTab("Response", null, panelResponse, null);
        panelResponse.setLayout(new BorderLayout(0, 0));
        JPanel panel_2_1 = new JPanel();
        panel_2_1.setBorder(new BevelBorder(1, null, null, null, null));
        panelResponse.add((Component)panel_2_1, "North");
        panel_2_1.setLayout(new BorderLayout(0, 0));
        JLabel lblNewLabel_2 = new JLabel("Response status");
        panel_2_1.add((Component)lblNewLabel_2, "North");
        JPanel panel_6 = new JPanel();
        panel_2_1.add((Component)panel_6, "South");
        this.statusBox = new JTextField();
        this.statusBox.setEditable(false);
        this.statusBox.setColumns(10);
        panel_2_1.add((Component)this.statusBox, "West");
        this.statusMessageBox = new JTextField();
        this.statusMessageBox.setEditable(false);
        panel_2_1.add((Component)this.statusMessageBox, "Center");
        this.statusMessageBox.setColumns(10);
        this.scrollPane_2 = new JScrollPane();
        this.scrollPane_2.setVerticalScrollBarPolicy(22);
        this.scrollPane_2.setBorder(new BevelBorder(1, null, null, null, null));
        panelResponse.add((Component)this.scrollPane_2, "Center");
        this.textResponseInfo = new JTextPane();
        this.textResponseInfo.setEditable(false);
        this.scrollPane_2.setViewportView(this.textResponseInfo);
    }

    private void loadSniffFile(File file) {
        Object buffer;
        this.searchBox.setText("");
        boolean validFile = true;
        FileInputStream sourceFile = null;
        try {
            sourceFile = new FileInputStream(file);
            try {
                int b;
                buffer = "";
                boolean inBlock = false;
                while ((b = sourceFile.read()) != -1) {
                    byte bb = (byte)b;
                    char ch = (char)bb;
                    if (ch == '\r') continue;
                    if (!inBlock) {
                        if (ch == '\n') continue;
                        if (ch == '{') {
                            inBlock = true;
                        } else {
                            throw new IOException("Invalid file");
                        }
                    }
                    if (ch == '\n') {
                        JsonObject obj = JsonParser.parseString((String)buffer).getAsJsonObject();
                        buffer = "";
                        if (obj.has("time") && obj.has("request") && obj.has("response") && obj.get("request").getAsJsonObject().has("url") && obj.get("request").getAsJsonObject().has("method") && obj.get("request").getAsJsonObject().has("headers") && obj.get("request").getAsJsonObject().has("hasBody") && obj.get("response").getAsJsonObject().has("status") && obj.get("response").getAsJsonObject().has("statusMessage") && obj.get("response").getAsJsonObject().has("headers") && obj.get("response").getAsJsonObject().has("responseBody") || obj.has("type") && !obj.get("type").getAsString().equals("http")) break;
                        throw new IOException("Invalid file");
                    }
                    buffer = (String)buffer + ch;
                }
                sourceFile.getChannel().position(0L);
            }
            catch (Exception e) {
                try {
                    sourceFile.close();
                }
                catch (IOException inBlock) {
                    // empty catch block
                }
                throw e;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frmEdgeSnifferLog, "The file you selected is not a valid packet recording file.", "Error", 0);
            if (sourceFile != null) {
                try {
                    sourceFile.close();
                }
                catch (IOException inBlock) {
                    // empty catch block
                }
            }
            return;
        }
        if (!validFile) {
            JOptionPane.showMessageDialog(this.frmEdgeSnifferLog, "The file you selected is not a valid packet recording file.", "Error", 0);
            if (sourceFile != null) {
                try {
                    sourceFile.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return;
        }
        this.sniffData.clear();
        if (this.lastSniffData != null) {
            try {
                this.lastSniffData.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.lastSniffData = sourceFile;
        try {
            int b;
            buffer = "";
            long blockStart = -1L;
            while ((b = sourceFile.read()) != -1) {
                byte bb = (byte)b;
                char ch = (char)bb;
                if (ch == '\r' || ch == '\n') continue;
                if (ch == '{') {
                    JsonObject obj;
                    byte[] bufferD;
                    int read;
                    blockStart = sourceFile.getChannel().position();
                    buffer = Character.toString(ch);
                    while ((read = sourceFile.read(bufferD = new byte[20480])) > 0) {
                        String bData = new String(bufferD, "UTF-8");
                        if (bData.contains("\n")) {
                            buffer = (String)buffer + bData.substring(0, bData.indexOf("\n"));
                            sourceFile.getChannel().position(sourceFile.getChannel().position() - (long)(read - bData.indexOf("\n")));
                            break;
                        }
                        buffer = (String)buffer + bData;
                    }
                    if (!((obj = JsonParser.parseString((String)buffer).getAsJsonObject()).has("time") && obj.has("request") && obj.has("response") && obj.get("request").getAsJsonObject().has("url") && obj.get("request").getAsJsonObject().has("method") && obj.get("request").getAsJsonObject().has("headers") && obj.get("request").getAsJsonObject().has("hasBody") && obj.get("response").getAsJsonObject().has("status") && obj.get("response").getAsJsonObject().has("statusMessage") && obj.get("response").getAsJsonObject().has("headers") && obj.get("response").getAsJsonObject().has("responseBody") || obj.has("type") && !obj.get("type").getAsString().equals("http"))) {
                        throw new IOException("Invalid file");
                    }
                    if (obj.has("type") && !obj.get("type").getAsString().equals("http")) continue;
                    SnifferDataBlock block = new SnifferDataBlock();
                    block.position = blockStart;
                    block.url = obj.get("request").getAsJsonObject().get("url").getAsString();
                    this.sniffData.add(block);
                    continue;
                }
                throw new IOException("Invalid file");
            }
            sourceFile.getChannel().position(0L);
        }
        catch (Exception e) {
            Object stackTrace = "";
            for (StackTraceElement ele : e.getStackTrace()) {
                stackTrace = (String)stackTrace + "\n    at: " + ele;
            }
            JOptionPane.showMessageDialog(this.frmEdgeSnifferLog, "An error occured while loading the packet log file: " + e.getClass().getTypeName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : "") + "\n" + (String)stackTrace, "Error", 0);
        }
        this.updateList();
    }

    private void updateList() {
        final ArrayList<SnifferDataBlock> filteredData = new ArrayList<SnifferDataBlock>();
        for (SnifferDataBlock block : this.sniffData) {
            String filter = this.searchBox.getText();
            if ((filter = filter.trim()).isEmpty()) {
                filteredData.add(block);
                continue;
            }
            if (!block.url.toLowerCase().contains(filter.toLowerCase())) continue;
            filteredData.add(block);
        }
        this.list.setModel(new ListModel<SnifferDataBlock>(){

            @Override
            public int getSize() {
                return filteredData.size();
            }

            @Override
            public SnifferDataBlock getElementAt(int index) {
                return (SnifferDataBlock)filteredData.get(index);
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
        this.list.repaint();
        this.list.setSelectedValue(null, false);
        this.setSelectedBlock(null);
    }

    private void setSelectedBlock(SnifferDataBlock block) {
        this.tabbedPane.setSelectedIndex(0);
        this.textRequestInfo.setText("");
        this.textResponseInfo.setText("");
        this.urlBox.setText("");
        this.methodBox.setText("");
        this.statusBox.setText("");
        this.statusMessageBox.setText("");
        if (block != null) {
            this.textRequestInfo.setText("Decoding from disk...");
            this.textRequestInfo.updateUI();
            SwingUtilities.invokeLater(() -> this.scrollPane_1.getViewport().setViewPosition(new Point(0, 0)));
            SwingUtilities.invokeLater(() -> this.scrollPane_2.getViewport().setViewPosition(new Point(0, 0)));
            SwingUtilities.invokeLater(() -> {
                try {
                    byte[] bufferD;
                    int read;
                    this.lastSniffData.getChannel().position(block.position);
                    Object buffer = "{";
                    while ((read = this.lastSniffData.read(bufferD = new byte[20480])) > 0) {
                        String bData = new String(bufferD, "UTF-8");
                        if (bData.contains("\n")) {
                            buffer = (String)buffer + bData.substring(0, bData.indexOf("\n"));
                            this.lastSniffData.getChannel().position(this.lastSniffData.getChannel().position() - (long)(read - bData.indexOf("\n")));
                            break;
                        }
                        buffer = (String)buffer + bData;
                    }
                    JsonObject requestData = JsonParser.parseString((String)buffer).getAsJsonObject();
                    this.urlBox.setText(block.url);
                    this.methodBox.setText(requestData.get("request").getAsJsonObject().get("method").getAsString());
                    this.statusBox.setText(requestData.get("response").getAsJsonObject().get("status").getAsString());
                    this.statusMessageBox.setText(requestData.get("response").getAsJsonObject().get("statusMessage").getAsString());
                    JsonObject rq = requestData.get("request").getAsJsonObject();
                    URL u = new URL(rq.get("url").getAsString());
                    String requestInfo = rq.get("method").getAsString() + " " + u.getPath();
                    requestInfo = requestInfo + "\n";
                    if (u.getQuery() != null) {
                        requestInfo = requestInfo + "?" + u.getQuery();
                    }
                    requestInfo = requestInfo + "\n";
                    requestInfo = requestInfo + "Host: " + u.getHost() + (String)(u.getPort() == -1 ? "" : ":" + u.getPort());
                    JsonObject headers = rq.get("headers").getAsJsonObject();
                    for (String headerName : headers.keySet()) {
                        if (headerName.equalsIgnoreCase("host")) continue;
                        for (Object value : headers.get(headerName).getAsJsonArray()) {
                            requestInfo = requestInfo + "\n";
                            requestInfo = requestInfo + headerName + ": " + value.getAsString();
                        }
                    }
                    if (rq.get("hasBody").getAsBoolean()) {
                        requestInfo = requestInfo + "\n";
                        requestInfo = requestInfo + "\n";
                        byte[] dec = Base64.getDecoder().decode(rq.get("requestBody").getAsString());
                        if (headers.has("Content-Encoding") && headers.get("Content-Encoding").getAsString().equalsIgnoreCase("gzip")) {
                            GZIPInputStream strm = new GZIPInputStream(new ByteArrayInputStream(dec));
                            dec = strm.readAllBytes();
                            strm.close();
                        }
                        Object body = new String(dec, "UTF-8");
                        if (headers.has("Content-Type") && headers.get("Content-Type").getAsString().equalsIgnoreCase("application/x-www-form-urlencoded")) {
                            Map<String, String> form = this.parseForm(((String)body).replace("\r", "\n"));
                            body = "";
                            for (String key : form.keySet()) {
                                if (!((String)body).isEmpty()) {
                                    body = (String)body + "\n";
                                } else if (((String)form.get(key)).contains("\n")) {
                                    body = (String)body + "\n";
                                }
                                body = ((String)form.get(key)).contains("\n") ? (String)body + key + ":\n" + ((String)form.get(key)).replace("\n", "\n ") : (String)body + key + ": " + (String)form.get(key);
                                if (!((String)form.get(key)).contains("\n")) continue;
                                body = (String)body + "\n";
                            }
                        }
                        requestInfo = requestInfo + (String)body;
                    }
                    this.textRequestInfo.setText(requestInfo);
                    JsonObject rs = requestData.get("response").getAsJsonObject();
                    String responseInfo = rs.get("status").getAsString() + " " + rs.get("statusMessage").getAsString();
                    responseInfo = responseInfo + "\n";
                    headers = rs.get("headers").getAsJsonObject();
                    for (String headerName : headers.keySet()) {
                        if (headerName.equalsIgnoreCase("host")) continue;
                        for (JsonElement value : headers.get(headerName).getAsJsonArray()) {
                            responseInfo = responseInfo + "\n";
                            responseInfo = responseInfo + headerName + ": " + value.getAsString();
                        }
                    }
                    responseInfo = responseInfo + "\n";
                    responseInfo = responseInfo + "\n";
                    byte[] dec = Base64.getDecoder().decode(rs.get("responseBody").getAsString());
                    if (headers.has("Content-Encoding") && headers.get("Content-Encoding").getAsString().equalsIgnoreCase("gzip")) {
                        GZIPInputStream strm = new GZIPInputStream(new ByteArrayInputStream(dec));
                        dec = strm.readAllBytes();
                        strm.close();
                    }
                    responseInfo = responseInfo + new String(dec, "UTF-8");
                    this.textResponseInfo.setText(responseInfo);
                }
                catch (IOException e) {
                    Object stackTrace = "";
                    for (StackTraceElement ele : e.getStackTrace()) {
                        stackTrace = (String)stackTrace + "\n    at: " + ele;
                    }
                    JOptionPane.showMessageDialog(this.frmEdgeSnifferLog, "An error occured while loading the packet log file: " + e.getClass().getTypeName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : "") + "\n" + (String)stackTrace, "Error", 0);
                    this.sniffData.clear();
                    if (this.lastSniffData != null) {
                        try {
                            this.lastSniffData.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.lastSniffData = null;
                    this.searchBox.setText("");
                    this.updateList();
                    return;
                }
                this.urlBox.setText(block.url);
                this.scrollPane_1.updateUI();
                this.scrollPane_2.updateUI();
                SwingUtilities.invokeLater(() -> this.scrollPane_1.getViewport().setViewPosition(new Point(0, 0)));
                SwingUtilities.invokeLater(() -> this.scrollPane_2.getViewport().setViewPosition(new Point(0, 0)));
            });
        } else {
            this.scrollPane_1.updateUI();
            this.scrollPane_2.updateUI();
            SwingUtilities.invokeLater(() -> this.scrollPane_1.getViewport().setViewPosition(new Point(0, 0)));
            SwingUtilities.invokeLater(() -> this.scrollPane_2.getViewport().setViewPosition(new Point(0, 0)));
        }
    }

    public Map<String, String> parseForm(String payload) {
        HashMap<String, String> frm = new HashMap<String, String>();
        Object key = "";
        Object value = "";
        boolean isKey = true;
        for (int i = 0; i < payload.length(); ++i) {
            char ch = payload.charAt(i);
            if (ch == '&') {
                if (isKey && !((String)key).isEmpty()) {
                    frm.put((String)key, "");
                    key = "";
                    continue;
                }
                if (isKey || ((String)key).isEmpty()) continue;
                try {
                    frm.put((String)key, URLDecoder.decode((String)value, "UTF-8"));
                }
                catch (Exception e) {
                    frm.put((String)key, (String)value);
                }
                isKey = true;
                key = "";
                value = "";
                continue;
            }
            if (ch == '=') {
                isKey = !isKey;
                continue;
            }
            if (isKey) {
                key = (String)key + ch;
                continue;
            }
            value = (String)value + ch;
        }
        if (!((String)key).isEmpty() || !((String)value).isEmpty()) {
            try {
                frm.put((String)key, URLDecoder.decode((String)value, "UTF-8"));
            }
            catch (Exception e) {
                frm.put((String)key, (String)value);
            }
        }
        return frm;
    }

    private class SnifferDataBlock {
        public String url;
        public long position;

        private SnifferDataBlock() {
        }

        public String toString() {
            URL u;
            try {
                u = new URL(this.url);
            }
            catch (MalformedURLException e) {
                return this.url;
            }
            Object str = u.getPath();
            if (u.getQuery() != null) {
                str = (String)str + "?" + u.getQuery();
            }
            str = (String)str + " (" + u.getHost() + ")";
            return str;
        }
    }
}

