/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.tokens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import java.util.UUID;
import java.util.stream.Stream;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.tokens.TokenParseResult;

public class SessionToken {
    private AccountManager accMgr = AccountManager.getInstance();
    public String accountID;
    public AccountObject account;
    public String saveID;
    public long lastLoginTime;
    public String[] capabilities = new String[0];

    public boolean hasCapability(String cap) {
        return Stream.of(this.capabilities).anyMatch(t -> t.equals(cap));
    }

    public TokenParseResult parseToken(String token) {
        try {
            JsonObject jwtHead = JsonParser.parseString((String)new String(Base64.getUrlDecoder().decode(token.split("\\.")[0]), "UTF-8")).getAsJsonObject();
            if (!jwtHead.get("typ").getAsString().equalsIgnoreCase("jwt")) {
                return TokenParseResult.INVALID_DATA;
            }
            if (!jwtHead.get("alg").getAsString().equalsIgnoreCase("rs256")) {
                return TokenParseResult.INVALID_DATA;
            }
            TokenParseResult res = this.accMgr.verifyToken(token);
            if (res != TokenParseResult.SUCCESS) {
                return res;
            }
            JsonObject jwtPl = JsonParser.parseString((String)new String(Base64.getUrlDecoder().decode(token.split("\\.")[1]), "UTF-8")).getAsJsonObject();
            if (!(jwtPl.has("sub") && jwtPl.has("uuid") && jwtPl.has("iat") && jwtPl.has("jti") && jwtPl.has("iss") && jwtPl.has("cl") && jwtPl.has("llt") && jwtPl.get("iss").getAsString().equals("EDGE"))) {
                return TokenParseResult.INVALID_DATA;
            }
            String accID = jwtPl.get("uuid").getAsString();
            long lastLoginTime = jwtPl.get("llt").getAsLong();
            String saveID = null;
            if (jwtPl.has("save")) {
                saveID = jwtPl.get("save").getAsString();
            }
            JsonArray capLs = jwtPl.get("cl").getAsJsonArray();
            AccountObject acc = this.accMgr.getAccount(accID);
            if (acc == null) {
                return TokenParseResult.INVALID_DATA;
            }
            if (acc.getLastLoginTime() != lastLoginTime && saveID != null) {
                return TokenParseResult.LOGGED_IN_ELSEWHERE;
            }
            AccountDataContainer accData = acc.getAccountData().getChildContainer("accountdata");
            JsonElement tknTime = accData.getEntry("sessiontime");
            if (tknTime == null) {
                return TokenParseResult.TOKEN_EXPIRED;
            }
            if (tknTime.getAsLong() + 900000L <= System.currentTimeMillis()) {
                return TokenParseResult.TOKEN_EXPIRED;
            }
            this.account = acc;
            this.accountID = accID;
            this.saveID = saveID;
            this.lastLoginTime = lastLoginTime;
            this.capabilities = new String[capLs.size()];
            int i = 0;
            for (JsonElement cap : capLs) {
                this.capabilities[i++] = cap.getAsString();
            }
            acc.ping(false);
            if (System.currentTimeMillis() - tknTime.getAsLong() > 60000L) {
                this.updateSessionTime();
            }
            return TokenParseResult.SUCCESS;
        }
        catch (IOException e) {
            return TokenParseResult.INVALID_DATA;
        }
    }

    public String toTokenString() throws IOException {
        JsonObject headers = new JsonObject();
        headers.addProperty("alg", "RS256");
        headers.addProperty("typ", "JWT");
        String headerD = Base64.getUrlEncoder().withoutPadding().encodeToString(headers.toString().getBytes("UTF-8"));
        JsonObject payload = new JsonObject();
        payload.addProperty("iat", (Number)(System.currentTimeMillis() / 1000L));
        payload.addProperty("jti", UUID.randomUUID().toString());
        payload.addProperty("iss", "EDGE");
        payload.addProperty("sub", "EDGE");
        payload.addProperty("uuid", this.accountID);
        if (this.saveID != null) {
            payload.addProperty("save", this.saveID);
        }
        payload.addProperty("llt", (Number)this.lastLoginTime);
        JsonArray caps = new JsonArray();
        for (String cap : this.capabilities) {
            caps.add(cap);
        }
        payload.add("cl", (JsonElement)caps);
        this.updateSessionTime();
        String payloadD = Base64.getUrlEncoder().withoutPadding().encodeToString(payload.toString().getBytes("UTF-8"));
        String token = headerD + "." + payloadD;
        String sig = Base64.getUrlEncoder().withoutPadding().encodeToString(this.accMgr.signToken(token));
        return token + "." + sig;
    }

    public void updateSessionTime() throws IOException {
        AccountObject acc = this.accMgr.getAccount(this.accountID);
        if (acc == null) {
            throw new IOException("Account not found");
        }
        acc.getAccountData().getChildContainer("accountdata").setEntry("sessiontime", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
    }

    public static byte[] pemDecode(String pem) {
        String base64 = pem.replace("\r", "");
        while (base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        while (!base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        while (base64.startsWith("-")) {
            base64 = base64.substring(1);
        }
        base64 = base64.replace("\n", "");
        while (base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        while (!base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        while (base64.endsWith("-")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        return Base64.getDecoder().decode(base64);
    }

    public static String pemEncode(byte[] key, String type) {
        boolean done;
        String PEM = "-----BEGIN " + type + " KEY-----";
        String base64 = new String(Base64.getEncoder().encode(key));
        block0: do {
            PEM = PEM + "\n";
            done = false;
            for (int i = 0; i < 64; ++i) {
                if (base64.isEmpty()) {
                    done = true;
                    continue block0;
                }
                PEM = PEM + base64.substring(0, 1);
                base64 = base64.substring(1);
            }
        } while (!base64.isEmpty() && !done);
        PEM = PEM + "\n";
        PEM = PEM + "-----END " + type + " KEY-----";
        return PEM;
    }

    public static byte[] sign(byte[] data, PrivateKey privateKey) {
        try {
            Signature sig = Signature.getInstance("Sha256WithRSA");
            sig.initSign(privateKey);
            sig.update(data);
            return sig.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verify(byte[] data, byte[] signature, PublicKey publicKey) {
        try {
            Signature sig = Signature.getInstance("Sha256WithRSA");
            sig.initVerify(publicKey);
            sig.update(data);
            return sig.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return false;
        }
    }
}

