/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.minigamedata.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.asf.edge.common.entities.minigamedata.MinigameData;
import org.asf.edge.common.entities.minigamedata.MinigameDataRequest;
import org.asf.edge.common.entities.minigamedata.MinigameSaveRequest;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.minigamedata.MinigameDataManager;

public class MinigameDataManagerImpl
extends MinigameDataManager {
    private CommonDataContainer globalData;

    @Override
    public void initService() {
        this.globalData = CommonDataManager.getInstance().getContainer("MINIGAMEDATA");
    }

    @Override
    public void deleteDataFor(String saveID) {
        try {
            this.globalData.getChildContainer("save-" + saveID).deleteContainer();
            AccountSaveContainer sv = AccountManager.getInstance().getSaveByID(saveID);
            if (sv != null) {
                sv.getSaveData().getChildContainer("minigamedata").deleteContainer();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveGameData(AccountSaveContainer save, int gameId, MinigameSaveRequest saveRequest) {
        try {
            AccountDataContainer data = save.getSaveData().getChildContainer("minigamedata");
            MinigameDataContainer old = null;
            ObjectMapper mapper = new ObjectMapper();
            if (data.entryExists("minigame-" + gameId + "-" + saveRequest.gameLevel)) {
                old = (MinigameDataContainer)mapper.readValue(data.getEntry("minigame-" + gameId + "-" + saveRequest.gameLevel).toString(), MinigameDataContainer.class);
            }
            if (old == null) {
                old = new MinigameDataContainer();
            }
            old.userID = save.getSaveID();
            for (String key : saveRequest.data.keySet()) {
                if (key.equals("highscore") && old.data.containsKey(key) && old.data.get(key) >= saveRequest.data.get(key)) continue;
                old.data.put(key, saveRequest.data.get(key));
            }
            old.timePlayed = System.currentTimeMillis();
            if (saveRequest.isLoss) {
                ++old.timesLost;
            }
            if (saveRequest.isWin) {
                ++old.timesWon;
            }
            data.setEntry("minigame-" + gameId + "-" + saveRequest.gameLevel, JsonParser.parseString((String)mapper.writeValueAsString((Object)old)));
            CommonDataContainer dataG = this.globalData.getChildContainer("save-" + save.getSaveID());
            dataG.setEntry("minigame-" + gameId + "-" + saveRequest.gameLevel, JsonParser.parseString((String)mapper.writeValueAsString((Object)old)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MinigameData getGameDataOf(AccountSaveContainer save, int gameId, MinigameDataRequest dataRequest) {
        try {
            MinigameData res = new MinigameData();
            res.userID = save.getSaveID();
            AccountDataContainer data = save.getSaveData().getChildContainer("minigamedata");
            MinigameDataContainer c = null;
            ObjectMapper mapper = new ObjectMapper();
            if (data.entryExists("minigame-" + gameId + "-" + dataRequest.gameLevel)) {
                c = (MinigameDataContainer)mapper.readValue(data.getEntry("minigame-" + gameId + "-" + dataRequest.gameLevel).toString(), MinigameDataContainer.class);
            }
            res.timePlayed = c.timePlayed;
            res.timesLost = c.timesLost;
            res.timesWon = c.timesWon;
            res.value = c.data.getOrDefault(dataRequest.key, 0);
            return res;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MinigameData[] getAllGameData(String requestingID, int gameId, MinigameDataRequest dataRequest) {
        try {
            ArrayList lst = new ArrayList();
            if (dataRequest.friendsOnly) {
                // empty if block
            }
            this.globalData.runForChildContainers(container -> {
                try {
                    if (container.startsWith("save-")) {
                        CommonDataContainer data = this.globalData.getChildContainer((String)container);
                        String saveID = container.substring(5);
                        MinigameData res = new MinigameData();
                        res.userID = saveID;
                        if (data.entryExists("minigame-" + gameId + "-" + dataRequest.gameLevel)) {
                            ObjectMapper mapper = new ObjectMapper();
                            MinigameDataContainer c = (MinigameDataContainer)mapper.readValue(data.getEntry("minigame-" + gameId + "-" + dataRequest.gameLevel).toString(), MinigameDataContainer.class);
                            res.timePlayed = c.timePlayed;
                            res.timesLost = c.timesLost;
                            res.timesWon = c.timesWon;
                            res.value = c.data.getOrDefault(dataRequest.key, 0);
                            if (dataRequest.friendsOnly && !requestingID.equals(res.userID)) {
                                return true;
                            }
                            if (dataRequest.minimalPlayedAtTime != -1L && res.timePlayed < dataRequest.minimalPlayedAtTime) {
                                return true;
                            }
                            if (dataRequest.maximumPlayedAtTime != -1L && res.timePlayed > dataRequest.maximumPlayedAtTime) {
                                return true;
                            }
                            lst.add(res);
                        } else {
                            res.timePlayed = System.currentTimeMillis();
                            res.timesLost = 0;
                            res.timesWon = 0;
                            lst.add(res);
                        }
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            ArrayList<MinigameData> l = new ArrayList<MinigameData>();
            for (MinigameData data : (MinigameData[])lst.stream().sorted((t1, t2) -> -Integer.compare(t1.value, t2.value)).toArray(MinigameData[]::new)) {
                if (l.size() >= dataRequest.maxEntries) break;
                l.add(data);
                lst.remove(data);
            }
            lst.clear();
            return (MinigameData[])l.toArray(MinigameData[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MinigameDataContainer {
        public String userID;
        public long timePlayed;
        public int timesWon;
        public int timesLost;
        public HashMap<String, Integer> data = new HashMap();
    }
}

