/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts;

import java.io.IOException;
import java.util.HashMap;
import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.items.ItemManager;

public abstract class AccountObject {
    private HashMap<String, Object> sessionMemory = new HashMap();

    public <T> T getSessionObject(Class<T> type) {
        return (T)this.sessionMemory.get(type.getTypeName());
    }

    public <T> void setSessionObject(Class<T> type, T object) {
        this.sessionMemory.put(type.getTypeName(), object);
    }

    public <T> void removeSessionObject(Class<T> type) {
        this.sessionMemory.remove(type.getTypeName());
    }

    public abstract String getUsername();

    public abstract String getAccountEmail();

    public abstract String getAccountID();

    public abstract long getLastLoginTime();

    public abstract long getRegistrationTimestamp();

    public abstract boolean updateUsername(String var1);

    public abstract boolean updateEmail(String var1);

    public abstract boolean updatePassword(char[] var1);

    public abstract boolean migrateToNormalAccountFromGuest(String var1, String var2, char[] var3);

    public abstract boolean isGuestAccount();

    public abstract boolean isMultiplayerEnabled();

    public abstract boolean isChatEnabled();

    public abstract boolean isStrictChatFilterEnabled();

    public abstract void setMultiplayerEnabled(boolean var1);

    public abstract void setChatEnabled(boolean var1);

    public abstract void setStrictChatFilterEnabled(boolean var1);

    public abstract void updateLastLoginTime();

    public abstract AccountDataContainer getAccountData();

    public abstract String[] getSaveIDs();

    public abstract AccountSaveContainer createSave(String var1);

    public abstract AccountSaveContainer getSave(String var1);

    public PlayerInventory getInventory() {
        return ItemManager.getInstance().getCommonInventory(this.getAccountData());
    }

    public abstract void deleteAccount() throws IOException;

    public abstract boolean isOnline();

    public void ping(boolean addIfNeeded) {
    }
}

