/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.http.cookies;

import java.util.Iterator;
import java.util.function.Consumer;
import org.asf.edge.common.http.cookies.Cookie;
import org.asf.edge.common.http.cookies.StringCookie;

public class CookieContext
implements Iterable<Cookie> {
    protected CookieEntry first;
    protected Consumer<Cookie> setValue;

    protected CookieContext() {
    }

    protected void assign(Consumer<Cookie> setValue) {
        this.setValue = setValue;
    }

    public Cookie get(String name) {
        CookieEntry ent = this.first;
        while (ent != null) {
            if (ent.cookie.getName().equals(name)) {
                return ent.cookie;
            }
            ent = ent.next;
        }
        return null;
    }

    public String getValue(String name) {
        CookieEntry ent = this.first;
        while (ent != null) {
            if (ent.cookie.getName().equals(name)) {
                return ent.cookie.getValue();
            }
            ent = ent.next;
        }
        return null;
    }

    public boolean contains(String name) {
        CookieEntry ent = this.first;
        while (ent != null) {
            if (ent.cookie.getName().equals(name)) {
                return true;
            }
            ent = ent.next;
        }
        return false;
    }

    public Cookie set(String name, String value) {
        return this.setInternal(name, new StringCookie(value));
    }

    private Cookie setInternal(String name, Cookie input) {
        Cookie cookie = this.assign(name, input);
        this.setValue.accept(cookie);
        return cookie;
    }

    public Cookie set(String name, Cookie value) {
        return this.setInternal(name, value);
    }

    @Override
    public Iterator<Cookie> iterator() {
        return new CookieIterator(this.first);
    }

    protected Cookie assign(String name, Cookie input) {
        Cookie cookie = this.get(name);
        if (cookie == null) {
            cookie = Cookie.create(name);
            CookieEntry ent = this.first;
            if (this.first != null) {
                while (ent.next != null) {
                    ent = ent.next;
                }
                ent = ent.next = new CookieEntry();
            } else {
                ent = this.first = new CookieEntry();
            }
            ent.cookie = cookie;
        }
        cookie.setValue(input);
        return cookie;
    }

    protected class CookieEntry {
        public Cookie cookie;
        public CookieEntry next;

        protected CookieEntry() {
        }
    }

    protected class CookieIterator
    implements Iterator<Cookie> {
        public CookieEntry current;

        public CookieIterator(CookieEntry first) {
            this.current = first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Cookie next() {
            CookieEntry ent = this.current;
            this.current = ent.next;
            return ent.cookie;
        }
    }
}

