/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.remapping;

import java.util.ArrayList;
import java.util.Arrays;
import org.asf.cyan.fluid.remapping.MAPTYPE;
import org.asf.cyan.fluid.remapping.Mapping;

public class SimpleMappings
extends Mapping<SimpleMappings> {
    private boolean allowSupertypeFinalOverride = false;

    public void setAllowSupertypeFinalOverride(boolean value) {
        this.allowSupertypeFinalOverride = value;
    }

    @Override
    public boolean allowSupertypeFinalOverride() {
        return this.allowSupertypeFinalOverride;
    }

    public SimpleMappings() {
    }

    public SimpleMappings(String name, String obfuscated) {
        this.name = name;
        this.obfuscated = obfuscated;
        this.mappingType = MAPTYPE.CLASS;
    }

    public SimpleMappings(String name, String obfuscated, Mapping<?>[] mappings) {
        this.name = name;
        this.obfuscated = obfuscated;
        this.mappingType = MAPTYPE.CLASS;
        this.mappings = mappings;
    }

    public SimpleMappings(Mapping<?>[] mappings) {
        this.mappings = mappings;
    }

    public SimpleMappings getClassMapping(String name) {
        for (Mapping mapping : this.mappings) {
            if (!(mapping instanceof SimpleMappings) || mapping.mappingType != MAPTYPE.CLASS || !mapping.name.equals(name)) continue;
            return (SimpleMappings)mapping;
        }
        return null;
    }

    public String[] getObfuscatedClassNames() {
        ArrayList<String> classes = new ArrayList<String>();
        for (Mapping mapping : this.mappings) {
            if (mapping.mappingType != MAPTYPE.CLASS) continue;
            classes.add(mapping.obfuscated);
        }
        return (String[])classes.toArray(String[]::new);
    }

    public String[] getDeobfuscatedClassNames() {
        ArrayList<String> classes = new ArrayList<String>();
        for (Mapping mapping : this.mappings) {
            if (mapping.mappingType != MAPTYPE.CLASS) continue;
            classes.add(mapping.name);
        }
        return (String[])classes.toArray(String[]::new);
    }

    public String mapClassToObfuscation(String name) {
        for (Mapping mapping : this.mappings) {
            if (mapping.mappingType != MAPTYPE.CLASS || !mapping.name.equals(name)) continue;
            return mapping.obfuscated;
        }
        return name;
    }

    public String mapClassToDeobfuscation(String obfus) {
        for (Mapping mapping : this.mappings) {
            if (mapping.mappingType != MAPTYPE.CLASS || !mapping.obfuscated.equals(obfus)) continue;
            return mapping.name;
        }
        return obfus;
    }

    public SimpleMappings createClassMapping(String name, String obfuscated) {
        return this.createClassMapping(name, obfuscated, new Mapping[0]);
    }

    public SimpleMappings createClassMapping(String name, String obfuscated, Mapping<?>[] childMappings) {
        SimpleMappings mappings = new SimpleMappings();
        mappings.name = name;
        mappings.obfuscated = obfuscated;
        mappings.mappingType = MAPTYPE.CLASS;
        ArrayList<Mapping> mappingsL = new ArrayList<Mapping>();
        mappingsL.addAll(Arrays.asList(this.mappings));
        mappingsL.add(mappings);
        this.mappings = (Mapping[])mappingsL.toArray(Mapping[]::new);
        return mappings;
    }

    public void add(Mapping<?> map) {
        ArrayList mappingsL = new ArrayList();
        mappingsL.addAll(Arrays.asList(this.mappings));
        mappingsL.add(map);
        this.mappings = (Mapping[])mappingsL.toArray(Mapping[]::new);
    }

    public SimpleMappings createMethod(String name, String obfuscated, String returnType, String ... argumentTypes) {
        if (this.mappingType != MAPTYPE.CLASS) {
            throw new RuntimeException("Cannot add method to non-class mappings");
        }
        SimpleMappings mappings = new SimpleMappings();
        mappings.name = name;
        mappings.obfuscated = obfuscated;
        mappings.mappingType = MAPTYPE.METHOD;
        mappings.argumentTypes = argumentTypes;
        mappings.type = returnType;
        ArrayList<Mapping> mappingsL = new ArrayList<Mapping>();
        mappingsL.addAll(Arrays.asList(this.mappings));
        mappingsL.add(mappings);
        this.mappings = (Mapping[])mappingsL.toArray(Mapping[]::new);
        return mappings;
    }

    public SimpleMappings createField(String name, String obfuscated, String type) {
        if (this.mappingType != MAPTYPE.CLASS) {
            throw new RuntimeException("Cannot add method to non-class mappings");
        }
        SimpleMappings mappings = new SimpleMappings();
        mappings.name = name;
        mappings.obfuscated = obfuscated;
        mappings.mappingType = MAPTYPE.PROPERTY;
        mappings.type = type;
        ArrayList<Mapping> mappingsL = new ArrayList<Mapping>();
        mappingsL.addAll(Arrays.asList(this.mappings));
        mappingsL.add(mappings);
        this.mappings = (Mapping[])mappingsL.toArray(Mapping[]::new);
        return mappings;
    }
}

