/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.cyan.fluid.Fluid;
import org.asf.cyan.fluid.api.transforming.ASM;
import org.asf.cyan.fluid.api.transforming.Constructor;
import org.asf.cyan.fluid.api.transforming.Erase;
import org.asf.cyan.fluid.api.transforming.Exclude;
import org.asf.cyan.fluid.api.transforming.InjectAt;
import org.asf.cyan.fluid.api.transforming.Modifiers;
import org.asf.cyan.fluid.api.transforming.Reflect;
import org.asf.cyan.fluid.api.transforming.TargetClass;
import org.asf.cyan.fluid.api.transforming.TargetType;
import org.asf.cyan.fluid.api.transforming.enums.InjectLocation;
import org.asf.cyan.fluid.api.transforming.information.metadata.TransformerMetadata;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.asf.cyan.fluid.bytecode.FluidClassWriter;
import org.asf.cyan.fluid.implementation.FluidTransformer;
import org.asf.cyan.fluid.remapping.MAPTYPE;
import org.asf.cyan.fluid.remapping.Mapping;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class Transformer {
    private static Transformer selectedTransformer = new FluidTransformer();
    protected static Logger log = LogManager.getLogger((String)"Fluid");

    protected abstract String getDeobfNameInternal(String var1);

    protected abstract String getImplementationName();

    /*
     * WARNING - void declaration
     */
    protected synchronized void runTransformers(ClassNode target, String clName, String loadingName, Map<String, String> transformerOwners, Map<String, ArrayList<ClassNode>> transformers, FluidClassPool transformerPool, FluidClassPool programPool) {
        if (!transformers.containsKey(loadingName)) {
            return;
        }
        ArrayList<ClassNode> arr = transformers.get(loadingName);
        int transformerIndex = 0;
        for (ClassNode transformer : arr) {
            boolean asmMethods = false;
            ArrayList<String> transformedMethods = new ArrayList<String>();
            ArrayList<String> transformedFields = new ArrayList<String>();
            String typeName = transformer.name.replaceAll("/", ".");
            try {
                log.debug("Applying transformer " + typeName + " to class " + Fluid.mapClass(loadingName.replaceAll("/", ".")));
                TransformContext ctx = new TransformContext();
                ctx.transformerType = typeName;
                ctx.transformer = transformer;
                ctx.mappedName = clName;
                ctx.obfuscatedName = loadingName;
                ctx.targetClass = target;
                ctx.programPool = programPool;
                ctx.transformerPool = transformerPool;
                if (Modifier.isInterface(transformer.access)) {
                    if (AnnotationInfo.isAnnotationPresent(Modifiers.class, transformer)) {
                        this.applyClassModifiers(ctx, target.access, 0x200 | (Integer)AnnotationInfo.getAnnotation(Modifiers.class, transformer).get("modifiers"));
                    }
                    for (MethodNode method : transformer.methods) {
                        if (AnnotationInfo.isAnnotationPresent(Exclude.class, method)) continue;
                        String methNameFinal = method.name;
                        boolean found = false;
                        ArrayList<String> types = new ArrayList<String>();
                        FluidMethodInfo info = FluidMethodInfo.create(method);
                        String returnType = info.returnType;
                        if (AnnotationInfo.isAnnotationPresent(TargetClass.class, method)) {
                            returnType = (String)AnnotationInfo.getAnnotation(TargetType.class, method).get("target");
                            returnType = Fluid.mapClass(returnType);
                        }
                        int index = 0;
                        String[] stringArray = info.types;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String string;
                            String typePath = string = stringArray[i];
                            for (AnnotationInfo annotation : FluidMethodInfo.getParameterAnnotations(method, index)) {
                                if (!annotation.is(TargetType.class)) continue;
                                typePath = (String)annotation.get("target");
                                typePath = Fluid.mapClass(typePath);
                            }
                            types.add(typePath);
                            ++index;
                        }
                        String methName = Fluid.mapMethod(clName, method.name, types.toArray(new String[types.size()]));
                        if (AnnotationInfo.isAnnotationPresent(Constructor.class, method)) {
                            methName = AnnotationInfo.getAnnotation(Constructor.class, method).get("clinit", false) != false ? "<clinit>" : "<init>";
                        }
                        int newMod = method.access;
                        newMod -= 1024;
                        if (AnnotationInfo.isAnnotationPresent(Modifiers.class, method)) {
                            newMod = (Integer)AnnotationInfo.getAnnotation(Modifiers.class, method).get("modifiers");
                        }
                        int oldMod = newMod;
                        for (MethodNode methodNode : target.methods) {
                            String desc = methodNode.desc;
                            String mTypesStr = desc.substring(1, desc.lastIndexOf(")"));
                            String mReturnType = Fluid.parseDescriptor(desc.substring(desc.lastIndexOf(")") + 1));
                            Object[] mTypes = Fluid.parseMultipleDescriptors(mTypesStr);
                            if (!methodNode.name.equals(methName) || !Arrays.equals(mTypes, types.toArray(new String[types.size()]))) continue;
                            log.debug("Transforming method: " + method.name + "...");
                            if (!this.applyMethodInterfaceTransformer(ctx, methodNode, method, oldMod, newMod, FluidMethodInfo.create(methodNode.name, (String[])mTypes, mReturnType))) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            throw new RuntimeException("Unable to apply access transformer (interface): " + typeName + ", could not apply method: " + method.name + ", its counterpart could not be found.");
                        }
                        transformedMethods.add(info.name + " " + info.toDescriptor() + " " + clName + " " + methNameFinal + "&" + method.desc + " " + oldMod + " " + newMod);
                    }
                    target.interfaces.add(transformer.name);
                } else {
                    for (MethodNode meth : transformer.methods) {
                        String oMethName;
                        if (AnnotationInfo.isAnnotationPresent(Exclude.class, meth)) continue;
                        if (AnnotationInfo.isAnnotationPresent(ASM.class, meth)) {
                            asmMethods = true;
                            continue;
                        }
                        if (Modifier.isAbstract(meth.access) || AnnotationInfo.isAnnotationPresent(Reflect.class, meth)) continue;
                        String descriptor = meth.desc;
                        FluidMethodInfo info = FluidMethodInfo.create(meth);
                        info.remap(clName, transformer, info, programPool);
                        String methName = info.name;
                        descriptor = info.toDescriptor();
                        String originalDesc = meth.desc;
                        String descFinal = descriptor;
                        String methNameFinal = methName;
                        if (AnnotationInfo.isAnnotationPresent(Erase.class, meth)) {
                            if (!target.methods.stream().anyMatch(t -> t.name.equals(methNameFinal) && t.desc.equals(descFinal))) {
                                throw new RuntimeException("Unable to transform method " + methNameFinal + " of class " + clName + " as it could not be found, transformer: " + typeName);
                            }
                            oMethName = meth.name;
                            MethodNode targetNode = target.methods.stream().filter(t -> t.name.equals(methNameFinal) && t.desc.equals(descFinal)).findFirst().get();
                            log.debug("Transforming method: " + targetNode.name + "... (using transformer method: " + meth.name + ")");
                            int newMod = targetNode.access;
                            if (AnnotationInfo.isAnnotationPresent(Modifiers.class, meth)) {
                                newMod = (Integer)AnnotationInfo.getAnnotation(Modifiers.class, meth).get("modifiers");
                            }
                            this.applyMethodRewriteTransformer(ctx, targetNode, meth, newMod, info);
                            FluidMethodInfo fluidMethodInfo = FluidMethodInfo.create(meth);
                            fluidMethodInfo.remap(clName, transformer, fluidMethodInfo, false, ctx.programPool);
                            transformedMethods.add(fluidMethodInfo.name + " " + fluidMethodInfo.toDescriptor() + " " + clName + " " + oMethName + "&" + originalDesc + " " + newMod + " " + newMod);
                            continue;
                        }
                        if (AnnotationInfo.isAnnotationPresent(InjectAt.class, meth)) {
                            void var28_71;
                            int newMod;
                            if (!target.methods.stream().anyMatch(t -> t.name.equals(methNameFinal) && t.desc.equals(descFinal))) {
                                throw new RuntimeException("Unable to transform method " + methNameFinal + " of class " + clName + " as it could not be found, transformer: " + typeName);
                            }
                            MethodNode targetNode = target.methods.stream().filter(t -> t.name.equals(methNameFinal) && t.desc.equals(descFinal)).findFirst().get();
                            log.debug("Transforming method: " + targetNode.name + "... (using transformer method: " + meth.name + ")");
                            String oMethName2 = meth.name;
                            AnnotationInfo targetData = AnnotationInfo.getAnnotation(InjectAt.class, meth);
                            Object var28_69 = null;
                            String[] targetMethTypes = null;
                            String targetMethCls = null;
                            if (targetData.get("targetCall") != null) {
                                FluidMethodInfo targetCall = FluidMethodInfo.create((String)targetData.get("targetCall"));
                                targetMethCls = target.name;
                                String targetCls = clName;
                                if (targetData.get("targetOwner") != null) {
                                    targetCls = (String)targetData.get("targetOwner");
                                    targetMethCls = Fluid.mapClass(targetCls).replaceAll("\\.", "/");
                                }
                                String superName = targetCls;
                                ClassNode clsT = null;
                                try {
                                    clsT = ctx.programPool.getClassNode(Fluid.mapClass(superName));
                                }
                                catch (ClassNotFoundException e1) {
                                    superName = null;
                                }
                                boolean found = false;
                                if (Fluid.getMappings().length == 0) {
                                    found = true;
                                }
                                while (!found && superName != null) {
                                    for (Mapping<?> map : Fluid.getMappings()) {
                                        for (Mapping<?> mp : map.mappings) {
                                            if (!mp.name.equals(superName) || !Stream.of(mp.mappings).anyMatch(t -> t.mappingType == MAPTYPE.METHOD && t.name.equals(targetCall.name) && Arrays.equals(t.argumentTypes, targetCall.types))) continue;
                                            found = true;
                                            break;
                                        }
                                        if (found) break;
                                    }
                                    if (found) continue;
                                    superName = null;
                                    if (clsT.superName == null || clsT.superName.equals(Object.class.getTypeName().replaceAll("\\.", "/"))) continue;
                                    superName = Transformer.getDeobfName(clsT.superName.replaceAll("/", "."));
                                    try {
                                        clsT = ctx.programPool.getClassNode(clsT.superName);
                                    }
                                    catch (ClassNotFoundException e) {
                                        // empty catch block
                                        break;
                                    }
                                }
                                targetCall.remap(superName, transformer, targetCall, ctx.programPool);
                                String string = targetCall.name;
                                targetMethTypes = targetCall.types;
                            }
                            int oldMod = newMod = targetNode.access;
                            if (AnnotationInfo.isAnnotationPresent(Modifiers.class, meth)) {
                                newMod = (Integer)AnnotationInfo.getAnnotation(Modifiers.class, meth).get("modifiers");
                            }
                            TargetInfo targetInfo = new TargetInfo();
                            targetInfo.location = (InjectLocation)((Object)targetData.get("location"));
                            targetInfo.offset = targetData.get("offset", 0);
                            targetInfo.targetMethodClass = targetMethCls;
                            targetInfo.targetMethodName = var28_71;
                            targetInfo.targetMethodTypes = targetMethTypes;
                            this.applyInjectAt(ctx, targetInfo, targetNode, meth, oldMod, newMod, info);
                            FluidMethodInfo ninfo2 = FluidMethodInfo.create(meth);
                            ninfo2.remap(clName, transformer, ninfo2, false, ctx.programPool);
                            transformedMethods.add(ninfo2.name + " " + ninfo2.toDescriptor() + " " + clName + " " + oMethName2 + "&" + meth.desc + " " + oldMod + " " + newMod);
                            continue;
                        }
                        if (meth.name.equals("<init>")) continue;
                        oMethName = meth.name;
                        if (target.methods.stream().anyMatch(t -> t.name.equals(methNameFinal) && t.desc.equals(descFinal))) {
                            if (meth.name.equals("<clinit>")) continue;
                            throw new RuntimeException("Unable to add method " + methNameFinal + " to class " + clName + " as a method with the same signature already exists, transformer: " + typeName);
                        }
                        for (int i = 0; i < meth.localVariables.size(); ++i) {
                            LocalVariableNode lvn = (LocalVariableNode)meth.localVariables.get(i);
                            if (Fluid.parseDescriptor(lvn.desc).equals(transformer.name.replaceAll("/", "."))) {
                                lvn.desc = Fluid.getDescriptor(target.name);
                            }
                            meth.localVariables.set(i, lvn);
                        }
                        int newMod = meth.access;
                        if (AnnotationInfo.isAnnotationPresent(Modifiers.class, meth)) {
                            newMod = (Integer)AnnotationInfo.getAnnotation(Modifiers.class, meth).get("modifiers");
                        }
                        int oldMod = meth.access;
                        FluidMethodInfo fluidMethodInfo = this.createMethod(ctx, meth, methName, oldMod, newMod);
                        log.debug("Created method " + fluidMethodInfo.name);
                        transformedMethods.add(fluidMethodInfo.name + " " + fluidMethodInfo.toDescriptor() + " " + clName + " " + oMethName + "&" + originalDesc + " " + oldMod + " " + newMod + " true");
                    }
                    for (FieldNode field : transformer.fields) {
                        String superName = clName;
                        ClassNode clsT = null;
                        try {
                            clsT = ctx.programPool.getClassNode(Fluid.mapClass(superName));
                        }
                        catch (ClassNotFoundException e1) {
                            superName = null;
                        }
                        boolean found = false;
                        String fName = field.name;
                        if (Fluid.getMappings().length == 0) {
                            found = true;
                        }
                        while (!found && superName != null) {
                            for (Mapping<?> map : Fluid.getMappings()) {
                                for (Mapping<?> mp : map.mappings) {
                                    if (!mp.name.equals(superName) || !Stream.of(mp.mappings).anyMatch(t -> t.mappingType == MAPTYPE.PROPERTY && t.name.equals(fName))) continue;
                                    found = true;
                                    break;
                                }
                                if (found) break;
                            }
                            if (found) continue;
                            superName = null;
                            if (clsT.superName == null || clsT.superName.equals(Object.class.getTypeName().replaceAll("\\.", "/"))) continue;
                            superName = Transformer.getDeobfName(clsT.superName.replaceAll("/", "."));
                            try {
                                clsT = ctx.programPool.getClassNode(clsT.superName);
                            }
                            catch (ClassNotFoundException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (superName == null) {
                            superName = clName;
                        }
                        String fname = Fluid.mapProperty(superName, field.name);
                        String ftype = Fluid.parseDescriptor(field.desc);
                        if (AnnotationInfo.isAnnotationPresent(TargetType.class, field)) {
                            ftype = (String)AnnotationInfo.getAnnotation(TargetType.class, field).get("target");
                        }
                        int newMod = -1;
                        if (AnnotationInfo.isAnnotationPresent(Modifiers.class, field)) {
                            newMod = (Integer)AnnotationInfo.getAnnotation(Modifiers.class, field).get("modifiers");
                        }
                        boolean isNew = false;
                        if (!this.checkField(fname, ctx.programPool, target)) {
                            field.desc = Fluid.getDescriptor(Fluid.mapClass(ftype));
                            target.fields.add(field);
                            isNew = true;
                        } else {
                            field = this.getField(fname, ctx.programPool, target);
                        }
                        int oldMod = field.access;
                        if (newMod != -1) {
                            field.access = newMod;
                        }
                        transformedFields.add(fName + " " + Fluid.getDescriptor(ftype) + " " + superName + " " + fName + " " + oldMod + " " + field.access + " " + isNew);
                    }
                    for (Method[] _interface : transformer.interfaces) {
                        if (target.interfaces.contains(_interface)) continue;
                        target.interfaces.add(_interface);
                    }
                    if (asmMethods) {
                        log.debug("Loading transformer " + typeName + " as a class, it contains @ASM methods...");
                        try {
                            Class<?> transformerCls = ClassLoader.getSystemClassLoader().loadClass(typeName);
                            for (Method meth : transformerCls.getMethods()) {
                                if (!Modifier.isStatic(meth.getModifiers()) || !meth.isAnnotationPresent(ASM.class)) continue;
                                log.debug("Transforming " + clName + " with ASM-based transformer " + meth.getName() + "... Transformer class: " + typeName);
                                ArrayList<Object> params = new ArrayList<Object>();
                                boolean clsPoolAdded = false;
                                boolean clsNameAdded = false;
                                boolean error = false;
                                int nodes = 0;
                                for (Parameter param : meth.getParameters()) {
                                    if (param.getType().getTypeName().equals(FluidClassPool.class.getTypeName()) && !clsPoolAdded) {
                                        params.add(ctx.programPool);
                                        clsPoolAdded = true;
                                        continue;
                                    }
                                    if (param.getType().getTypeName().equals(ClassNode.class.getTypeName()) && nodes < 2) {
                                        if (nodes == 0) {
                                            params.add(ctx.targetClass);
                                            ++nodes;
                                            continue;
                                        }
                                        if (nodes != 1) continue;
                                        params.add(ctx.transformer);
                                        ++nodes;
                                        continue;
                                    }
                                    if (param.getType().isAssignableFrom(String.class) && !clsNameAdded) {
                                        params.add(loadingName);
                                        clsNameAdded = true;
                                        continue;
                                    }
                                    log.error("Unable to run @ASM transformer method: " + meth.getName() + ", could not recognize parameter: " + param.getName() + " of type " + param.getType().getTypeName());
                                    log.error("Known parameters:");
                                    log.error(" - second ClassNode   - transformer class");
                                    log.error(" - first ClassNode    - target class");
                                    log.error(" - FluidClassPool     - class pool used to load the transformers and classes");
                                    log.error(" - String             - deobfuscated class name");
                                    error = true;
                                    break;
                                }
                                if (error) continue;
                                try {
                                    meth.invoke(null, (Object[])params.toArray(Object[]::new));
                                }
                                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                                    log.error("Failed to transform with ASM transformer " + meth.getName() + ", transformer: " + typeName, (Throwable)e);
                                }
                            }
                        }
                        catch (ClassNotFoundException e) {
                            log.error("Failed to load transformer " + typeName + " as a class, needed for @ASM methods.", (Throwable)e);
                        }
                    }
                }
                TransformerMetadata.createMetadata(transformer, transformerOwners.get(transformer.name), transformedFields, transformedMethods, ctx.programPool);
                try {
                    transformerPool.detachClass(transformer.name);
                    transformer = transformerPool.getClassNode(transformer.name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                arr.set(transformerIndex, transformer);
                transformers.put(loadingName, arr);
                ++transformerIndex;
            }
            catch (Exception ex) {
                log.fatal("FLUID transformation failed! Transformer: " + typeName, (Throwable)ex);
                File output = new File(Fluid.getDumpDir(), "transformer-backtrace");
                try {
                    TransformerMetadata.dumpErrorBacktrace(ex.getClass().getTypeName() + ": " + ex.getMessage(), ex.getStackTrace(), output);
                }
                catch (Exception e) {
                    log.error("Could not dump FLUID transformer metadata, an exception was thrown.", (Throwable)e);
                }
                System.exit(1);
            }
        }
    }

    protected abstract void applyClassModifiers(TransformContext var1, int var2, int var3);

    protected abstract boolean applyMethodInterfaceTransformer(TransformContext var1, MethodNode var2, MethodNode var3, int var4, int var5, FluidMethodInfo var6);

    protected abstract void applyMethodRewriteTransformer(TransformContext var1, MethodNode var2, MethodNode var3, int var4, FluidMethodInfo var5);

    protected abstract void applyInjectAt(TransformContext var1, TargetInfo var2, MethodNode var3, MethodNode var4, int var5, int var6, FluidMethodInfo var7);

    protected abstract FluidMethodInfo createMethod(TransformContext var1, MethodNode var2, String var3, int var4, int var5);

    protected abstract boolean checkField(String var1, FluidClassPool var2, ClassNode var3);

    protected abstract FieldNode getField(String var1, FluidClassPool var2, ClassNode var3);

    protected abstract List<AnnotationInfo> getParameterAnnotations(MethodNode var1, int var2);

    protected abstract FluidMethodInfo createFMI(String var1, String[] var2, String var3, String var4);

    protected abstract FluidMethodInfo createFMI(String var1, String var2);

    protected abstract FluidMethodInfo createFMI(String var1);

    protected abstract FluidMethodInfo createFMI(MethodInsnNode var1);

    protected abstract FluidMethodInfo createFMI(MethodNode var1);

    protected abstract FluidMethodInfo createFMI(String var1, String[] var2, String var3);

    protected abstract MethodNode remapFMI(FluidMethodInfo var1, String var2, ClassNode var3, FluidMethodInfo var4, boolean var5, FluidClassPool var6);

    protected abstract FluidMethodInfo applyFMI(FluidMethodInfo var1, MethodNode var2);

    protected abstract FluidMethodInfo applyFMI(FluidMethodInfo var1, String var2, MethodInsnNode var3);

    protected abstract FluidMethodInfo transformFMI(FluidMethodInfo var1, InsnList var2, ClassNode var3, String var4, ClassNode var5, FluidClassPool var6);

    protected abstract AnnotationInfo createAnnoInfo(AnnotationNode var1);

    protected abstract AnnotationInfo[] createAnnoInfo(AbstractInsnNode var1);

    protected abstract AnnotationInfo[] createAnnoInfo(MethodNode var1);

    protected abstract AnnotationInfo[] createAnnoInfo(FieldNode var1);

    protected abstract AnnotationInfo[] createAnnoInfo(ClassNode var1);

    protected static void setImplementation(Transformer transformerEngine) {
        log.debug("Assigning FLUID Modification Engine... Using the " + transformerEngine.getImplementationName() + " Modification Engine...");
        selectedTransformer = transformerEngine;
    }

    public static String getDeobfName(String clName) {
        return selectedTransformer.getDeobfNameInternal(clName);
    }

    public static byte[] transform(ClassNode cls, Map<String, String> transformerOwners, Map<String, ArrayList<ClassNode>> transformers, String clName, String loadingName, FluidClassPool pool, FluidClassPool transformerPool, ClassLoader loader) {
        selectedTransformer.runTransformers(cls, clName, loadingName, transformerOwners, transformers, transformerPool, pool);
        FluidClassWriter clsWriter = new FluidClassWriter(pool, 2, loader);
        cls.accept((ClassVisitor)clsWriter);
        byte[] bytecode = clsWriter.toByteArray();
        try {
            pool.rewriteClass(cls.name, bytecode);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return bytecode;
    }

    protected class TransformContext {
        public ClassNode targetClass;
        public String mappedName;
        public String obfuscatedName;
        public String transformerOwner;
        public String transformerType;
        public ClassNode transformer;
        public FluidClassPool programPool;
        public FluidClassPool transformerPool;

        protected TransformContext() {
        }
    }

    public static class AnnotationInfo {
        public String name;
        public HashMap<String, Object> values = new HashMap();

        public String toString() {
            return this.name;
        }

        public static AnnotationInfo getAnnotation(Class<?> annotation, ClassNode node) {
            AnnotationInfo info;
            if (node.visibleAnnotations != null) {
                for (AnnotationNode anno : node.visibleAnnotations) {
                    info = AnnotationInfo.create(anno);
                    if (!info.name.replaceAll("/", ".").equals(annotation.getTypeName())) continue;
                    return info;
                }
            }
            if (node.invisibleAnnotations != null) {
                for (AnnotationNode anno : node.invisibleAnnotations) {
                    info = AnnotationInfo.create(anno);
                    if (!info.name.replaceAll("/", ".").equals(annotation.getTypeName())) continue;
                    return info;
                }
            }
            return null;
        }

        public static AnnotationInfo getAnnotation(Class<?> annotation, MethodNode node) {
            AnnotationInfo info;
            if (node.visibleAnnotations != null) {
                for (AnnotationNode anno : node.visibleAnnotations) {
                    info = AnnotationInfo.create(anno);
                    if (!info.name.replaceAll("/", ".").equals(annotation.getTypeName())) continue;
                    return info;
                }
            }
            if (node.invisibleAnnotations != null) {
                for (AnnotationNode anno : node.invisibleAnnotations) {
                    info = AnnotationInfo.create(anno);
                    if (!info.name.replaceAll("/", ".").equals(annotation.getTypeName())) continue;
                    return info;
                }
            }
            return null;
        }

        public static AnnotationInfo getAnnotation(Class<?> annotation, FieldNode node) {
            AnnotationInfo info;
            if (node.visibleAnnotations != null) {
                for (AnnotationNode anno : node.visibleAnnotations) {
                    info = AnnotationInfo.create(anno);
                    if (!info.name.replaceAll("/", ".").equals(annotation.getTypeName())) continue;
                    return info;
                }
            }
            if (node.invisibleAnnotations != null) {
                for (AnnotationNode anno : node.invisibleAnnotations) {
                    info = AnnotationInfo.create(anno);
                    if (!info.name.replaceAll("/", ".").equals(annotation.getTypeName())) continue;
                    return info;
                }
            }
            return null;
        }

        public static AnnotationInfo getAnnotation(Class<?> annotation, AbstractInsnNode node) {
            AnnotationInfo info;
            if (node.visibleTypeAnnotations != null) {
                for (AnnotationNode anno : node.visibleTypeAnnotations) {
                    info = AnnotationInfo.create(anno);
                    if (!info.name.replaceAll("/", ".").equals(annotation.getTypeName())) continue;
                    return info;
                }
            }
            if (node.invisibleTypeAnnotations != null) {
                for (AnnotationNode anno : node.invisibleTypeAnnotations) {
                    info = AnnotationInfo.create(anno);
                    if (!info.name.replaceAll("/", ".").equals(annotation.getTypeName())) continue;
                    return info;
                }
            }
            return null;
        }

        public static boolean isAnnotationPresent(AnnotationInfo info, ClassNode cls) {
            if (cls.visibleAnnotations != null) {
                for (AnnotationNode anno : cls.visibleAnnotations) {
                    if (!AnnotationInfo.create(anno).equals(info)) continue;
                    return true;
                }
            }
            if (cls.invisibleAnnotations != null) {
                for (AnnotationNode anno : cls.invisibleAnnotations) {
                    if (!AnnotationInfo.create(anno).equals(info)) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean isAnnotationPresent(AnnotationInfo info, MethodNode cls) {
            if (cls.visibleAnnotations != null) {
                for (AnnotationNode anno : cls.visibleAnnotations) {
                    if (!AnnotationInfo.create(anno).equals(info)) continue;
                    return true;
                }
            }
            if (cls.invisibleAnnotations != null) {
                for (AnnotationNode anno : cls.invisibleAnnotations) {
                    if (!AnnotationInfo.create(anno).equals(info)) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean isAnnotationPresent(AnnotationInfo info, FieldNode cls) {
            if (cls.visibleAnnotations != null) {
                for (AnnotationNode anno : cls.visibleAnnotations) {
                    if (!AnnotationInfo.create(anno).equals(info)) continue;
                    return true;
                }
            }
            if (cls.invisibleAnnotations != null) {
                for (AnnotationNode anno : cls.invisibleAnnotations) {
                    if (!AnnotationInfo.create(anno).equals(info)) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean isAnnotationPresent(AnnotationInfo info, AbstractInsnNode cls) {
            if (cls.visibleTypeAnnotations != null) {
                for (AnnotationNode anno : cls.visibleTypeAnnotations) {
                    if (!AnnotationInfo.create(anno).equals(info)) continue;
                    return true;
                }
            }
            if (cls.invisibleTypeAnnotations != null) {
                for (AnnotationNode anno : cls.invisibleTypeAnnotations) {
                    if (!AnnotationInfo.create(anno).equals(info)) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean isAnnotationPresent(Class<? extends Annotation> info, ClassNode cls) {
            if (cls.visibleAnnotations != null) {
                for (AnnotationNode anno : cls.visibleAnnotations) {
                    if (!AnnotationInfo.create((AnnotationNode)anno).name.replaceAll("/", ".").equals(info.getTypeName())) continue;
                    return true;
                }
            }
            if (cls.invisibleAnnotations != null) {
                for (AnnotationNode anno : cls.invisibleAnnotations) {
                    if (!AnnotationInfo.create((AnnotationNode)anno).name.replaceAll("/", ".").equals(info.getTypeName())) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean isAnnotationPresent(Class<? extends Annotation> info, MethodNode cls) {
            if (cls.visibleAnnotations != null) {
                for (AnnotationNode anno : cls.visibleAnnotations) {
                    if (!AnnotationInfo.create((AnnotationNode)anno).name.replaceAll("/", ".").equals(info.getTypeName())) continue;
                    return true;
                }
            }
            if (cls.invisibleAnnotations != null) {
                for (AnnotationNode anno : cls.invisibleAnnotations) {
                    if (!AnnotationInfo.create((AnnotationNode)anno).name.replaceAll("/", ".").equals(info.getTypeName())) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean isAnnotationPresent(Class<? extends Annotation> info, FieldNode cls) {
            if (cls.visibleAnnotations != null) {
                for (AnnotationNode anno : cls.visibleAnnotations) {
                    if (!AnnotationInfo.create((AnnotationNode)anno).name.replaceAll("/", ".").equals(info.getTypeName())) continue;
                    return true;
                }
            }
            if (cls.invisibleAnnotations != null) {
                for (AnnotationNode anno : cls.invisibleAnnotations) {
                    if (!AnnotationInfo.create((AnnotationNode)anno).name.replaceAll("/", ".").equals(info.getTypeName())) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean isAnnotationPresent(Class<? extends Annotation> info, AbstractInsnNode cls) {
            if (cls.visibleTypeAnnotations != null) {
                for (AnnotationNode anno : cls.visibleTypeAnnotations) {
                    if (!AnnotationInfo.create((AnnotationNode)anno).name.replaceAll("/", ".").equals(info.getTypeName())) continue;
                    return true;
                }
            }
            if (cls.invisibleTypeAnnotations != null) {
                for (AnnotationNode anno : cls.invisibleTypeAnnotations) {
                    if (!AnnotationInfo.create((AnnotationNode)anno).name.replaceAll("/", ".").equals(info.getTypeName())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object compareTo) {
            return compareTo.toString().equals(this.toString());
        }

        public <T> T get(String param, T def) {
            return (T)this.values.getOrDefault(param, def);
        }

        public <T> T get(String param) {
            return this.get(param, null);
        }

        public boolean is(Class<?> cls) {
            return cls.getTypeName().equals(this.name.replaceAll("/", "."));
        }

        public Class<?> annotationType() {
            try {
                return Class.forName(this.name.replaceAll("/", "."));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public static AnnotationInfo create(AnnotationNode node) {
            return selectedTransformer.createAnnoInfo(node);
        }

        public static AnnotationInfo[] create(ClassNode node) {
            return selectedTransformer.createAnnoInfo(node);
        }

        public static AnnotationInfo[] create(MethodNode node) {
            return selectedTransformer.createAnnoInfo(node);
        }

        public static AnnotationInfo[] create(FieldNode node) {
            return selectedTransformer.createAnnoInfo(node);
        }

        public static AnnotationInfo[] create(AbstractInsnNode node) {
            return selectedTransformer.createAnnoInfo(node);
        }
    }

    public static class FluidMethodInfo {
        public String name;
        public String[] types;
        public String owner;
        public String returnType;

        public int getVarOffset() {
            int i = 0;
            for (String type : this.types) {
                if (type.equals("double")) {
                    i += 2;
                    continue;
                }
                ++i;
            }
            return i;
        }

        public static List<AnnotationInfo> getParameterAnnotations(MethodNode method, int param) {
            return selectedTransformer.getParameterAnnotations(method, param);
        }

        public static FluidMethodInfo create(MethodNode method) {
            return selectedTransformer.createFMI(method);
        }

        public static FluidMethodInfo create(MethodInsnNode method) {
            return selectedTransformer.createFMI(method);
        }

        public static FluidMethodInfo create(String methodName, String methodDesc) {
            return selectedTransformer.createFMI(methodName, methodDesc);
        }

        public static FluidMethodInfo create(String methodIdentifier) {
            return selectedTransformer.createFMI(methodIdentifier);
        }

        public static FluidMethodInfo create(String name, String[] types, String returnType) {
            return selectedTransformer.createFMI(name, types, returnType);
        }

        public static FluidMethodInfo create(String name, String[] types, String returnType, String owner) {
            return selectedTransformer.createFMI(name, types, returnType, owner);
        }

        public MethodNode remap(String clName, ClassNode transformerNode, FluidMethodInfo method, FluidClassPool pool) {
            return this.remap(clName, transformerNode, method, true, pool);
        }

        public MethodNode remap(String clName, ClassNode transformerNode, FluidMethodInfo method, boolean fullRemap, FluidClassPool pool) {
            return selectedTransformer.remapFMI(this, clName, transformerNode, method, fullRemap, pool);
        }

        public FluidMethodInfo apply(MethodNode method) {
            return selectedTransformer.applyFMI(this, method);
        }

        public FluidMethodInfo apply(String owner, MethodInsnNode method) {
            return selectedTransformer.applyFMI(this, owner, method);
        }

        public FluidMethodInfo transform(InsnList instructions, ClassNode transformerNode, String clName, ClassNode cls, FluidClassPool pool) {
            return selectedTransformer.transformFMI(this, instructions, transformerNode, clName, cls, pool);
        }

        public String toString() {
            return this.name + " (" + Fluid.getDescriptors(this.types) + ")" + Fluid.getDescriptor(this.returnType);
        }

        public boolean equals(Object compareTo) {
            return compareTo.toString().equals(this.toString());
        }

        public String toDescriptor() {
            return "(" + Fluid.getDescriptors(this.types) + ")" + Fluid.getDescriptor(this.returnType);
        }
    }

    protected class TargetInfo {
        public InjectLocation location;
        public int offset;
        public String targetMethodName;
        public String targetMethodClass;
        public String[] targetMethodTypes;

        protected TargetInfo() {
        }
    }
}

