/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.util.inventory;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.gameplayapi.util.inventory.ItemRedemptionInfo;
import org.asf.edge.gameplayapi.xmls.inventories.InventoryUpdateResponseData;

public abstract class AbstractItemRedemptionHandler {
    public abstract boolean canHandle(ItemInfo var1);

    public boolean delegating() {
        return false;
    }

    public abstract RedemptionResult handleRedemption(ItemInfo var1, ItemRedemptionInfo var2, AccountObject var3, AccountSaveContainer var4, InventoryUpdateResponseData.CurrencyUpdateBlock var5);

    public static class RedemptionResult {
        private boolean success;
        private InventoryUpdateResponseData.ItemUpdateBlock update;
        private ObjectNode infoBlock;

        public RedemptionResult(boolean success, InventoryUpdateResponseData.ItemUpdateBlock update, ObjectNode infoBlock) {
            this.success = success;
            this.update = update;
            this.infoBlock = infoBlock;
        }

        public boolean isSuccessful() {
            return this.success;
        }

        public InventoryUpdateResponseData.ItemUpdateBlock getUpdate() {
            return this.update;
        }

        public ObjectNode getItemDef() {
            return this.infoBlock;
        }

        public static RedemptionResult failure() {
            return new RedemptionResult(false, null, null);
        }

        public static RedemptionResult success() {
            return new RedemptionResult(true, null, null);
        }

        public static RedemptionResult failure(ObjectNode info, InventoryUpdateResponseData.ItemUpdateBlock update) {
            return new RedemptionResult(false, update, info);
        }

        public static RedemptionResult success(ObjectNode info, InventoryUpdateResponseData.ItemUpdateBlock update) {
            return new RedemptionResult(true, update, info);
        }
    }
}

