/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.http.handlers.achievements;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.stream.IntStream;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.entities.achivements.EntityRankInfo;
import org.asf.edge.common.entities.achivements.RankInfo;
import org.asf.edge.common.entities.achivements.RankMultiplierInfo;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionResult;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequest;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequestParam;
import org.asf.edge.common.http.apihandlerutils.functions.SodTokenSecured;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireCapability;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireSave;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.xmls.achievements.AchievementInfoList;
import org.asf.edge.common.xmls.achievements.UserRankData;
import org.asf.edge.common.xmls.achievements.UserRankList;
import org.asf.edge.gameplayapi.EdgeGameplayApiServer;
import org.asf.edge.gameplayapi.xmls.achievements.AchievementRewardList;
import org.asf.edge.gameplayapi.xmls.multipliers.RewardTypeMultiplierData;
import org.asf.edge.gameplayapi.xmls.multipliers.RewardTypeMultiplierListData;

public class AchievementWebServiceV1Processor
extends EdgeWebService<EdgeGameplayApiServer> {
    private static AchievementManager achievementManager;

    public AchievementWebServiceV1Processor(EdgeGameplayApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new AchievementWebServiceV1Processor((EdgeGameplayApiServer)this.getServerInstance());
    }

    public String path() {
        return "/AchievementWebService.asmx";
    }

    @SodRequest
    public FunctionResult getAllRanks(FunctionInfo func, EdgeWebService.ServiceRequestInfo req) throws IOException {
        if (achievementManager == null) {
            achievementManager = AchievementManager.getInstance();
        }
        RankInfo[] ranks = achievementManager.getRankDefinitions();
        UserRankData.UserRankDataWrapper[] defs = new UserRankData.UserRankDataWrapper[ranks.length];
        for (int i = 0; i < ranks.length; ++i) {
            defs[i] = ranks[i].getRawObject().getWrapped();
        }
        UserRankList lst = new UserRankList();
        lst.ranks = defs;
        return this.ok("text/xml", req.generateXmlValue("ArrayOfUserRank", (Object)lst));
    }

    @SodRequest
    public FunctionResult getAchievementTaskInfo(FunctionInfo func, EdgeWebService.ServiceRequestInfo req) throws IOException {
        if (achievementManager == null) {
            achievementManager = AchievementManager.getInstance();
        }
        int[] ids = (int[])req.parseXmlValue((String)req.payload.get("achievementTaskIDList"), int[].class);
        InputStream strm = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("achievementdata/achievementtasks.xml");
        ObjectNode[] achievementTasks = (ObjectNode[])req.parseXmlValue(new String(strm.readAllBytes(), "UTF-8"), ObjectNode[].class);
        strm.close();
        ArrayList<ObjectNode> tasks = new ArrayList<ObjectNode>();
        for (ObjectNode tsk : achievementTasks) {
            if (ids.length != 0 && !IntStream.of(ids).anyMatch(t -> t == tsk.get("AchievementTaskID").asInt())) continue;
            tasks.add(tsk);
        }
        AchievementTaskInfoList lst = new AchievementTaskInfoList();
        lst.achievementTasks = (ObjectNode[])tasks.toArray(ObjectNode[]::new);
        return this.ok("text/xml", req.generateXmlValue("ArrayOfAchievementTaskInfo", (Object)lst));
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult setUserAchievementAndGetReward(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, AccountSaveContainer save) throws IOException {
        if (achievementManager == null) {
            achievementManager = AchievementManager.getInstance();
        }
        return this.ok("text/xml", req.generateXmlValue("ArrayOfAchievementReward", (Object)new AchievementRewardList()));
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult setAchievementByEntityIDs(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, AccountSaveContainer save, @SodRequestParam int achievementID, @SodRequestParam String groupID, @SodRequestParam String[] petIDs) throws IOException {
        if (achievementManager == null) {
            achievementManager = AchievementManager.getInstance();
        }
        return this.ok("text/xml", req.generateXmlValue("ArrayOfAchievementReward", (Object)new AchievementRewardList()));
    }

    @SodRequest
    @SodTokenSecured
    public FunctionResult getPetAchievementsByUserID(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam String userId) throws IOException {
        AccountSaveContainer save = account.getSave(userId);
        if (save == null) {
            if (tkn.saveID != null) {
                save = account.getSave(tkn.saveID);
            }
            if (save == null) {
                return this.response(404, "Not found");
            }
        }
        AchievementInfoList lst = new AchievementInfoList();
        ArrayList<AchievementInfoList.AchievementBlock> ranks = new ArrayList<AchievementInfoList.AchievementBlock>();
        AccountDataContainer data = save.getSaveData().getChildContainer("dragons");
        JsonArray dragonIds = new JsonArray();
        if (data.entryExists("dragonlist")) {
            dragonIds = data.getEntry("dragonlist").getAsJsonArray();
        } else {
            data.setEntry("dragonlist", (JsonElement)dragonIds);
        }
        for (JsonElement ele : dragonIds) {
            String did = ele.getAsString();
            ObjectNode dragon = (ObjectNode)req.parseXmlValue(data.getEntry("dragon-" + did).getAsString(), ObjectNode.class);
            for (EntityRankInfo rank : AchievementManager.getInstance().getRanks(save, dragon.get("eid").asText())) {
                AchievementInfoList.AchievementBlock r = new AchievementInfoList.AchievementBlock();
                r.userID = new AchievementInfoList.AchievementBlock.StringWrapper(rank.getEntityID());
                r.pointTypeID = new AchievementInfoList.AchievementBlock.IntWrapper(rank.getTypeID().getPointTypeID());
                r.pointsTotal = new AchievementInfoList.AchievementBlock.IntWrapper(rank.getTotalScore());
                r.rank = new AchievementInfoList.AchievementBlock.IntWrapper(AchievementManager.getInstance().getRankIndex(rank.getRank()) + 1);
                ranks.add(r);
            }
        }
        lst.achievements = (AchievementInfoList.AchievementBlock[])ranks.toArray(AchievementInfoList.AchievementBlock[]::new);
        return this.ok("text/xml", req.generateXmlValue("ArrayOfUserAchievementInfo", (Object)lst));
    }

    @SodRequest
    @SodTokenSecured
    public FunctionResult getAchievementsByUserID(FunctionInfo func, SessionToken tkn, EdgeWebService.ServiceRequestInfo req, AccountObject account, @SodRequestParam String userId) throws IOException {
        AccountSaveContainer save = account.getSave(userId);
        if (save == null) {
            if (tkn.saveID != null) {
                save = account.getSave(tkn.saveID);
            }
            if (save == null) {
                return this.response(404, "Not found");
            }
        }
        AchievementInfoList lst = new AchievementInfoList();
        ArrayList<AchievementInfoList.AchievementBlock> ranks = new ArrayList<AchievementInfoList.AchievementBlock>();
        for (EntityRankInfo rank : AchievementManager.getInstance().getRanks(save, userId)) {
            AchievementInfoList.AchievementBlock r = new AchievementInfoList.AchievementBlock();
            if (userId.equals(save.getSaveID())) {
                r.saveName = new AchievementInfoList.AchievementBlock.StringWrapper(save.getUsername());
            }
            r.userID = new AchievementInfoList.AchievementBlock.StringWrapper(rank.getEntityID());
            r.pointTypeID = new AchievementInfoList.AchievementBlock.IntWrapper(rank.getTypeID().getPointTypeID());
            r.pointsTotal = new AchievementInfoList.AchievementBlock.IntWrapper(rank.getTotalScore());
            r.rank = new AchievementInfoList.AchievementBlock.IntWrapper(AchievementManager.getInstance().getRankIndex(rank.getRank()) + 1);
            ranks.add(r);
        }
        lst.achievements = (AchievementInfoList.AchievementBlock[])ranks.toArray(AchievementInfoList.AchievementBlock[]::new);
        return this.ok("text/xml", req.generateXmlValue("ArrayOfUserAchievementInfo", (Object)lst));
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult getUserAchievements(FunctionInfo func, SessionToken tkn, EdgeWebService.ServiceRequestInfo req, AccountObject account, AccountSaveContainer save) throws IOException {
        AchievementInfoList lst = new AchievementInfoList();
        ArrayList<AchievementInfoList.AchievementBlock> ranks = new ArrayList<AchievementInfoList.AchievementBlock>();
        for (EntityRankInfo rank : AchievementManager.getInstance().getRanks(save, save.getSaveID())) {
            AchievementInfoList.AchievementBlock r = new AchievementInfoList.AchievementBlock();
            r.saveName = new AchievementInfoList.AchievementBlock.StringWrapper(save.getUsername());
            r.userID = new AchievementInfoList.AchievementBlock.StringWrapper(rank.getEntityID());
            r.pointTypeID = new AchievementInfoList.AchievementBlock.IntWrapper(rank.getTypeID().getPointTypeID());
            r.pointsTotal = new AchievementInfoList.AchievementBlock.IntWrapper(rank.getTotalScore());
            r.rank = new AchievementInfoList.AchievementBlock.IntWrapper(AchievementManager.getInstance().getRankIndex(rank.getRank()) + 1);
            ranks.add(r);
        }
        lst.achievements = (AchievementInfoList.AchievementBlock[])ranks.toArray(AchievementInfoList.AchievementBlock[]::new);
        return this.ok("text/xml", req.generateXmlValue("ArrayOfUserAchievementInfo", (Object)lst));
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult getAllRewardTypeMultiplier(FunctionInfo func, SessionToken tkn, EdgeWebService.ServiceRequestInfo req, AccountObject account, AccountSaveContainer save) throws IOException {
        ArrayList<RewardTypeMultiplierData> multipliers = new ArrayList<RewardTypeMultiplierData>();
        for (RankMultiplierInfo m : AchievementManager.getInstance().getServerwideRankMultipliers()) {
            SimpleDateFormat fmt2 = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
            fmt2.setTimeZone(TimeZone.getTimeZone("UTC"));
            RewardTypeMultiplierData data = new RewardTypeMultiplierData();
            data.typeID = m.getPointType().getPointTypeID();
            data.factor = m.getMultiplicationFactor();
            data.expiryTime = fmt2.format(new Date(m.getExpiryTime()));
            multipliers.add(data);
        }
        RewardTypeMultiplierListData resp = new RewardTypeMultiplierListData();
        resp.multipliers = (RewardTypeMultiplierData[])multipliers.toArray(RewardTypeMultiplierData[]::new);
        return this.ok("text/xml", req.generateXmlValue("ArrayOfRewardTypeMultiplier", (Object)resp));
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult setDragonXP(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, AccountSaveContainer save, @SodRequestParam String dragonId, @SodRequestParam int value) throws IOException {
        EntityRankInfo rank = AchievementManager.getInstance().getRank(save, dragonId, RankTypeID.DRAGON);
        if (rank == null) {
            return this.response(409, "Conflict", "Dragon not found");
        }
        rank.setTotalScore(value);
        return this.ok("text/plain", "OK");
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult setPlayerXP(AccountSaveContainer save, EdgeWebService.ServiceRequestInfo req, @SodRequestParam int type, @SodRequestParam int value) throws IOException {
        EntityRankInfo rank = AchievementManager.getInstance().getRank(save, save.getSaveID(), RankTypeID.getByTypeID((int)type));
        rank.setTotalScore(value);
        return this.ok("text/plain", "OK");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
    private static class AchievementTaskInfoList {
        @JacksonXmlProperty(localName="xmlns", isAttribute=true)
        private final String xmlns = "http://api.jumpstart.com/";
        @JsonProperty(value="AchievementTaskInfo")
        @JacksonXmlElementWrapper(useWrapping=false)
        public ObjectNode[] achievementTasks;

        private AchievementTaskInfoList() {
        }
    }
}

