/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective;

import java.io.IOException;
import java.util.ArrayList;
import org.asf.connective.ConnectiveHttpServer;
import org.asf.connective.ContentSource;
import org.asf.connective.RemoteClient;
import org.asf.connective.objects.HttpRequest;
import org.asf.connective.objects.HttpResponse;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.connective.processors.HttpRequestProcessor;

class DefaultContentSource
extends ContentSource {
    DefaultContentSource() {
    }

    private String sanitizePath(String path) {
        while (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        }
        while (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        while (((String)path).contains("//")) {
            path = ((String)path).replace("//", "/");
        }
        if (((String)path).contains("\\")) {
            path = ((String)path).replace("\\", "/");
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    @Override
    public boolean process(String path, HttpRequest request, HttpResponse response, RemoteClient client, ConnectiveHttpServer server) throws IOException {
        HttpRequestProcessor impl;
        ArrayList<HttpRequestProcessor> reqProcessors = new ArrayList<HttpRequestProcessor>(server.reqProcessors);
        ArrayList<HttpPushProcessor> pushProcessors = new ArrayList<HttpPushProcessor>(server.pushProcessors);
        boolean compatible = false;
        for (HttpPushProcessor httpPushProcessor : pushProcessors) {
            if (!httpPushProcessor.supportsNonPush()) continue;
            reqProcessors.add(httpPushProcessor);
        }
        if (request.hasRequestBody()) {
            Object supportedURL;
            Object url;
            impl = null;
            for (HttpPushProcessor proc : pushProcessors) {
                if (proc.supportsChildPaths()) continue;
                url = request.getRequestPath();
                if (!((String)url).endsWith("/")) {
                    url = (String)url + "/";
                }
                if (!((String)(supportedURL = proc.path())).endsWith("/")) {
                    supportedURL = (String)supportedURL + "/";
                }
                if (!((String)url).equals(supportedURL)) continue;
                compatible = true;
                impl = proc;
                break;
            }
            if (!compatible) {
                pushProcessors.sort((t1, t2) -> -Integer.compare(this.sanitizePath(t1.path()).split("/").length, this.sanitizePath(t2.path()).split("/").length));
                for (HttpPushProcessor proc : pushProcessors) {
                    if (!proc.supportsChildPaths()) continue;
                    url = request.getRequestPath();
                    if (!((String)url).endsWith("/")) {
                        url = (String)url + "/";
                    }
                    if (!((String)(supportedURL = this.sanitizePath(proc.path()))).endsWith("/")) {
                        supportedURL = (String)supportedURL + "/";
                    }
                    if (!((String)url).startsWith((String)supportedURL)) continue;
                    compatible = true;
                    impl = proc;
                    break;
                }
            }
            if (compatible) {
                HttpPushProcessor httpPushProcessor = impl.instantiate(server, request, response);
                httpPushProcessor.process(path, request.getRequestMethod(), client, request.getHeaderValue("Content-Type"));
            }
        } else {
            Object supportedURL;
            Object url;
            impl = null;
            for (HttpRequestProcessor proc : reqProcessors) {
                if (proc.supportsChildPaths()) continue;
                url = request.getRequestPath();
                if (!((String)url).endsWith("/")) {
                    url = (String)url + "/";
                }
                if (!((String)(supportedURL = proc.path())).endsWith("/")) {
                    supportedURL = (String)supportedURL + "/";
                }
                if (!((String)url).equals(supportedURL)) continue;
                compatible = true;
                impl = proc;
                break;
            }
            if (!compatible) {
                reqProcessors.sort((t1, t2) -> -Integer.compare(this.sanitizePath(t1.path()).split("/").length, this.sanitizePath(t2.path()).split("/").length));
                for (HttpRequestProcessor proc : reqProcessors) {
                    if (!proc.supportsChildPaths()) continue;
                    url = request.getRequestPath();
                    if (!((String)url).endsWith("/")) {
                        url = (String)url + "/";
                    }
                    if (!((String)(supportedURL = this.sanitizePath(proc.path()))).endsWith("/")) {
                        supportedURL = (String)supportedURL + "/";
                    }
                    if (!((String)url).startsWith((String)supportedURL)) continue;
                    compatible = true;
                    impl = proc;
                    break;
                }
            }
            if (compatible) {
                HttpRequestProcessor httpRequestProcessor = ((HttpRequestProcessor)impl).instantiate(server, request, response);
                httpRequestProcessor.process(path, request.getRequestMethod(), client);
            }
        }
        return compatible;
    }
}

