/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.http.handlers.api.accounts;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.Stream;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.commonapi.EdgeCommonApiServer;
import org.asf.edge.commonapi.xmls.auth.ChildAvatarRegistrationData;
import org.asf.edge.commonapi.xmls.auth.LoginStatusType;
import org.asf.edge.commonapi.xmls.auth.RegistrationResultData;

public class RegistrationWebServiceV4Processor
extends EdgeWebService<EdgeCommonApiServer> {
    private static AccountManager manager;

    public RegistrationWebServiceV4Processor(EdgeCommonApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new RegistrationWebServiceV4Processor((EdgeCommonApiServer)this.getServerInstance());
    }

    public String path() {
        return "/v4/RegistrationWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        this.setResponseStatus(404, "Not found");
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void registerChild(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("parentApiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        ChildAvatarRegistrationData reg = (ChildAvatarRegistrationData)req.parseXmlValue(req.getEncryptedValue("childRegistrationData"), ChildAvatarRegistrationData.class);
        if (!manager.isValidUsername(reg.name)) {
            RegistrationResultData resp = new RegistrationResultData();
            resp.suggestions = null;
            resp.status = LoginStatusType.InvalidChildUserName;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp)));
            return;
        }
        if (TextFilterService.getInstance().isFiltered(reg.name, true)) {
            RegistrationResultData resp = new RegistrationResultData();
            resp.suggestions = null;
            resp.status = LoginStatusType.InvalidChildUserName;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp)));
            return;
        }
        boolean inUse = false;
        if (!account.getUsername().equalsIgnoreCase(reg.name) && manager.isUsernameTaken(reg.name)) {
            inUse = true;
        } else if (Stream.of(account.getSaveIDs()).map(t -> account.getSave(t)).anyMatch(t -> {
            try {
                return t.getUsername().equalsIgnoreCase(reg.name) && t.getSaveData().entryExists("avatar");
            }
            catch (IOException e) {
                return false;
            }
        })) {
            inUse = true;
        }
        if (inUse) {
            RegistrationResultData resp = new RegistrationResultData();
            resp.suggestions = null;
            resp.status = LoginStatusType.InvalidChildUserName;
            resp.suggestions = new RegistrationResultData.SuggestionResultBlock();
            Random rnd = new Random();
            ArrayList<CallSite> suggestions = new ArrayList<CallSite>();
            for (int i = 1000; i < 9999 && suggestions.size() != 6; ++i) {
                if (manager.isUsernameTaken(reg.name + rnd.nextInt(1000, 9999))) continue;
                suggestions.add((CallSite)((Object)(reg.name + rnd.nextInt(1000, 9999))));
            }
            resp.suggestions.suggestions = (String[])suggestions.toArray(String[]::new);
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp)));
            return;
        }
        AccountSaveContainer save = account.createSave(reg.name);
        if (save == null) {
            RegistrationResultData resp = new RegistrationResultData();
            resp.suggestions = null;
            resp.status = LoginStatusType.InvalidChildUserName;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp)));
            return;
        }
        RegistrationResultData resp = new RegistrationResultData();
        resp.userID = save.getSaveID();
        resp.status = LoginStatusType.Success;
        this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("RegistrationResult", (Object)resp)));
    }
}

