/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.http.handlers.api.accounts;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.stream.Stream;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.commonapi.EdgeCommonApiServer;
import org.asf.edge.commonapi.xmls.ProductRuleData;
import org.asf.edge.commonapi.xmls.auth.CommonLoginInfo;
import org.asf.edge.commonapi.xmls.auth.GuestLoginData;
import org.asf.edge.commonapi.xmls.auth.LoginStatusType;
import org.asf.edge.commonapi.xmls.auth.ParentLoginData;
import org.asf.edge.commonapi.xmls.auth.ParentLoginResponseData;

public class AuthenticationWebServiceV3Processor
extends EdgeWebService<EdgeCommonApiServer> {
    private static AccountManager manager;
    private static HashMap<String, Integer> usernameLock;

    public AuthenticationWebServiceV3Processor(EdgeCommonApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new AuthenticationWebServiceV3Processor((EdgeCommonApiServer)this.getServerInstance());
    }

    public String path() {
        return "/v3/AuthenticationWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        this.setResponseStatus(404, "Not found");
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getRules(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        ProductRuleData data = new ProductRuleData();
        data.globalKey = "Edge does not use the hash validation system as its overly complex and TLS is more than enough";
        data.productRules = new ProductRuleData.ProductRulesBlock();
        data.productRules.sslRules = new ProductRuleData.ProductRulesBlock.RuleBlock[0];
        data.productRules.responseHashValidationRules = new ProductRuleData.ProductRulesBlock.RuleBlock[0];
        String xml = req.generateXmlValue("getProductRulesResponse", (Object)data);
        String encrypted = req.generateEncryptedResponse(xml);
        this.setResponseContent("text/xml", encrypted);
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void authenticateUser(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String password = req.getEncryptedValue("password");
        String username = req.getEncryptedValue("username");
        String id = manager.getAccountID(username);
        if (id == null) {
            this.setResponseContent(req.generateXmlValue("boolean", (Object)false));
            return;
        }
        if (!manager.verifyPassword(id, password)) {
            this.setResponseContent(req.generateXmlValue("boolean", (Object)false));
            return;
        }
        this.setResponseContent(req.generateXmlValue("boolean", (Object)true));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void loginGuest(LegacyFunctionInfo func) throws IOException {
        AccountObject guestAcc;
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String guestLoginData = req.getEncryptedValue("guestLoginData");
        GuestLoginData login = (GuestLoginData)req.parseXmlValue(guestLoginData, GuestLoginData.class);
        login.username = req.decryptString(login.username);
        if (login.username.length() != 72 || !login.username.matches("^[A-Za-z0-9\\-]+")) {
            ParentLoginResponseData resp = new ParentLoginResponseData();
            resp.status = LoginStatusType.GuestAccountNotFound;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("ParentLoginInfo", (Object)resp)));
            return;
        }
        if (manager.getGuestAccount(login.username) == null) {
            if (login.userPolicy == null || !login.userPolicy.termsAndConditions || !login.userPolicy.privacyPolicy) {
                ParentLoginResponseData resp = new ParentLoginResponseData();
                resp.userID = "00000000-0000-0000-0000-000000000000";
                resp.status = LoginStatusType.UserPolicyNotAccepted;
                this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("ParentLoginInfo", (Object)resp)));
                return;
            }
            guestAcc = manager.registerGuestAccount(login.username);
            if (guestAcc != null) {
                guestAcc.createSave("guest_" + System.currentTimeMillis());
            }
        } else {
            guestAcc = manager.getGuestAccount(login.username);
        }
        if (guestAcc == null) {
            ParentLoginResponseData resp = new ParentLoginResponseData();
            resp.status = LoginStatusType.GuestAccountNotFound;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("ParentLoginInfo", (Object)resp)));
            return;
        }
        if (!guestAcc.isGuestAccount()) {
            ParentLoginResponseData resp = new ParentLoginResponseData();
            resp.status = LoginStatusType.GuestAccountNotFound;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("ParentLoginInfo", (Object)resp)));
            return;
        }
        guestAcc.updateLastLoginTime();
        SessionToken tkn = new SessionToken();
        tkn.accountID = guestAcc.getAccountID();
        tkn.lastLoginTime = guestAcc.getLastLoginTime();
        tkn.capabilities = new String[]{"api"};
        ParentLoginResponseData resp = new ParentLoginResponseData();
        resp.status = LoginStatusType.Success;
        resp.username = guestAcc.getUsername();
        resp.apiToken = this.getUtilities().encodeToken(tkn.toTokenString());
        resp.email = guestAcc.getAccountEmail();
        resp.sendActivationReminder = false;
        resp.childList = (CommonLoginInfo[])Stream.of(guestAcc.getSaveIDs()).map(t -> guestAcc.getSave(t)).map(t -> {
            CommonLoginInfo ch = new CommonLoginInfo();
            ch.userID = t.getSaveID();
            ch.username = t.getUsername();
            return ch;
        }).toArray(CommonLoginInfo[]::new);
        guestAcc.ping(true);
        this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("ParentLoginInfo", (Object)resp)));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void loginParent(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String parentLoginData = req.getEncryptedValue("parentLoginData");
        ParentLoginData login = (ParentLoginData)req.parseXmlValue(parentLoginData, ParentLoginData.class);
        if (!manager.isValidUsername(login.username)) {
            this.invalidUserCallback(login.username, null, req);
            return;
        }
        if (!manager.isUsernameTaken(login.username)) {
            ((EdgeCommonApiServer)this.getServerInstance()).getLogger().warn("Account login from IP " + func.getClient().getRemoteAddress() + " rejected for " + login.username + ": account not found");
            this.invalidUserCallback(login.username, null, req);
            return;
        }
        String id = manager.getAccountID(login.username);
        if (!manager.accountExists(id)) {
            ((EdgeCommonApiServer)this.getServerInstance()).getLogger().warn("Account login from IP " + func.getClient().getRemoteAddress() + " rejected for " + login.username + ": account not found");
            this.invalidUserCallback(login.username, null, req);
            return;
        }
        AccountObject acc = manager.getAccount(id);
        if (acc.isGuestAccount()) {
            ((EdgeCommonApiServer)this.getServerInstance()).getLogger().warn("Account login from IP " + func.getClient().getRemoteAddress() + " rejected for " + acc.getAccountID() + ": guest accounts may not be directly logged in on");
            this.invalidUserCallback(login.username, acc, req);
            return;
        }
        JsonElement lock = acc.getAccountData().getChildContainer("accountdata").getEntry("lockedsince");
        if (lock != null && System.currentTimeMillis() - lock.getAsLong() < 8000L) {
            ((EdgeCommonApiServer)this.getServerInstance()).getLogger().warn("Account login from IP " + func.getClient().getRemoteAddress() + " rejected for " + acc.getAccountID() + ": login rejected by antibruteforce");
            ParentLoginResponseData resp = new ParentLoginResponseData();
            resp.status = LoginStatusType.InvalidUserName;
            this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("ParentLoginInfo", (Object)resp)));
            try {
                Thread.sleep(8000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        if (!manager.verifyPassword(id, login.password)) {
            ((EdgeCommonApiServer)this.getServerInstance()).getLogger().warn("Account login from IP " + func.getClient().getRemoteAddress() + " rejected for " + id + ": invalid password");
            this.invalidUserCallback(login.username, acc, req);
            return;
        }
        acc.updateLastLoginTime();
        SessionToken tkn = new SessionToken();
        tkn.accountID = acc.getAccountID();
        tkn.lastLoginTime = acc.getLastLoginTime();
        tkn.capabilities = new String[]{"api"};
        ((EdgeCommonApiServer)this.getServerInstance()).getLogger().info("Account login from IP " + func.getClient().getRemoteAddress() + " to " + acc.getAccountID() + ": logged in as " + acc.getUsername());
        ParentLoginResponseData resp = new ParentLoginResponseData();
        resp.status = LoginStatusType.Success;
        resp.username = acc.getUsername();
        resp.apiToken = this.getUtilities().encodeToken(tkn.toTokenString());
        resp.email = acc.getAccountEmail();
        resp.sendActivationReminder = false;
        resp.childList = (CommonLoginInfo[])Stream.of(acc.getSaveIDs()).map(t -> acc.getSave(t)).map(t -> {
            CommonLoginInfo ch = new CommonLoginInfo();
            ch.userID = t.getSaveID();
            ch.username = t.getUsername();
            return ch;
        }).toArray(CommonLoginInfo[]::new);
        acc.ping(true);
        this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("ParentLoginInfo", (Object)resp)));
    }

    private void invalidUserCallback(String username, AccountObject account, EdgeWebService.ServiceRequestInfo req) throws IOException {
        ParentLoginResponseData resp = new ParentLoginResponseData();
        resp.status = LoginStatusType.InvalidUserName;
        this.setResponseContent("text/xml", req.generateEncryptedResponse(req.generateXmlValue("ParentLoginInfo", (Object)resp)));
        if (account != null) {
            account.getAccountData().getChildContainer("accountdata").setEntry("lockedsince", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
        }
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        usernameLock = new HashMap();
        Thread th = new Thread(() -> {
            while (true) {
                HashMap<String, Integer> passswordLock;
                try {
                    passswordLock = new HashMap<String, Integer>(usernameLock);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                for (String pwd : passswordLock.keySet()) {
                    if (passswordLock.get(pwd) - 1 <= 0) {
                        usernameLock.remove(pwd);
                        continue;
                    }
                    usernameLock.put(pwd, passswordLock.get(pwd) - 1);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        th.setDaemon(true);
        th.start();
    }
}

