/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.CommonUpdater;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.commonapi.EdgeCommonApiServer;
import org.asf.edge.commonapi.config.CommonApiServerConfig;
import org.asf.edge.commonapi.events.config.CommonApiServerConfigLoadedEvent;
import org.asf.edge.commonapi.events.config.CommonApiServerConfigPresetupEvent;
import org.asf.edge.modules.ModuleManager;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class EdgeCommonApiServerMain {
    public static void main(String[] args) throws IOException, URISyntaxException {
        Locale.setDefault(Locale.ENGLISH);
        EdgeCommonApiServer.printSplash();
        CommonInit.initAll();
        CommonUpdater.init((String)"commonapi", (String)"stable", (String)"1.0.0.A1", (File)new File(EdgeCommonApiServerMain.class.getProtectionDomain().getCodeSource().getLocation().toURI()));
        Logger logger = LogManager.getLogger((String)"COMMONAPI");
        logger.info("Preparing to start...");
        ModuleManager.init();
        CommonApiServerConfig config = new CommonApiServerConfig();
        EventBus.getInstance().dispatchEvent((EventObject)new CommonApiServerConfigPresetupEvent(config));
        logger.info("Loading server configuration...");
        File configFile = new File("server.json");
        if (!configFile.exists()) {
            logger.debug("Creating server configuration...");
            Files.writeString(configFile.toPath(), (CharSequence)"{\n\n    \"listenAddress\": \"0.0.0.0\",\n    \"listenPort\": 5321,\n    \"apiRequestListenPath\": \"/\",\n\n    \"https\": false,\n    \"tlsKeystore\": null,\n    \"tlsKeystorePassword\": null,\n\n    \"internalListenAddress\": \"0.0.0.0\",\n    \"internalListenPort\": 5324,\n\n    \"httpsInternal\": false,\n    \"tlsKeystoreInternal\": null,\n    \"tlsKeystorePasswordInternal\": null,\n\n    \"modules\": {\n    }\n\n}", new OpenOption[0]);
        }
        logger.debug("Loading configuration file server.json...");
        JsonObject configData = JsonParser.parseString((String)Files.readString(configFile.toPath())).getAsJsonObject();
        if (config.server == null) {
            logger.debug("Loading listening settings...");
            config.listenAddress = configData.get("listenAddress").getAsString();
            config.listenPort = configData.get("listenPort").getAsInt();
        }
        logger.debug("Loading IO settings...");
        config.apiRequestListenPath = configData.get("apiRequestListenPath").getAsString();
        if (config.server == null) {
            logger.debug("Loading encryption settings...");
            config.https = configData.get("https").getAsBoolean();
            if (config.https) {
                config.tlsKeystore = configData.get("tlsKeystore").getAsString();
                config.tlsKeystorePassword = configData.get("tlsKeystorePassword").getAsString();
            }
        }
        logger.debug("Loading internal server settings...");
        if (config.internalServer == null) {
            logger.debug("Loading listening settings...");
            config.internalListenAddress = configData.get("internalListenAddress").getAsString();
            config.internalListenPort = configData.get("internalListenPort").getAsInt();
        }
        if (config.internalServer == null) {
            logger.debug("Loading encryption settings...");
            config.httpsInternal = configData.get("httpsInternal").getAsBoolean();
            if (config.httpsInternal) {
                config.tlsKeystoreInternal = configData.get("tlsKeystoreInternal").getAsString();
                config.tlsKeystorePasswordInternal = configData.get("tlsKeystorePasswordInternal").getAsString();
            }
        }
        if (configData.has("modules")) {
            logger.debug("Loading module configurations...");
            JsonObject moduleSettings = configData.get("modules").getAsJsonObject();
            for (String id : moduleSettings.keySet()) {
                JsonObject conf = moduleSettings.get(id).getAsJsonObject();
                LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
                for (String key : conf.keySet()) {
                    mp.put(key, conf.get(key).getAsString());
                }
                ModuleManager.loadedModuleConfig((String)id, mp);
            }
        }
        EventBus.getInstance().dispatchEvent((EventObject)new CommonApiServerConfigLoadedEvent(config));
        logger.debug("Loading common data manager implementations...");
        CommonDataManager.initCommonDataManagerServices((int)-10, (int)0, (int)-5);
        logger.debug("Selecting common data manager implementation...");
        ServiceManager.selectServiceImplementation(CommonDataManager.class);
        logger.debug("Loading common data manager...");
        CommonDataManager.getInstance().loadManager();
        logger.info("Setting up the server...");
        logger.debug("Loading account manager implementations...");
        AccountManager.initAccountManagerServices((int)-10, (int)0, (int)-5);
        logger.debug("Selecting account manager implementation...");
        ServiceManager.selectServiceImplementation(AccountManager.class);
        logger.debug("Loading account manager...");
        AccountManager.getInstance().loadManager();
        EdgeCommonApiServer server = new EdgeCommonApiServer(config);
        server.setupServer();
        server.startServer();
        ModuleManager.runModulePostInit();
        logger.info("Server is running!");
        server.waitForExit();
        if (CommonInit.restartPending) {
            System.exit(237);
        } else {
            System.exit(0);
        }
    }
}

