/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public class HttpUpgradeUtil {
    public static Socket upgradeRequest(String url, String method, InputStream body, long length, Map<String, String> requestHeaders, Map<String, String> responseHeadersOutput, String upgradeProtocol, String expectedResponseProtocol) throws IOException {
        String line;
        Socket conn;
        URL u = new URL(url);
        if (!u.getProtocol().equals("http") && !u.getProtocol().equals("https")) {
            throw new IOException("Unsupported protocol for protocol Upgrade to binary communication: " + u.getProtocol());
        }
        Socket socket = conn = u.getProtocol().equals("http") ? new Socket(u.getHost(), u.getPort()) : SSLSocketFactory.getDefault().createSocket(u.getHost(), u.getPort());
        if (body != null && length != -1L) {
            requestHeaders = new HashMap<String, String>(requestHeaders);
            requestHeaders.put("Content-Length", Long.toString(length));
        }
        conn.getOutputStream().write(("POST " + URLEncoder.encode(u.getFile(), "UTF-8") + " HTTP/1.1\r\n").getBytes("UTF-8"));
        conn.getOutputStream().write(("Host: " + u.getHost() + "\r\n").getBytes("UTF-8"));
        for (String key : requestHeaders.keySet()) {
            String value = requestHeaders.get(key);
            conn.getOutputStream().write((key + ": " + value + "\r\n").getBytes("UTF-8"));
        }
        conn.getOutputStream().write(("Upgrade: " + upgradeProtocol + "\r\n").getBytes("UTF-8"));
        conn.getOutputStream().write("\r\n".getBytes("UTF-8"));
        if (body != null && length != -1L) {
            int tr = 0;
            for (long i = 0L; i < length; i += (long)tr) {
                tr = 2147483;
                if (length - i < (long)tr) {
                    tr = body.available();
                    if (tr == 0) {
                        conn.getOutputStream().write(body.read());
                        ++i;
                    }
                    tr = body.available();
                }
                conn.getOutputStream().write(body.readNBytes(tr));
            }
        }
        String statusLine = line = HttpUpgradeUtil.readStreamLine(conn.getInputStream());
        if (!line.startsWith("HTTP/1.1 ")) {
            conn.close();
            throw new IOException("Server returned invalid protocol");
        }
        while (!(line = HttpUpgradeUtil.readStreamLine(conn.getInputStream())).equals("")) {
            String key = line.substring(0, line.indexOf(": "));
            String value = line.substring(line.indexOf(": ") + 2);
            responseHeadersOutput.put(key, value);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        HttpUpgradeUtil.transferRequestBody(responseHeadersOutput, conn.getInputStream(), buffer);
        int status = Integer.parseInt(statusLine.split(" ")[1]);
        if (status != 101) {
            conn.close();
            throw new IOException("Server returned HTTP " + line.substring("HTTP/1.1 ".length()));
        }
        if (!responseHeadersOutput.containsKey("Upgrade") && !responseHeadersOutput.containsKey("upgrade")) {
            conn.close();
            throw new IOException("Server response did not contain a Upgrage header.");
        }
        if (responseHeadersOutput.containsKey("Upgrade") && !responseHeadersOutput.get("Upgrade").equals(expectedResponseProtocol)) {
            conn.close();
            throw new IOException("Server response used an invalid protocol: " + responseHeadersOutput.get("Upgrade") + ".");
        }
        if (responseHeadersOutput.containsKey("upgrade") && !responseHeadersOutput.get("upgrade").equals(expectedResponseProtocol)) {
            conn.close();
            throw new IOException("Server response used an invalid protocol: " + responseHeadersOutput.get("upgrade") + ".");
        }
        return conn;
    }

    private static String readStreamLine(InputStream strm) throws IOException {
        Object buffer = "";
        char ch;
        while ((ch = (char)strm.read()) != '\uffff') {
            if (ch == '\n') {
                return buffer;
            }
            if (ch == '\r') continue;
            buffer = (String)buffer + ch;
        }
        return null;
    }

    private static void transferRequestBody(Map<String, String> headers, InputStream bodyStream, OutputStream output) throws IOException {
        if (headers.containsKey("Content-Length")) {
            long length = Long.valueOf(headers.get("Content-Length"));
            int tr = 0;
            for (long i = 0L; i < length; i += (long)tr) {
                tr = 2147483;
                if (length - i < (long)tr) {
                    tr = bodyStream.available();
                    if (tr == 0) {
                        output.write(bodyStream.read());
                        ++i;
                    }
                    tr = bodyStream.available();
                }
                output.write(bodyStream.readNBytes(tr));
            }
        }
    }
}

