/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.mmoserver;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.CommonUpdater;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.mmoserver.EdgeMMOServer;
import org.asf.edge.mmoserver.config.MMOServerConfig;
import org.asf.edge.mmoserver.events.config.MMOServerConfigLoadedEvent;
import org.asf.edge.mmoserver.events.config.MMOServerConfigPresetupEvent;
import org.asf.edge.modules.ModuleManager;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class EdgeMMOServerMain {
    public static void main(String[] args) throws IOException, URISyntaxException {
        Locale.setDefault(Locale.ENGLISH);
        EdgeMMOServer.printSplash();
        CommonInit.initAll();
        CommonUpdater.init((String)"mmoserver", (String)"stable", (String)"1.0.0.A2", (File)new File(EdgeMMOServerMain.class.getProtectionDomain().getCodeSource().getLocation().toURI()));
        Logger logger = LogManager.getLogger((String)"MMOSERVER");
        logger.info("Preparing to start...");
        ModuleManager.init();
        MMOServerConfig config = new MMOServerConfig();
        EventBus.getInstance().dispatchEvent((EventObject)new MMOServerConfigPresetupEvent(config));
        logger.info("Loading server configuration...");
        File configFile = new File("server.json");
        if (!configFile.exists()) {
            logger.debug("Creating server configuration...");
            Files.writeString(configFile.toPath(), (CharSequence)"{\n\n    \"listenAddress\": \"0.0.0.0\",\n    \"listenPort\": 5323,\n\n    \"discoveryAddress\": \"localhost\",\n    \"discoveryPort\": 5323,\n\n    \"commonApiUplinkURL\": \"http://127.0.0.1:5324/\",\n\n\n    \"modules\": {\n    }\n\n}", new OpenOption[0]);
        }
        logger.debug("Loading configuration file server.json...");
        JsonObject configData = JsonParser.parseString((String)Files.readString(configFile.toPath())).getAsJsonObject();
        logger.debug("Loading listening settings...");
        config.listenAddress = configData.get("listenAddress").getAsString();
        config.listenPort = configData.get("listenPort").getAsInt();
        logger.debug("Loading discovery settings...");
        config.discoveryAddress = configData.get("discoveryAddress").getAsString();
        config.discoveryPort = configData.get("discoveryPort").getAsInt();
        config.commonApiUplinkURL = configData.get("commonApiUplinkURL").getAsString();
        if (configData.has("modules")) {
            logger.debug("Loading module configurations...");
            JsonObject moduleSettings = configData.get("modules").getAsJsonObject();
            for (String id : moduleSettings.keySet()) {
                JsonObject conf = moduleSettings.get(id).getAsJsonObject();
                LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
                for (String key : conf.keySet()) {
                    mp.put(key, conf.get(key).getAsString());
                }
                ModuleManager.loadedModuleConfig((String)id, mp);
            }
        }
        EventBus.getInstance().dispatchEvent((EventObject)new MMOServerConfigLoadedEvent(config));
        logger.info("Setting up the server...");
        logger.debug("Loading account manager implementations...");
        AccountManager.initAccountManagerServices((int)0, (int)-10, (int)-5);
        logger.debug("Selecting account manager implementation...");
        ServiceManager.selectServiceImplementation(AccountManager.class);
        logger.debug("Loading account manager...");
        AccountManager.getInstance().loadManager();
        logger.debug("Loading common data manager implementations...");
        CommonDataManager.initCommonDataManagerServices((int)0, (int)-10, (int)-5);
        logger.debug("Selecting common data manager implementation...");
        ServiceManager.selectServiceImplementation(CommonDataManager.class);
        logger.debug("Loading common data manager...");
        CommonDataManager.getInstance().loadManager();
        EdgeMMOServer server = new EdgeMMOServer(config);
        server.setupServer();
        server.startServer();
        ModuleManager.runModulePostInit();
        logger.info("Server is running!");
        server.waitForExit();
        if (CommonInit.restartPending) {
            System.exit(237);
        } else {
            System.exit(0);
        }
    }
}

