/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.util.inventory.defaultvalidators;

import com.fasterxml.jackson.databind.JsonNode;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.entities.items.PlayerInventoryContainer;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.gameplayapi.util.inventory.AbstractInventorySecurityValidator;
import org.asf.edge.gameplayapi.xmls.inventories.SetCommonInventoryRequestData;

public class MysteryBoxSecurityValidator
extends AbstractInventorySecurityValidator {
    @Override
    public boolean isValidRequest(SetCommonInventoryRequestData request, AccountDataContainer data, PlayerInventory inventory, PlayerInventoryContainer inventoryContainer, PlayerInventoryItem item) {
        int defID = request.itemID;
        ItemInfo def = ItemManager.getInstance().getItemDefinition(defID);
        if (def == null) {
            return false;
        }
        if (request.quantity < 0) {
            return true;
        }
        return !MysteryBoxSecurityValidator.isMysteryBox(def);
    }

    private static boolean isMysteryBox(ItemInfo def) {
        if (!def.getRawObject().has("r")) {
            return false;
        }
        JsonNode node = def.getRawObject().get("r");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!MysteryBoxSecurityValidator.isMysteryItem(n)) continue;
                return true;
            }
            return false;
        }
        return MysteryBoxSecurityValidator.isMysteryItem(node);
    }

    private static boolean isMysteryItem(JsonNode node) {
        if (node.has("t")) {
            return node.get("t").asText().equalsIgnoreCase("Prize");
        }
        return false;
    }
}

