/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.entities.items.ItemStoreInfo;
import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.entities.items.PlayerInventoryContainer;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.util.RandomSelectorUtil;
import org.asf.edge.gameplayapi.events.items.InventoryUtilsLoadEvent;
import org.asf.edge.gameplayapi.util.inventory.AbstractInventorySecurityValidator;
import org.asf.edge.gameplayapi.util.inventory.AbstractItemRedemptionHandler;
import org.asf.edge.gameplayapi.util.inventory.ItemRedemptionInfo;
import org.asf.edge.gameplayapi.util.inventory.defaulthandlers.CoinItemRedemptionHandler;
import org.asf.edge.gameplayapi.util.inventory.defaulthandlers.DefaultItemRedemptionHandler;
import org.asf.edge.gameplayapi.util.inventory.defaulthandlers.GemItemRedemptionHandler;
import org.asf.edge.gameplayapi.util.inventory.defaulthandlers.ProfileSlotItemRedemptionHandler;
import org.asf.edge.gameplayapi.util.inventory.defaultvalidators.AttributeSecurityValidator;
import org.asf.edge.gameplayapi.util.inventory.defaultvalidators.BundleSecurityValidator;
import org.asf.edge.gameplayapi.util.inventory.defaultvalidators.MysteryBoxSecurityValidator;
import org.asf.edge.gameplayapi.xmls.inventories.InventoryUpdateResponseData;
import org.asf.edge.gameplayapi.xmls.inventories.SetCommonInventoryRequestData;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class InventoryUtils {
    private static ArrayList<AbstractItemRedemptionHandler> handlers = new ArrayList();
    private static ArrayList<AbstractInventorySecurityValidator> securityValidators = new ArrayList();
    private static ItemManager itemManager;
    private static boolean inited;

    public static void init() {
        if (inited) {
            return;
        }
        inited = true;
        EventBus.getInstance().dispatchEvent((EventObject)new InventoryUtilsLoadEvent());
    }

    public static void registerItemRedemptionHandler(AbstractItemRedemptionHandler handler) {
        handlers.add(0, handler);
    }

    public static void registerInventorySecurityValidator(AbstractInventorySecurityValidator validator) {
        securityValidators.add(validator);
    }

    public static InventoryUpdateResponseData redeemItems(ItemRedemptionInfo[] items, AccountObject account, AccountSaveContainer save, boolean openMysteryBoxes) throws IOException {
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        InventoryUpdateResponseData resp = new InventoryUpdateResponseData();
        ArrayList<InventoryUpdateResponseData.ItemUpdateBlock> itemLst = new ArrayList<InventoryUpdateResponseData.ItemUpdateBlock>();
        ArrayList<InventoryUpdateResponseData.PrizeItemInfo> prizeLst = new ArrayList<InventoryUpdateResponseData.PrizeItemInfo>();
        InventoryUpdateResponseData.CurrencyUpdateBlock currencyUpdate = new InventoryUpdateResponseData.CurrencyUpdateBlock();
        currencyUpdate.userID = save.getSaveID();
        resp.success = true;
        AccountDataContainer currency = save.getSaveData().getChildContainer("currency");
        int currentC = 300;
        if (currency.entryExists("coins")) {
            currentC = currency.getEntry("coins").getAsInt();
        }
        AccountDataContainer currencyAccWide = save.getAccount().getAccountData().getChildContainer("currency");
        int currentG = 0;
        if (currencyAccWide.entryExists("gems")) {
            currentG = currencyAccWide.getEntry("gems").getAsInt();
        }
        currencyUpdate.coinCount = currentC;
        currencyUpdate.gemCount = currentG;
        resp.success = InventoryUtils.processItemRedemption(items, account, save, openMysteryBoxes, itemLst, prizeLst, currencyUpdate, null, null, null, null);
        if (currencyUpdate.gemCount != currentG) {
            resp.currencyUpdate = currencyUpdate;
            currencyAccWide.setEntry("gems", (JsonElement)new JsonPrimitive((Number)currencyUpdate.gemCount));
        }
        if (currencyUpdate.coinCount != currentC) {
            resp.currencyUpdate = currencyUpdate;
            currency.setEntry("coins", (JsonElement)new JsonPrimitive((Number)currencyUpdate.coinCount));
        }
        resp.prizeItems = (InventoryUpdateResponseData.PrizeItemInfo[])prizeLst.toArray(InventoryUpdateResponseData.PrizeItemInfo[]::new);
        resp.updateItems = (InventoryUpdateResponseData.ItemUpdateBlock[])itemLst.toArray(InventoryUpdateResponseData.ItemUpdateBlock[]::new);
        if (resp.prizeItems.length == 0) {
            resp.prizeItems = null;
        }
        if (resp.updateItems.length == 0) {
            resp.updateItems = null;
        }
        return resp;
    }

    private static boolean processItemRedemption(ItemRedemptionInfo[] items, AccountObject account, AccountSaveContainer save, boolean openMysteryBoxes, ArrayList<InventoryUpdateResponseData.ItemUpdateBlock> itemLst, ArrayList<InventoryUpdateResponseData.PrizeItemInfo> prizeLst, InventoryUpdateResponseData.CurrencyUpdateBlock currencyUpdate, InventoryUpdateResponseData.PrizeItemInfo prizeInfo, BiFunction<ItemInfo, Integer, Boolean> itemRedemptionValidationCall, BiFunction<ItemInfo, Integer, Boolean> itemRedemptionCall, Consumer<ItemInfo> innerItemRedemptionCall) {
        ItemInfo itm;
        for (ItemRedemptionInfo req : items) {
            itm = itemManager.getItemDefinition(req.defID);
            if (itm == null) {
                return false;
            }
            if (itemRedemptionValidationCall == null || itemRedemptionValidationCall.apply(itm, req.quantity).booleanValue()) continue;
            return false;
        }
        if (openMysteryBoxes) {
            for (ItemRedemptionInfo req : items) {
                itm = itemManager.getItemDefinition(req.defID);
                if (!InventoryUtils.isMysteryBox(itm)) continue;
                for (JsonNode nd : InventoryUtils.getRelationsOfType("Prize", itm)) {
                    if (!nd.has("id") || !nd.has("wt")) {
                        return false;
                    }
                    ItemInfo itm2 = itemManager.getItemDefinition(nd.get("id").asInt());
                    if (itm2 != null) continue;
                    return false;
                }
            }
        }
        for (ItemRedemptionInfo req : items) {
            itm = itemManager.getItemDefinition(req.defID);
            if (InventoryUtils.verifyBundle(itm)) continue;
            return false;
        }
        for (ItemRedemptionInfo req : items) {
            itm = itemManager.getItemDefinition(req.defID);
            if (InventoryUtils.isBundle(itm) || openMysteryBoxes && InventoryUtils.isMysteryBox(itm)) continue;
            if (itemRedemptionCall != null && !itemRedemptionCall.apply(itm, req.quantity).booleanValue()) {
                return false;
            }
            if (!InventoryUtils.addItem(itm, req, account, save, itemLst, prizeLst, currencyUpdate, prizeInfo)) {
                return false;
            }
            if (innerItemRedemptionCall == null) continue;
            innerItemRedemptionCall.accept(itm);
        }
        if (openMysteryBoxes) {
            for (ItemRedemptionInfo req : items) {
                itm = itemManager.getItemDefinition(req.defID);
                if (!InventoryUtils.isMysteryBox(itm)) continue;
                for (int l = 0; l < req.quantity; ++l) {
                    HashMap<ItemRedemptionInfo, Integer> prizes = new HashMap<ItemRedemptionInfo, Integer>();
                    for (JsonNode nd : InventoryUtils.getRelationsOfType("Prize", itm)) {
                        int weight = nd.get("wt").asInt();
                        int defID = nd.get("id").asInt();
                        int quantity = 1;
                        if (nd.has("q")) {
                            quantity = nd.get("q").asInt();
                        }
                        if (quantity == 0) {
                            quantity = 1;
                        }
                        ItemRedemptionInfo it = new ItemRedemptionInfo();
                        it.defID = defID;
                        it.quantity = quantity;
                        it.containerID = req.containerID;
                        prizes.put(it, weight);
                    }
                    ItemRedemptionInfo prize = (ItemRedemptionInfo)RandomSelectorUtil.selectWeighted(prizes);
                    if (prize == null) continue;
                    InventoryUpdateResponseData.PrizeItemInfo obj = new InventoryUpdateResponseData.PrizeItemInfo();
                    obj.boxItemID = itm.getID();
                    obj.prizeItemID = prize.defID;
                    obj.mysteryPrizeItems = new ObjectNode[0];
                    ItemInfo itm2 = itemManager.getItemDefinition(prize.defID);
                    if (InventoryUtils.isBundle(itm2) || InventoryUtils.isMysteryBox(itm2)) {
                        obj.mysteryPrizeItems = new ObjectNode[]{itm2.getRawObject()};
                    }
                    if (!InventoryUtils.processItemRedemption(new ItemRedemptionInfo[]{prize}, account, save, false, itemLst, prizeLst, currencyUpdate, obj, null, null, innerItemRedemptionCall)) {
                        return false;
                    }
                    prizeLst.add(obj);
                }
            }
        }
        for (ItemRedemptionInfo req : items) {
            itm = itemManager.getItemDefinition(req.defID);
            if (!InventoryUtils.isBundle(itm)) continue;
            for (JsonNode nd : InventoryUtils.getRelationsOfType("Bundle", itm)) {
                int defID = nd.get("id").asInt();
                int quantity = 1;
                if (nd.has("q")) {
                    quantity = nd.get("q").asInt();
                }
                if (quantity == 0) {
                    quantity = 1;
                }
                ItemRedemptionInfo it = new ItemRedemptionInfo();
                it.defID = defID;
                it.quantity = quantity * req.quantity;
                it.containerID = req.containerID;
                if (InventoryUtils.processItemRedemption(new ItemRedemptionInfo[]{it}, account, save, false, itemLst, prizeLst, currencyUpdate, null, null, null, innerItemRedemptionCall)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean addItem(ItemInfo itm, ItemRedemptionInfo req, AccountObject account, AccountSaveContainer save, ArrayList<InventoryUpdateResponseData.ItemUpdateBlock> itemLst, ArrayList<InventoryUpdateResponseData.PrizeItemInfo> prizeLst, InventoryUpdateResponseData.CurrencyUpdateBlock currencyUpdate, InventoryUpdateResponseData.PrizeItemInfo prizeInfo) {
        for (AbstractItemRedemptionHandler handler : handlers) {
            ObjectNode infoBlock;
            if (!handler.canHandle(itm)) continue;
            AbstractItemRedemptionHandler.RedemptionResult resp = handler.handleRedemption(itm, req, account, save, currencyUpdate);
            InventoryUpdateResponseData.ItemUpdateBlock block = resp.getUpdate();
            if (block != null) {
                itemLst.add(block);
            }
            if ((infoBlock = resp.getItemDef()) != null && prizeInfo != null) {
                prizeInfo.mysteryPrizeItems = InventoryUtils.appendTo(prizeInfo.mysteryPrizeItems, infoBlock);
            }
            if (!resp.isSuccessful()) {
                return false;
            }
            if (handler.delegating()) continue;
            return true;
        }
        return false;
    }

    private static ObjectNode[] appendTo(ObjectNode[] arr, ObjectNode block) {
        ObjectNode[] newB = new ObjectNode[arr.length + 1];
        for (int i = 0; i < newB.length; ++i) {
            newB[i] = i >= arr.length ? block : arr[i];
        }
        return newB;
    }

    private static boolean verifyBundle(ItemInfo itm) {
        if (InventoryUtils.isBundle(itm)) {
            for (JsonNode nd : InventoryUtils.getRelationsOfType("Bundle", itm)) {
                if (!nd.has("id")) {
                    return false;
                }
                ItemInfo itm2 = itemManager.getItemDefinition(nd.get("id").asInt());
                if (itm2 == null) {
                    return false;
                }
                if (InventoryUtils.verifyBundle(itm2)) continue;
                return false;
            }
        }
        return true;
    }

    private static JsonNode[] getRelationsOfType(String type, ItemInfo itm) {
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
        JsonNode node = itm.getRawObject().get("r");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!n.has("t") || !n.get("t").asText().equalsIgnoreCase(type)) continue;
                nodes.add(n);
            }
        } else if (node.has("t") && node.get("t").asText().equalsIgnoreCase(type)) {
            nodes.add(node);
        }
        return (JsonNode[])nodes.toArray(JsonNode[]::new);
    }

    private static boolean isMysteryBox(ItemInfo def) {
        if (!def.getRawObject().has("r")) {
            return false;
        }
        JsonNode node = def.getRawObject().get("r");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!InventoryUtils.isMysteryItem(n)) continue;
                return true;
            }
            return false;
        }
        return InventoryUtils.isMysteryItem(node);
    }

    private static boolean isMysteryItem(JsonNode node) {
        if (node.has("t")) {
            return node.get("t").asText().equalsIgnoreCase("Prize");
        }
        return false;
    }

    private static boolean isBundle(ItemInfo def) {
        if (!def.getRawObject().has("r")) {
            return false;
        }
        JsonNode node = def.getRawObject().get("r");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!InventoryUtils.isBundleItem(n)) continue;
                return true;
            }
            return false;
        }
        return InventoryUtils.isBundleItem(node);
    }

    private static boolean isBundleItem(JsonNode node) {
        if (node.has("t")) {
            return node.get("t").asText().equalsIgnoreCase("Bundle");
        }
        return false;
    }

    public static InventoryUpdateResponseData processCommonInventorySet(SetCommonInventoryRequestData[] requests, AccountDataContainer data, int container) {
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        InventoryUpdateResponseData resp = new InventoryUpdateResponseData();
        ArrayList<InventoryUpdateResponseData.ItemUpdateBlock> updates = new ArrayList<InventoryUpdateResponseData.ItemUpdateBlock>();
        resp.success = true;
        if (requests.length == 0) {
            resp.success = false;
        } else {
            PlayerInventory inv = itemManager.getCommonInventory(data);
            PlayerInventoryContainer cont = inv.getContainer(container);
            for (SetCommonInventoryRequestData request : requests) {
                if (itemManager.getItemDefinition(request.itemID) != null) continue;
                LogManager.getLogger((String)"ItemManager").warn("Warning! Security checks did not pass for common inventory request of user '" + data.getAccount().getUsername() + "', failed item ID: " + request.itemID + " (quantity: " + request.quantity + "), item was NOT added to inventory. (invalid item ID in request)");
                resp = new InventoryUpdateResponseData();
                resp.success = false;
                return resp;
            }
            for (SetCommonInventoryRequestData request : requests) {
                if (itemManager.getItemDefinition(request.itemID) == null) {
                    resp = new InventoryUpdateResponseData();
                    resp.success = false;
                    return resp;
                }
                PlayerInventoryItem itm = null;
                if (request.itemUniqueID != -1) {
                    itm = cont.getItem(request.itemUniqueID);
                }
                if (itm == null) {
                    itm = cont.findFirst(request.itemID);
                }
                boolean invalid = false;
                for (AbstractInventorySecurityValidator validator : securityValidators) {
                    if (validator.isValidRequest(request, data, inv, cont, itm)) continue;
                    invalid = true;
                    LogManager.getLogger((String)"ItemManager").warn("Warning! Security checks did not pass for common inventory request of user '" + data.getAccount().getUsername() + "', failed item ID: " + request.itemID + " (quantity: " + request.quantity + "), item was NOT added to inventory. (failed validator: " + validator.getClass().getSimpleName() + ")");
                    break;
                }
                if (invalid) continue;
                int newQuant = request.quantity;
                if (itm != null || request.quantity > 0) {
                    if (itm == null) {
                        itm = cont.createItem(request.itemID, 0);
                    }
                    newQuant = itm.getQuantity() + request.quantity;
                    itm.setQuantity(newQuant);
                    if (request.uses != null) {
                        int uses = 0;
                        if (itm.getUses() != -1) {
                            uses = itm.getUses();
                        }
                        itm.setUses(uses + Integer.parseInt(request.uses));
                    }
                }
                if (newQuant <= 0 && request.quantity != 0) continue;
                InventoryUpdateResponseData.ItemUpdateBlock b = new InventoryUpdateResponseData.ItemUpdateBlock();
                b.itemID = itm.getItemDefID();
                b.itemUniqueID = itm.getUniqueID();
                b.addedQuantity = request.quantity;
                updates.add(b);
            }
        }
        resp.updateItems = (InventoryUpdateResponseData.ItemUpdateBlock[])updates.toArray(InventoryUpdateResponseData.ItemUpdateBlock[]::new);
        return resp;
    }

    public static InventoryUpdateResponseData purchaseItems(int shopID, ItemRedemptionInfo[] items, AccountObject account, AccountSaveContainer save, boolean openMysteryBoxes) throws IOException {
        ItemStoreInfo store;
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((store = ItemManager.getInstance().getStore(shopID)) != null) {
            InventoryUpdateResponseData fail;
            InventoryUpdateResponseData.CurrencyUpdateBlock currencyUpdate = new InventoryUpdateResponseData.CurrencyUpdateBlock();
            currencyUpdate.userID = save.getSaveID();
            AccountDataContainer currency = save.getSaveData().getChildContainer("currency");
            int currentC = 300;
            if (currency.entryExists("coins")) {
                currentC = currency.getEntry("coins").getAsInt();
            }
            AccountDataContainer currencyAccWide = save.getAccount().getAccountData().getChildContainer("currency");
            int currentG = 0;
            if (currencyAccWide.entryExists("gems")) {
                currentG = currencyAccWide.getEntry("gems").getAsInt();
            }
            currencyUpdate.coinCount = currentC;
            currencyUpdate.gemCount = currentG;
            int costGemsTotal = 0;
            int costCoinsTotal = 0;
            for (ItemRedemptionInfo itm : items) {
                InventoryUpdateResponseData fail2;
                if (store.getItem(itm.defID) == null) {
                    fail2 = new InventoryUpdateResponseData();
                    fail2.success = false;
                    return fail2;
                }
                if (itm.quantity < 0) {
                    fail2 = new InventoryUpdateResponseData();
                    fail2.success = false;
                    return fail2;
                }
                ItemInfo.CostInfo cost = store.getItem(itm.defID).getFinalCost(false);
                if (cost.isFree) continue;
                if (cost.isGems) {
                    costGemsTotal += cost.cost * itm.quantity;
                    continue;
                }
                if (!cost.isCoins) continue;
                costCoinsTotal += cost.cost * itm.quantity;
            }
            if (costGemsTotal > currencyUpdate.gemCount) {
                fail = new InventoryUpdateResponseData();
                fail.success = false;
                return fail;
            }
            if (costCoinsTotal > currencyUpdate.coinCount) {
                fail = new InventoryUpdateResponseData();
                fail.success = false;
                return fail;
            }
            InventoryUpdateResponseData resp = new InventoryUpdateResponseData();
            ArrayList<InventoryUpdateResponseData.ItemUpdateBlock> itemLst = new ArrayList<InventoryUpdateResponseData.ItemUpdateBlock>();
            ArrayList<InventoryUpdateResponseData.PrizeItemInfo> prizeLst = new ArrayList<InventoryUpdateResponseData.PrizeItemInfo>();
            resp.success = InventoryUtils.processItemRedemption(items, account, save, openMysteryBoxes, itemLst, prizeLst, currencyUpdate, null, (item, quant) -> {
                item = store.getItem(item.getID());
                ItemInfo.CostInfo cost = item.getFinalCost(false);
                if (!cost.isFree && (cost.isGems ? cost.cost * quant > currencyUpdate.gemCount : cost.isCoins && cost.cost * quant > currencyUpdate.coinCount)) {
                    return false;
                }
                return true;
            }, (item, quant) -> {
                item = store.getItem(item.getID());
                ItemInfo.CostInfo cost = item.getFinalCost(false);
                if (cost.isFree) return true;
                if (cost.isGems) {
                    if (cost.cost * quant > currencyUpdate.gemCount) return false;
                    currencyUpdate.gemCount -= cost.cost * quant;
                } else if (cost.isCoins) {
                    if (cost.cost * quant > currencyUpdate.coinCount) return false;
                    currencyUpdate.coinCount -= cost.cost * quant;
                }
                try {
                    CommonDataContainer contPopularItems = CommonDataManager.getInstance().getContainer("POPULARITEMS");
                    JsonObject popularItems = new JsonObject();
                    if (contPopularItems.entryExists("current-" + store.getID())) {
                        popularItems = contPopularItems.getEntry("current-" + store.getID()).getAsJsonObject();
                    }
                    int last = 0;
                    if (popularItems.has(Integer.toString(item.getID()))) {
                        last = popularItems.get(Integer.toString(item.getID())).getAsInt();
                    }
                    popularItems.addProperty(Integer.toString(item.getID()), (Number)(last + 1));
                    contPopularItems.setEntry("current-" + store.getID(), (JsonElement)popularItems);
                    return true;
                }
                catch (IOException e) {
                    LogManager.getLogger().error("Failed to save popular items", (Throwable)e);
                }
                return true;
            }, null);
            if (currencyUpdate.gemCount != currentG) {
                resp.currencyUpdate = currencyUpdate;
                currencyAccWide.setEntry("gems", (JsonElement)new JsonPrimitive((Number)currencyUpdate.gemCount));
            }
            if (currencyUpdate.coinCount != currentC) {
                resp.currencyUpdate = currencyUpdate;
                currency.setEntry("coins", (JsonElement)new JsonPrimitive((Number)currencyUpdate.coinCount));
            }
            resp.prizeItems = (InventoryUpdateResponseData.PrizeItemInfo[])prizeLst.toArray(InventoryUpdateResponseData.PrizeItemInfo[]::new);
            resp.updateItems = (InventoryUpdateResponseData.ItemUpdateBlock[])itemLst.toArray(InventoryUpdateResponseData.ItemUpdateBlock[]::new);
            if (resp.prizeItems.length == 0) {
                resp.prizeItems = null;
            }
            if (resp.updateItems.length == 0) {
                resp.updateItems = null;
            }
            return resp;
        }
        InventoryUpdateResponseData fail = new InventoryUpdateResponseData();
        fail.success = false;
        return fail;
    }

    static {
        InventoryUtils.registerItemRedemptionHandler(new DefaultItemRedemptionHandler());
        InventoryUtils.registerItemRedemptionHandler(new ProfileSlotItemRedemptionHandler());
        InventoryUtils.registerItemRedemptionHandler(new GemItemRedemptionHandler());
        InventoryUtils.registerItemRedemptionHandler(new CoinItemRedemptionHandler());
        InventoryUtils.registerInventorySecurityValidator(new AttributeSecurityValidator());
        InventoryUtils.registerInventorySecurityValidator(new MysteryBoxSecurityValidator());
        InventoryUtils.registerInventorySecurityValidator(new BundleSecurityValidator());
    }
}

