/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.permissions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.gameplayapi.permissions.PermissionLevel;
import org.asf.edge.gameplayapi.permissions.PermissionNode;
import org.asf.edge.gameplayapi.permissions.PermissionNodeType;

public class PermissionContext {
    private AccountObject account;
    private Logger logger = LogManager.getLogger((String)"PERMISSIONS");
    protected static PermissionContextImplementationProvider implementationProvider = acc -> new PermissionContext(acc);

    public PermissionContext(AccountObject account) {
        this.account = account;
    }

    public static PermissionContext getFor(AccountObject account) {
        return implementationProvider.getForAccount(account);
    }

    public AccountObject getAccount() {
        return this.account;
    }

    public boolean hasPermission(String node, PermissionLevel level) {
        PermissionNode[] nodes;
        if (node.endsWith(".*")) {
            node = node.substring(0, node.lastIndexOf(".*"));
        }
        for (PermissionNode nd : nodes = this.getNodes()) {
            if (nd.getType() != PermissionNodeType.DENY || !nd.getNode().equalsIgnoreCase("*") && !node.equalsIgnoreCase(nd.getNode()) && !node.toLowerCase().startsWith(nd.getNode().toLowerCase() + ".")) continue;
            return false;
        }
        for (PermissionNode nd : nodes) {
            if (nd.getType() != PermissionNodeType.ALLOW || !nd.getNode().equalsIgnoreCase("*") && !node.equalsIgnoreCase(nd.getNode()) && !node.toLowerCase().startsWith(nd.getNode().toLowerCase() + ".")) continue;
            return true;
        }
        return this.getPermissionLevel().ordinal() >= level.ordinal();
    }

    public void addNode(String node, PermissionNodeType type) {
        this.addNode(new PermissionNode(node, type));
    }

    public void addNode(PermissionNode node) {
        try {
            JsonObject perms;
            if (this.account.getAccountData().entryExists("permissions")) {
                perms = this.account.getAccountData().getEntry("permissions").getAsJsonObject();
            } else {
                perms = new JsonObject();
                JsonObject nodes = new JsonObject();
                nodes.add("allowed", (JsonElement)new JsonArray());
                nodes.add("denied", (JsonElement)new JsonArray());
                perms.add("permissionNodes", (JsonElement)nodes);
            }
            perms = perms.get("permissionNodes").getAsJsonObject();
            JsonArray allowed = perms.get("allowed").getAsJsonArray();
            JsonArray denied = perms.get("denied").getAsJsonArray();
            if (node.getType() == PermissionNodeType.ALLOW) {
                allowed.add(node.getNode());
            } else {
                denied.add(node.getNode());
            }
            this.account.getAccountData().setEntry("permissions", (JsonElement)perms);
        }
        catch (IOException e) {
            this.logger.warn("Failed to modify permission nodes for " + this.account.getAccountID() + " due to a database error.", (Throwable)e);
        }
    }

    public void removeNode(PermissionNode node) {
        try {
            if (this.account.getAccountData().entryExists("permissions")) {
                JsonObject perms = this.account.getAccountData().getEntry("permissions").getAsJsonObject();
                perms = perms.get("permissionNodes").getAsJsonObject();
                JsonArray allowed = perms.get("allowed").getAsJsonArray();
                JsonArray denied = perms.get("denied").getAsJsonArray();
                if (node.getType() == PermissionNodeType.ALLOW) {
                    for (JsonElement ele : allowed) {
                        if (!ele.getAsString().equals(node.getNode())) continue;
                        allowed.remove(ele);
                        this.account.getAccountData().setEntry("permissions", (JsonElement)perms);
                        return;
                    }
                } else {
                    for (JsonElement ele : denied) {
                        if (!ele.getAsString().equals(node.getNode())) continue;
                        denied.remove(ele);
                        this.account.getAccountData().setEntry("permissions", (JsonElement)perms);
                        return;
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed to modify permission nodes for " + this.account.getAccountID() + " due to a database error.", (Throwable)e);
        }
    }

    public PermissionNode[] getNodes() {
        try {
            if (this.account.getAccountData().entryExists("permissions")) {
                JsonObject perms = this.account.getAccountData().getEntry("permissions").getAsJsonObject();
                perms = perms.get("permissionNodes").getAsJsonObject();
                JsonArray allowed = perms.get("allowed").getAsJsonArray();
                JsonArray denied = perms.get("denied").getAsJsonArray();
                ArrayList<PermissionNode> nodes = new ArrayList<PermissionNode>();
                for (JsonElement node : allowed) {
                    nodes.add(new PermissionNode(node.getAsString(), PermissionNodeType.ALLOW));
                }
                for (JsonElement node : denied) {
                    nodes.add(new PermissionNode(node.getAsString(), PermissionNodeType.DENY));
                }
                return (PermissionNode[])nodes.toArray(PermissionNode[]::new);
            }
            return new PermissionNode[0];
        }
        catch (IOException e) {
            this.logger.warn("Failed to retrieve permission nodes for " + this.account.getAccountID() + " due to a database error.", (Throwable)e);
            return new PermissionNode[0];
        }
    }

    public void setPermissionLevel(PermissionLevel newLevel) {
        try {
            JsonObject perms;
            if (this.account.getAccountData().entryExists("permissions")) {
                perms = this.account.getAccountData().getEntry("permissions").getAsJsonObject();
            } else {
                perms = new JsonObject();
                JsonObject nodes = new JsonObject();
                nodes.add("allowed", (JsonElement)new JsonArray());
                nodes.add("denied", (JsonElement)new JsonArray());
                perms.add("permissionNodes", (JsonElement)nodes);
            }
            perms.addProperty("permissionLevel", newLevel.toString());
            this.account.getAccountData().setEntry("permissions", (JsonElement)perms);
        }
        catch (IOException e) {
            this.logger.warn("Failed to save permission level for " + this.account.getAccountID() + " due to a database error.", (Throwable)e);
        }
    }

    public PermissionLevel getPermissionLevel() {
        try {
            JsonElement ele = this.account.getAccountData().getEntry("permissions");
            if (ele != null) {
                String level = ele.getAsJsonObject().get("permissionLevel").getAsString();
                for (PermissionLevel lv : PermissionLevel.values()) {
                    if (!lv.toString().equalsIgnoreCase(level)) continue;
                    if (lv == PermissionLevel.GUEST) {
                        if (this.account.isGuestAccount()) {
                            return PermissionLevel.GUEST;
                        }
                        return PermissionLevel.PLAYER;
                    }
                    return lv;
                }
                this.logger.warn("Unrecognized permission level: " + level + ", using default level.");
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed to retrieve permission level for " + this.account.getAccountID() + " due to a database error, using default level.", (Throwable)e);
        }
        if (this.account.isGuestAccount()) {
            return PermissionLevel.GUEST;
        }
        return PermissionLevel.PLAYER;
    }

    public static interface PermissionContextImplementationProvider {
        public PermissionContext getForAccount(AccountObject var1);
    }
}

