/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.tools;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.ConnectiveHttpServer;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.util.TripleDesUtil;
import org.bouncycastle.util.Arrays;

public class SnifferMain {
    private static OutputStream fOut;
    private static Object writeLock;
    private static int currentPort;
    private static HashMap<String, Integer> binaryProxies;
    private static String encryptedManifest;
    private static boolean disableCredentialSafeties;

    private static void startBinaryProxy(int localPort, String host, int port) throws IOException {
        new BinaryProxy().start(localPort, host, port);
    }

    public static void main(String[] args) throws IOException {
        String man;
        CommonInit.initAll();
        Logger log = LogManager.getLogger((String)"Sniffer");
        log.info("Setting up sniffer...");
        log.info("Loading configuration...");
        JsonObject config = JsonParser.parseString((String)Files.readString(Path.of("sniffer.json", new String[0]))).getAsJsonObject();
        if (config.has("disableCredentialSafeties")) {
            disableCredentialSafeties = config.get("disableCredentialSafeties").getAsBoolean();
        }
        if (disableCredentialSafeties) {
            log.warn("!!! WARNING !!!");
            log.warn("");
            log.warn("Credential filtering has been disabled!");
            log.warn("If you do not wish filtering to be disabled, edit config.json and set 'disableCredentialSafeties' to false!");
            log.warn("");
            log.warn("DO NOT SEND THIS SNIFF TO ANYONE YOU DO NOT PERSONALLY TRUST IF THIS OPTION IS ENABLED");
            log.warn("OTHERWISE THEY WILL RECEIVE YOUR LOGIN CREDENTIALS");
            log.warn("");
            log.warn("!!! WARNING !!!");
        }
        log.info("Downloading application manifest...");
        Object url = config.get("mediaServer").getAsString();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + "DWADragonsUnity/" + config.get("platform").getAsString() + "/" + config.get("version").getAsString() + "/DWADragonsMain.xml";
        URL u = new URL((String)url);
        if (!config.get("secret").getAsString().equals("unset")) {
            byte[] key;
            strm = u.openStream();
            byte[] enc = Base64.getDecoder().decode(strm.readAllBytes());
            strm.close();
            log.info("Computing key...");
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                key = digest.digest(config.get("secret").getAsString().getBytes("ASCII"));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            log.info("Decrypting manifest...");
            byte[] dec = TripleDesUtil.decrypt((byte[])enc, (byte[])key);
            man = new String(dec, "ASCII");
        } else {
            strm = u.openStream();
            man = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
        }
        log.info("Parsing manifest...");
        XmlMapper mapper = new XmlMapper();
        ObjectNode manifest = (ObjectNode)mapper.readValue(man, ObjectNode.class);
        if (manifest.has("MMOServer")) {
            String sfsHost = manifest.get("MMOServer").asText();
            int sfsPort = manifest.get("MMOServerPort").asInt();
            log.info("Starting binary proxy...");
            currentPort = sfsPort + 1;
            SnifferMain.startBinaryProxy(sfsPort, sfsHost, sfsPort);
        }
        log.info("Modifying manifest...");
        JsonObject replace = config.get("manifestReplace").getAsJsonObject();
        for (String replaceKey : replace.keySet()) {
            man = man.replace(replaceKey, replace.get(replaceKey).getAsString().replace("%local%", config.get("host").getAsString() + ":" + config.get("port").getAsString()));
        }
        if (!config.get("secret").getAsString().equals("unset")) {
            byte[] key;
            log.info("Computing key...");
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                key = digest.digest(config.get("secret").getAsString().getBytes("ASCII"));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            log.info("Re-encrypting manifest...");
            encryptedManifest = Base64.getEncoder().encodeToString(TripleDesUtil.encrypt((byte[])man.getBytes("ASCII"), (byte[])key));
        } else {
            encryptedManifest = man;
        }
        log.info("Setting up http server...");
        ConnectiveHttpServer srv = ConnectiveHttpServer.create((String)"HTTP/1.1", Map.of("address", config.get("host").getAsString(), "port", config.get("port").getAsString()));
        srv.registerProcessor((HttpPushProcessor)new ManifestRequestProcessor("/DWADragonsUnity/" + config.get("platform").getAsString() + "/" + config.get("version").getAsString() + "/DWADragonsMain.xml"));
        srv.registerProcessor((HttpPushProcessor)new ProxyProcessor());
        log.info("Starting sniffer server on " + config.get("host").getAsString() + ":" + config.get("port").getAsString() + "...");
        srv.start();
        log.info("Sniffer is running!");
        log.info("Modified manifest published to http://" + config.get("host").getAsString() + ":" + config.get("port").getAsString() + "/DWADragonsUnity/" + config.get("platform").getAsString() + "/" + config.get("version").getAsString() + "/DWADragonsMain.xml");
        srv.waitForExit();
    }

    static {
        writeLock = new Object();
        new File("sniffs").mkdirs();
        try {
            fOut = new FileOutputStream("sniffs/sniff-" + System.currentTimeMillis() + ".log");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        currentPort = 9933;
        binaryProxies = new HashMap();
    }

    private static class BinaryProxy {
        private ServerSocket srvTcp;
        private DatagramSocket srvUdp;
        private HashMap<String, DatagramSocket> clients = new HashMap();

        private BinaryProxy() {
        }

        private int readInt(InputStream strm) throws IOException {
            return ByteBuffer.wrap(strm.readNBytes(4)).getInt();
        }

        private int readShort(InputStream strm) throws IOException {
            return ByteBuffer.wrap(strm.readNBytes(2)).getShort();
        }

        private void writeInt(OutputStream strm, int val) throws IOException {
            strm.write(ByteBuffer.allocate(4).putInt(val).array());
        }

        private void writeShort(OutputStream strm, short val) throws IOException {
            strm.write(ByteBuffer.allocate(2).putShort(val).array());
        }

        public void start(int localPort, String remoteHost, int remotePort) throws UnknownHostException, IOException {
            this.srvTcp = new ServerSocket(localPort, 0, InetAddress.getLoopbackAddress());
            AsyncTaskManager.runAsync(() -> {
                try {
                    while (true) {
                        Socket client = this.srvTcp.accept();
                        AsyncTaskManager.runAsync(() -> {
                            try {
                                Socket remoteConn = new Socket(InetAddress.getByName(remoteHost), remotePort);
                                AsyncTaskManager.runAsync(() -> {
                                    while (client.isConnected()) {
                                        try {
                                            Object bIn;
                                            int b = client.getInputStream().read();
                                            if (b == -1) {
                                                throw new IOException("Disconnected");
                                            }
                                            boolean encrypted = (b & 0x40) > 0;
                                            boolean compressed = (b & 0x20) > 0;
                                            boolean blueBoxed = (b & 0x10) > 0;
                                            boolean largeSize = (b & 8) > 0;
                                            int length = largeSize ? this.readInt(client.getInputStream()) : this.readShort(client.getInputStream());
                                            byte[] payload = client.getInputStream().readNBytes(length);
                                            if (encrypted) {
                                                throw new IOException("Encryption not supported");
                                            }
                                            if (compressed) {
                                                bIn = new ByteArrayInputStream(payload);
                                                InflaterInputStream inInf = new InflaterInputStream((InputStream)bIn);
                                                payload = inInf.readAllBytes();
                                                inInf.close();
                                            }
                                            bIn = writeLock;
                                            synchronized (bIn) {
                                                JsonObject itm = new JsonObject();
                                                itm.addProperty("time", (Number)System.currentTimeMillis());
                                                itm.addProperty("type", "bstcp");
                                                itm.addProperty("host", remoteHost);
                                                itm.addProperty("port", (Number)remotePort);
                                                itm.addProperty("side", "C->S");
                                                itm.addProperty("data", Base64.getEncoder().encodeToString(payload));
                                                fOut.write((itm.toString() + "\n\n").getBytes("UTF-8"));
                                                fOut.flush();
                                            }
                                            boolean bl = compressed = payload.length >= 2000000;
                                            if (compressed) {
                                                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                                                DeflaterOutputStream dOut = new DeflaterOutputStream(bOut);
                                                dOut.write(payload);
                                                dOut.close();
                                                payload = bOut.toByteArray();
                                            }
                                            largeSize = payload.length > Short.MAX_VALUE;
                                            int header = 0;
                                            if (encrypted) {
                                                header |= 0x40;
                                            }
                                            if (compressed) {
                                                header |= 0x20;
                                            }
                                            if (blueBoxed) {
                                                header |= 0x10;
                                            }
                                            if (largeSize) {
                                                header |= 8;
                                            }
                                            remoteConn.getOutputStream().write(header);
                                            if (largeSize) {
                                                this.writeInt(remoteConn.getOutputStream(), payload.length);
                                            } else {
                                                this.writeShort(remoteConn.getOutputStream(), (short)payload.length);
                                            }
                                            remoteConn.getOutputStream().write(payload);
                                        }
                                        catch (IOException e) {
                                            try {
                                                client.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                            try {
                                                remoteConn.close();
                                            }
                                            catch (IOException iOException) {}
                                            break;
                                        }
                                    }
                                });
                                AsyncTaskManager.runAsync(() -> {
                                    while (remoteConn.isConnected()) {
                                        try {
                                            Object bIn;
                                            int b = remoteConn.getInputStream().read();
                                            if (b == -1) {
                                                throw new IOException("Disconnected");
                                            }
                                            boolean encrypted = (b & 0x40) > 0;
                                            boolean compressed = (b & 0x20) > 0;
                                            boolean blueBoxed = (b & 0x10) > 0;
                                            boolean largeSize = (b & 8) > 0;
                                            int length = largeSize ? this.readInt(remoteConn.getInputStream()) : this.readShort(remoteConn.getInputStream());
                                            byte[] payload = remoteConn.getInputStream().readNBytes(length);
                                            if (encrypted) {
                                                throw new IOException("Encryption not supported");
                                            }
                                            if (compressed) {
                                                bIn = new ByteArrayInputStream(payload);
                                                InflaterInputStream inInf = new InflaterInputStream((InputStream)bIn);
                                                payload = inInf.readAllBytes();
                                                inInf.close();
                                            }
                                            bIn = writeLock;
                                            synchronized (bIn) {
                                                JsonObject itm = new JsonObject();
                                                itm.addProperty("time", (Number)System.currentTimeMillis());
                                                itm.addProperty("type", "bstcp");
                                                itm.addProperty("host", remoteHost);
                                                itm.addProperty("port", (Number)remotePort);
                                                itm.addProperty("side", "S->C");
                                                itm.addProperty("data", Base64.getEncoder().encodeToString(payload));
                                                fOut.write((itm.toString() + "\n\n").getBytes("UTF-8"));
                                                fOut.flush();
                                            }
                                            boolean bl = compressed = payload.length >= 2000000;
                                            if (compressed) {
                                                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                                                DeflaterOutputStream dOut = new DeflaterOutputStream(bOut);
                                                dOut.write(payload);
                                                dOut.close();
                                                payload = bOut.toByteArray();
                                            }
                                            largeSize = payload.length > Short.MAX_VALUE;
                                            int header = 0;
                                            if (encrypted) {
                                                header |= 0x40;
                                            }
                                            if (compressed) {
                                                header |= 0x20;
                                            }
                                            if (blueBoxed) {
                                                header |= 0x10;
                                            }
                                            if (largeSize) {
                                                header |= 8;
                                            }
                                            client.getOutputStream().write(header);
                                            if (largeSize) {
                                                this.writeInt(client.getOutputStream(), payload.length);
                                            } else {
                                                this.writeShort(client.getOutputStream(), (short)payload.length);
                                            }
                                            client.getOutputStream().write(payload);
                                        }
                                        catch (IOException e) {
                                            try {
                                                client.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                            try {
                                                remoteConn.close();
                                            }
                                            catch (IOException iOException) {}
                                            break;
                                        }
                                    }
                                });
                            }
                            catch (IOException e) {
                                try {
                                    client.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }
                catch (IOException e) {
                    return;
                }
            });
            this.srvUdp = new DatagramSocket(localPort);
            AsyncTaskManager.runAsync(() -> {
                try {
                    while (true) {
                        DatagramSocket client;
                        Object itm;
                        byte[] buf = new byte[20480000];
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        this.srvUdp.receive(packet);
                        int read = packet.getLength();
                        byte[] data = packet.getData();
                        Object object = writeLock;
                        synchronized (object) {
                            itm = new JsonObject();
                            itm.addProperty("time", (Number)System.currentTimeMillis());
                            itm.addProperty("type", "udp");
                            itm.addProperty("host", remoteHost);
                            itm.addProperty("port", (Number)remotePort);
                            itm.addProperty("side", "C->S");
                            itm.addProperty("data", Base64.getEncoder().encodeToString(Arrays.copyOf((byte[])data, (int)read)));
                            fOut.write((itm.toString() + "\n\n").getBytes("UTF-8"));
                            fOut.flush();
                        }
                        itm = this.clients;
                        synchronized (itm) {
                            client = this.clients.get(packet.getAddress().toString() + "///" + packet.getPort());
                        }
                        if (client == null) {
                            client = new DatagramSocket();
                            client.connect(InetAddress.getByName(remoteHost), remotePort);
                            itm = this.clients;
                            synchronized (itm) {
                                this.clients.put(packet.getAddress().toString() + "///" + packet.getPort(), client);
                            }
                            DatagramSocket cF = client;
                            AsyncTaskManager.runAsync(() -> {
                                try {
                                    while (true) {
                                        byte[] buf2 = new byte[20480000];
                                        DatagramPacket packet2 = new DatagramPacket(buf2, buf2.length);
                                        cF.receive(packet);
                                        int read2 = packet.getLength();
                                        byte[] data2 = packet2.getData();
                                        Object object = writeLock;
                                        synchronized (object) {
                                            JsonObject itm = new JsonObject();
                                            itm.addProperty("time", (Number)System.currentTimeMillis());
                                            itm.addProperty("type", "udp");
                                            itm.addProperty("host", remoteHost);
                                            itm.addProperty("port", (Number)remotePort);
                                            itm.addProperty("side", "S->C");
                                            itm.addProperty("data", Base64.getEncoder().encodeToString(Arrays.copyOf((byte[])data2, (int)read2)));
                                            fOut.write((itm.toString() + "\n\n").getBytes("UTF-8"));
                                            fOut.flush();
                                        }
                                        DatagramPacket outp = new DatagramPacket(packet2.getData(), read2, packet.getAddress(), packet.getPort());
                                        this.srvUdp.send(outp);
                                    }
                                }
                                catch (IOException e) {
                                    cF.close();
                                    HashMap<String, DatagramSocket> hashMap = this.clients;
                                    synchronized (hashMap) {
                                        this.clients.remove(packet.getAddress().toString() + "///" + packet.getPort());
                                    }
                                    return;
                                }
                            });
                        }
                        DatagramPacket outp = new DatagramPacket(packet.getData(), read);
                        client.send(outp);
                    }
                }
                catch (IOException e) {
                    return;
                }
            });
        }
    }

    private static class ManifestRequestProcessor
    extends HttpPushProcessor {
        private String path;

        public ManifestRequestProcessor(String path) {
            this.path = path;
        }

        public void process(String path, String method, RemoteClient client, String contentType) throws IOException {
            this.setResponseContent("text/xml", encryptedManifest);
        }

        public HttpPushProcessor createNewInstance() {
            return new ManifestRequestProcessor(this.path);
        }

        public String path() {
            return this.path;
        }

        public boolean supportsNonPush() {
            return true;
        }
    }

    private static class ProxyProcessor
    extends HttpPushProcessor {
        private static XmlMapper mapper = new XmlMapper();

        private ProxyProcessor() {
        }

        public HttpPushProcessor createNewInstance() {
            return new ProxyProcessor();
        }

        public String path() {
            return "/";
        }

        public boolean supportsNonPush() {
            return true;
        }

        public boolean supportsChildPaths() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String path, String method, RemoteClient client, String contentType) throws IOException {
            block23: {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.split("/").length < 2) {
                    this.setResponseStatus(400, "Bad Request");
                    return;
                }
                String protocol = path;
                String server = protocol.substring(protocol.indexOf("/") + 1);
                protocol = protocol.substring(0, protocol.indexOf("/"));
                path = server.substring(server.indexOf("/"));
                server = server.substring(0, server.indexOf("/"));
                String url = protocol + "://" + server + path;
                if (!this.getRequest().getRequestQuery().isEmpty()) {
                    url = url + "?" + this.getRequest().getRequestQuery();
                }
                JsonObject requestInfo = new JsonObject();
                requestInfo.addProperty("url", url);
                requestInfo.addProperty("method", method);
                JsonObject headers = new JsonObject();
                for (String name : this.getHeaders().getHeaderNames()) {
                    JsonArray hValues = new JsonArray();
                    for (String value : this.getHeaders().getHeaderValues(name)) {
                        hValues.add(value);
                    }
                    headers.add(name, (JsonElement)hValues);
                }
                requestInfo.add("headers", (JsonElement)headers);
                byte[] payload = null;
                requestInfo.addProperty("hasBody", Boolean.valueOf(this.getRequest().hasRequestBody()));
                if (this.getRequest().hasRequestBody()) {
                    ByteArrayOutputStream outp = new ByteArrayOutputStream();
                    this.getRequest().transferRequestBody((OutputStream)outp);
                    payload = outp.toByteArray();
                    requestInfo.addProperty("requestBody", Base64.getEncoder().encodeToString(payload));
                }
                try {
                    HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                    conn.setRequestMethod(method);
                    conn.setDoInput(true);
                    for (String name : this.getHeaders().getHeaderNames()) {
                        if (name.equalsIgnoreCase("Host")) continue;
                        for (String value : this.getHeaders().getHeaderValues(name)) {
                            conn.addRequestProperty(name, value);
                        }
                    }
                    if (payload != null) {
                        conn.setDoOutput(true);
                        conn.getOutputStream().write(payload);
                    }
                    JsonObject respInfo = new JsonObject();
                    int responseCode = conn.getResponseCode();
                    String responseMessage = conn.getResponseMessage();
                    this.setResponseStatus(responseCode, responseMessage);
                    respInfo.addProperty("status", (Number)responseCode);
                    respInfo.addProperty("statusMessage", responseMessage);
                    JsonObject respHeaders = new JsonObject();
                    for (String name : conn.getHeaderFields().keySet()) {
                        if (name == null || name.equalsIgnoreCase("transfer-encoding")) continue;
                        JsonArray hValues = new JsonArray();
                        boolean first = true;
                        for (String value : conn.getHeaderFields().get(name)) {
                            hValues.add(value);
                            if (first) {
                                first = false;
                                this.setResponseHeader(name, value, false);
                                continue;
                            }
                            this.setResponseHeader(name, value, true);
                        }
                        respHeaders.add(name, (JsonElement)hValues);
                    }
                    respInfo.add("headers", (JsonElement)respHeaders);
                    InputStream body = responseCode >= 400 ? conn.getErrorStream() : conn.getInputStream();
                    try {
                        byte[] respData = body.readAllBytes();
                        respInfo.addProperty("responseBody", Base64.getEncoder().encodeToString(respData));
                        if (path.equalsIgnoreCase("/ConfigurationWebService.asmx/GetMMOServerInfoWithZone")) {
                            String xml = new String(respData, "UTF-8");
                            ServerList serverList = (ServerList)mapper.readValue(xml, ServerList.class);
                            for (ObjectNode obj : serverList.servers) {
                                String host = obj.get("IP").asText();
                                int port = obj.get("PN").asInt();
                                HashMap<String, Integer> hashMap = binaryProxies;
                                synchronized (hashMap) {
                                    if (!binaryProxies.containsKey("[" + host + "]:" + port)) {
                                        int p;
                                        ++currentPort;
                                        SnifferMain.startBinaryProxy(p, host, port);
                                        binaryProxies.put("[" + host + "]:" + port, p);
                                    }
                                    obj.set("IP", (JsonNode)new TextNode("localhost"));
                                    obj.set("PN", (JsonNode)new IntNode(binaryProxies.get("[" + host + "]:" + port).intValue()));
                                }
                            }
                            xml = mapper.writer().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("ArrayOfMMOServerInfo").writeValueAsString((Object)serverList);
                            respData = xml.getBytes("UTF-8");
                        }
                        this.setResponseContent(respData);
                    }
                    catch (IOException e) {
                        respInfo.addProperty("responseBody", "");
                    }
                    if (!disableCredentialSafeties && (path.equalsIgnoreCase("/v3/AuthenticationWebService.asmx/LoginParent") || path.equalsIgnoreCase("/AuthenticationWebService.asmx/LoginChild") || path.equalsIgnoreCase("/MembershipWebService.asmx/GetSubscriptionInfo"))) {
                        LogManager.getLogger((String)"Sniffer").warn("Skipped logging " + url + " to prevent credential leak");
                        return;
                    }
                    this.logRequest(requestInfo, respInfo);
                }
                catch (IOException e) {
                    JsonObject respInfo = new JsonObject();
                    respInfo.addProperty("status", (Number)500);
                    respInfo.addProperty("statusMessage", "[Sniffer] Failed to proxy to " + url);
                    respInfo.add("headers", (JsonElement)new JsonObject());
                    respInfo.addProperty("responseBody", "");
                    this.setResponseStatus(404, "Not found");
                    LogManager.getLogger((String)"Sniffer").error("Failed to proxy to " + url, (Throwable)e);
                    this.logRequest(requestInfo, respInfo);
                    if (disableCredentialSafeties || !path.equalsIgnoreCase("/v3/AuthenticationWebService.asmx/LoginParent") && !path.equalsIgnoreCase("/AuthenticationWebService.asmx/LoginChild") && !path.equalsIgnoreCase("/MembershipWebService.asmx/GetSubscriptionInfo")) break block23;
                    LogManager.getLogger((String)"Sniffer").warn("Skipped logging " + url + " to prevent credential leak");
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logRequest(JsonObject requestInfo, JsonObject respInfo) throws UnsupportedEncodingException, IOException {
            Object object = writeLock;
            synchronized (object) {
                JsonObject itm = new JsonObject();
                itm.addProperty("time", (Number)System.currentTimeMillis());
                itm.addProperty("type", "http");
                itm.add("request", (JsonElement)requestInfo);
                itm.add("response", (JsonElement)respInfo);
                fOut.write((itm.toString() + "\n\n").getBytes("UTF-8"));
                fOut.flush();
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
        private static class ServerList {
            @JsonProperty(value="MMOServerInfo")
            @JacksonXmlElementWrapper(useWrapping=false)
            public ObjectNode[] servers;

            private ServerList() {
            }
        }
    }
}

