/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.impl.BasicAccountManager;
import org.asf.edge.common.services.accounts.impl.BasicAccountObject;
import org.asf.edge.common.services.accounts.impl.BasicAccountSaveContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.items.impl.ItemManagerImpl;

public class LegacyAccountDataConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ClassNotFoundException {
        Connection conn;
        if (args.length < 1) {
            System.err.println("Usage: \"<old database URL>\" [\"<key>\" \"<value>\"...]");
            System.exit(1);
            return;
        }
        ArrayList<String> a = new ArrayList<String>(List.of(args));
        a.remove(0);
        if (a.size() % 2 != 0) {
            System.err.println("Usage: \"<old database URL>\" [\"<key>\" \"<value>\"...]");
            System.exit(1);
            return;
        }
        CommonInit.initAll();
        Class.forName("com.mysql.cj.jdbc.Driver");
        Class.forName("org.mariadb.jdbc.Driver");
        Class.forName("org.asf.edge.common.jdbc.LoggingProxyDriver");
        Class.forName("org.asf.edge.common.jdbc.LockingDriver");
        Logger logger = LogManager.getLogger((String)"CONVERTER");
        logger.info("Preparing to start...");
        logger.info("Loading properties...");
        Properties props = new Properties();
        for (int i = 0; i < a.size(); i += 2) {
            props.setProperty(a.get(i), a.get(i + 1));
        }
        logger.info("Loading managers...");
        logger.debug("Loading account manager implementations...");
        AccountManager.initAccountManagerServices((int)-10, (int)0, (int)-5);
        logger.debug("Selecting account manager implementation...");
        ServiceManager.selectServiceImplementation(AccountManager.class);
        logger.debug("Loading account manager...");
        AccountManager.getInstance().loadManager();
        logger.debug("Loading common data manager implementations...");
        CommonDataManager.initCommonDataManagerServices((int)-10, (int)0, (int)-5);
        logger.debug("Selecting common data manager implementation...");
        ServiceManager.selectServiceImplementation(CommonDataManager.class);
        logger.debug("Loading common data manager...");
        CommonDataManager.getInstance().loadManager();
        logger.debug("Setting up item manager...");
        ServiceManager.registerServiceImplementation(ItemManager.class, (AbstractService)new ItemManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(ItemManager.class);
        BasicAccountManager mgr = null;
        if (AccountManager.getInstance() instanceof BasicAccountManager) {
            mgr = (BasicAccountManager)AccountManager.getInstance();
        }
        if (mgr == null) {
            System.err.println("Incompatible account managers implementation, requiring a implementation based on the BasicAccountManager class.");
            System.exit(1);
            return;
        }
        logger.info("Connecting to database...");
        try {
            DriverManager.getConnection(args[0], props).close();
        }
        catch (SQLException e) {
            logger.error("Connection failure!", (Throwable)e);
            System.exit(1);
            return;
        }
        long accountCount = 0L;
        try {
            conn = DriverManager.getConnection(args[0], props);
            try {
                PreparedStatement statement = conn.prepareStatement("SELECT ID, USERNAME FROM USERMAP");
                ResultSet res = statement.executeQuery();
                while (res.next()) {
                    ++accountCount;
                }
                res.close();
                statement.close();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.error("Indexing failure!", (Throwable)e);
            System.exit(1);
            return;
        }
        logger.info("Beginning migration of " + accountCount + " accounts...");
        try {
            conn = DriverManager.getConnection(args[0], props);
            try {
                long i = 0L;
                PreparedStatement statement = conn.prepareStatement("SELECT ID, USERNAME, CREDS FROM USERMAP");
                ResultSet res = statement.executeQuery();
                while (res.next()) {
                    ++i;
                    String id = res.getString("ID");
                    String name = res.getString("USERNAME");
                    byte[] cred = res.getBytes("CREDS");
                    PreparedStatement st2 = conn.prepareStatement("SELECT EMAIL FROM EMAILMAP WHERE ID = ?");
                    st2.setString(1, id);
                    ResultSet rs2 = st2.executeQuery();
                    String email = null;
                    if (rs2.next()) {
                        email = rs2.getString("EMAIL");
                    }
                    rs2.close();
                    st2.close();
                    logger.info("[" + i + " / " + accountCount + "] Converting " + name + "...");
                    BasicAccountObject account = !name.startsWith("g/") ? mgr.registerAccount(id, email, name, cred) : mgr.registerGuest(id, name.substring(2));
                    String step = "STEP 1/3";
                    logger.info("[" + i + " / " + accountCount + "] [" + step + "] Converting saves of " + name + "...");
                    st2 = conn.prepareStatement("SELECT SAVES FROM SAVEMAP WHERE ACCID = ?");
                    st2.setString(1, id);
                    rs2 = st2.executeQuery();
                    String savesD = null;
                    if (rs2.next()) {
                        savesD = rs2.getString("SAVES");
                    }
                    rs2.close();
                    st2.close();
                    if (savesD == null) {
                        logger.warn("Save list corrupted of " + id + ", unable to convert save data!");
                    } else {
                        JsonArray saveData = JsonParser.parseString((String)savesD).getAsJsonArray();
                        int i2 = 1;
                        for (JsonElement ele : saveData) {
                            JsonObject save = ele.getAsJsonObject();
                            String svID = save.get("id").getAsString();
                            String svName = save.get("username").getAsString();
                            logger.info("[" + i + " / " + accountCount + "] [" + step + "] [SAVE " + i2 + " / " + saveData.size() + "] Converting save " + svName + "...");
                            BasicAccountSaveContainer sv = account.performCreateSave(svID, svName);
                            if (sv == null) {
                                logger.error("Migration failure! Save creation failure!");
                                System.exit(1);
                                return;
                            }
                            logger.info("[" + i + " / " + accountCount + "] [" + step + "] [SAVE " + i2 + " / " + saveData.size() + "] Migrating data of save " + svName + "...");
                            LegacyAccountDataConverter.migrateDataContainer(svID + "//", "SAVESPECIFICPLAYERDATA", sv.getSaveData(), conn, logger, "[" + i + " / " + accountCount + "] [" + step + "] [SAVE " + i2 + " / " + saveData.size() + "] ");
                            logger.info("[" + i + " / " + accountCount + "] [" + step + "] [SAVE " + i2++ + " / " + saveData.size() + "] Updating inventory format of save " + svName + "...");
                            LegacyAccountDataConverter.updateInventories(sv.getSaveData(), logger);
                        }
                    }
                    step = "STEP 2/3";
                    logger.info("[" + i + " / " + accountCount + "] [" + step + "] Converting account data of account " + name + "...");
                    LegacyAccountDataConverter.migrateDataContainer(id + "//", "ACCOUNTWIDEPLAYERDATA", account.getAccountData(), conn, logger, "[" + i + " / " + accountCount + "] [" + step + "] ");
                    step = "STEP 3/3";
                    logger.info("[" + i + " / " + accountCount + "] [" + step + "] Updating inventory format of account " + name + "...");
                    LegacyAccountDataConverter.updateInventories(account.getAccountData(), logger);
                }
                res.close();
                statement.close();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.error("Migration failure!", (Throwable)e);
            System.exit(1);
            return;
        }
        logger.info("Done!");
    }

    private static void updateInventories(AccountDataContainer accountData, Logger logger) {
        try {
            AccountDataContainer legacyData = accountData.getChildContainer("legacy-common-inventories");
            for (String container : legacyData.getChildContainers()) {
                String[] k;
                int containerID = Integer.parseInt(container);
                AccountDataContainer oldC = legacyData.getChildContainer(container);
                for (String key : k = oldC.getEntryKeys()) {
                    if (!key.startsWith("item-")) continue;
                    int uniqueID = Integer.parseInt(key.substring(5));
                    JsonObject itm = oldC.getEntry(key).getAsJsonObject();
                    int defID = itm.get("id").getAsInt();
                    int quantity = itm.get("quantity").getAsInt();
                    int uses = itm.get("uses").getAsInt();
                    itm = new JsonObject();
                    itm.addProperty("quantity", (Number)quantity);
                    itm.addProperty("uses", (Number)uses);
                    accountData.getChildContainer("commoninventories").getChildContainer("c-" + containerID).getChildContainer("d-" + defID).setEntry("u-" + uniqueID, (JsonElement)itm);
                    accountData.getChildContainer("commoninventories").getChildContainer("c-" + containerID).setEntry("u-" + uniqueID, (JsonElement)new JsonPrimitive((Number)defID));
                }
            }
            legacyData.deleteContainer();
        }
        catch (IOException e) {
            logger.error("Failed to migrate legacy inventories!", (Throwable)e);
        }
    }

    private static void migrateDataContainer(String root, String table, AccountDataContainer saveData, Connection conn, Logger logger, String logPrefix) {
        try {
            PreparedStatement st2 = conn.prepareStatement("SELECT DATA FROM " + table + " WHERE PATH = ?");
            st2.setString(1, root + "datamap");
            ResultSet rs2 = st2.executeQuery();
            if (rs2.next()) {
                logger.info(logPrefix + "Converting data container " + (root.endsWith("//") ? root.substring(0, root.lastIndexOf("//")) : root) + "...");
                JsonArray entries = JsonParser.parseString((String)rs2.getString("DATA")).getAsJsonArray();
                for (JsonElement ele : entries) {
                    String key = ele.getAsString();
                    Object pth = root + key;
                    if (((String)pth).endsWith("/")) {
                        pth = ((String)pth).substring(0, ((String)pth).lastIndexOf("/"));
                        key = key.substring(0, key.lastIndexOf("/"));
                        try {
                            String rootID = saveData.getAccount().getAccountID();
                            if (saveData.getSave() != null) {
                                rootID = saveData.getSave().getSaveID();
                            }
                            if (((String)pth).equals(rootID + "//commoninventories")) {
                                key = "legacy-common-inventories";
                            }
                            LegacyAccountDataConverter.migrateDataContainer((String)pth + "/", table, saveData.getChildContainer(key), conn, logger, logPrefix);
                        }
                        catch (IOException e) {
                            logger.error("Failed to migrate data container " + (String)pth + " (" + table + ")", (Throwable)e);
                        }
                        continue;
                    }
                    if (key.equals("datamap")) continue;
                    PreparedStatement st3 = conn.prepareStatement("SELECT DATA FROM " + table + " WHERE PATH = ?");
                    st3.setString(1, (String)pth);
                    ResultSet rs3 = st3.executeQuery();
                    if (rs3.next()) {
                        logger.info(logPrefix + "Converting data key " + (String)pth + "...");
                        try {
                            saveData.setEntry(key, JsonParser.parseString((String)rs3.getString("DATA")));
                        }
                        catch (JsonSyntaxException | IOException e) {
                            logger.error("Failed to migrate data key " + (String)pth + " (" + table + ")", e);
                        }
                    }
                    rs3.close();
                    st3.close();
                }
            }
            rs2.close();
            st2.close();
        }
        catch (SQLException e) {
            logger.error("Failed to migrate data container " + root + " (" + table + ")", (Throwable)e);
        }
    }
}

