/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.commonapi.http.handlers.api.accounts;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.io.IOException;
import java.util.stream.Stream;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.commonapi.EdgeCommonApiServer;

public class MembershipWebServiceProcessor
extends EdgeWebService<EdgeCommonApiServer> {
    public MembershipWebServiceProcessor(EdgeCommonApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new MembershipWebServiceProcessor((EdgeCommonApiServer)this.getServerInstance());
    }

    public String path() {
        return "/MembershipWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        this.setResponseStatus(404, "Not found");
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getChildList(LegacyFunctionInfo func) throws IOException {
        AccountManager manager = AccountManager.getInstance();
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeCommonApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        SessionToken tkn = new SessionToken();
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        TokenParseResult res = tkn.parseToken(apiToken);
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountObject account = manager.getAccount(tkn.accountID);
        if (account == null) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String[] lst = (String[])Stream.of(account.getSaveIDs()).map(t -> t + ", " + account.getSave(t).getUsername()).toArray(String[]::new);
        StringList ls = new StringList();
        ls.strings = lst;
        if (lst.length != 0) {
            this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfString", (Object)ls));
        } else {
            this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfString", null));
        }
    }

    private static class StringList {
        @JacksonXmlProperty(localName="xmlns", isAttribute=true)
        private final String xmlns = "http://api.jumpstart.com/";
        @JsonProperty(value="string")
        @JacksonXmlElementWrapper(useWrapping=false)
        public String[] strings;

        private StringList() {
        }
    }
}

