/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.textfilter.result;

import org.asf.edge.common.services.textfilter.FilterSeverity;
import org.asf.edge.common.services.textfilter.result.WordMatch;

public class FilterResult {
    private FilterSeverity resultSeverity;
    private WordMatch[] matchedFilters;
    private String filteredResult;

    public FilterResult(WordMatch[] matches, String filteredResult) {
        this.matchedFilters = matches;
        this.filteredResult = filteredResult;
        this.resultSeverity = FilterSeverity.NONE;
        for (WordMatch match : matches) {
            if (match.getSeverity().ordinal() <= this.resultSeverity.ordinal()) continue;
            this.resultSeverity = match.getSeverity();
        }
    }

    public String getFilterResult() {
        return this.filteredResult;
    }

    public FilterSeverity getSeverity() {
        return this.resultSeverity;
    }

    public WordMatch[] getMatches() {
        return (WordMatch[])this.matchedFilters.clone();
    }

    public boolean isMatch() {
        return this.resultSeverity != FilterSeverity.NONE;
    }
}

