/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.commondata;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class CommonDataContainer {
    protected CommonDataContainer parent;
    protected String name = "";
    protected String path = "";

    public ContainerUnsafe unsafeAccessor() {
        return new ContainerUnsafe();
    }

    public CommonDataContainer getParent() {
        return this.parent;
    }

    protected abstract JsonElement get(String var1) throws IOException;

    protected abstract void set(String var1, JsonElement var2) throws IOException;

    protected abstract void create(String var1, String var2, JsonElement var3) throws IOException;

    protected abstract boolean exists(String var1) throws IOException;

    protected abstract void delete(String var1) throws IOException;

    protected abstract String[] getEntryKeys(String var1) throws IOException;

    protected abstract String[] getChildContainers(String var1) throws IOException;

    protected abstract void deleteContainer(String var1) throws IOException;

    protected abstract JsonElement find(BiFunction<String, JsonElement, Boolean> var1, String var2) throws IOException;

    protected abstract void runFor(BiFunction<String, JsonElement, Boolean> var1, String var2) throws IOException;

    protected abstract void runForChildren(Function<String, Boolean> var1, String var2) throws IOException;

    private boolean validName(String key) {
        if (key.contains("/") || key.equals("chholder")) {
            return false;
        }
        if (key.replace(" ", "").trim().isEmpty()) {
            return false;
        }
        return key.length() <= 64;
    }

    public JsonElement getEntry(String key) throws IOException {
        if (!this.validName(key)) {
            return null;
        }
        return this.get(key);
    }

    public boolean entryExists(String key) throws IOException {
        if (!this.validName(key)) {
            return false;
        }
        return this.exists(key);
    }

    public void setEntry(String key, JsonElement value) throws IOException {
        if (!this.validName(key)) {
            throw new IOException("Invalid key");
        }
        boolean existed = this.exists(key);
        if (existed) {
            this.set(key, value);
        } else {
            this.create(key, "", value);
        }
    }

    public void deleteEntry(String key) throws IOException {
        if (!this.validName(key)) {
            throw new IOException("Invalid key");
        }
        if (this.exists(key)) {
            this.delete(key);
        }
    }

    public CommonDataContainer getChildContainer(String key) throws IOException {
        if (!this.validName(key)) {
            throw new IOException("Invalid key");
        }
        if ((this.path + key + "/").length() + 64 > 256) {
            throw new IOException("Invalid key: key name too long, path length limit would be hit");
        }
        return new ChildDataContainer(this.path + key + "/", key, this);
    }

    public String[] getEntryKeys() throws IOException {
        return this.getEntryKeys("");
    }

    public String[] getChildContainers() throws IOException {
        return this.getChildContainers("");
    }

    public JsonElement findEntry(BiFunction<String, JsonElement, Boolean> function) throws IOException {
        return this.find(function, "");
    }

    public void runForEntries(BiFunction<String, JsonElement, Boolean> function) throws IOException {
        this.runFor(function, "");
    }

    public void runForChildContainers(Function<String, Boolean> function) throws IOException {
        this.runForChildren(function, "");
    }

    public void deleteContainer() throws IOException {
        this.deleteContainer("");
    }

    protected void initIfNeeded() throws IOException {
    }

    public class ContainerUnsafe {
        public JsonElement get(String key) throws IOException {
            return CommonDataContainer.this.get(key);
        }

        public void set(String key, JsonElement value) throws IOException {
            CommonDataContainer.this.set(key, value);
        }

        public void create(String key, String root, JsonElement value) throws IOException {
            CommonDataContainer.this.create(key, root, value);
        }

        public boolean exists(String key) throws IOException {
            return CommonDataContainer.this.exists(key);
        }

        public void delete(String key) throws IOException {
            CommonDataContainer.this.delete(key);
        }

        public void deleteContainer(String root) throws IOException {
            CommonDataContainer.this.deleteContainer(root);
        }

        public String[] getEntryKeys(String key) throws IOException {
            return CommonDataContainer.this.getEntryKeys(key);
        }

        public String[] getChildContainers(String key) throws IOException {
            return CommonDataContainer.this.getChildContainers(key);
        }

        public JsonElement find(BiFunction<String, JsonElement, Boolean> function, String root) throws IOException {
            return CommonDataContainer.this.find(function, root);
        }

        public void runFor(BiFunction<String, JsonElement, Boolean> function, String root) throws IOException {
            CommonDataContainer.this.runFor(function, root);
        }

        public void runForChildren(Function<String, Boolean> function, String root) throws IOException {
            CommonDataContainer.this.runForChildren(function, root);
        }
    }

    private class ChildDataContainer
    extends CommonDataContainer {
        private boolean inited = false;

        public ChildDataContainer(String path, String name, CommonDataContainer parent) {
            this.path = path;
            this.parent = parent;
            this.name = name;
        }

        @Override
        protected void initIfNeeded() throws IOException {
            if (this.inited) {
                return;
            }
            this.inited = true;
            if (!this.exists("chholder")) {
                this.create("chholder", "", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            }
            this.parent.initIfNeeded();
        }

        @Override
        protected JsonElement get(String key) throws IOException {
            return this.parent.get(this.name + "/" + key);
        }

        @Override
        protected boolean exists(String key) throws IOException {
            return this.parent.exists(this.name + "/" + key);
        }

        @Override
        protected void set(String key, JsonElement value) throws IOException {
            this.parent.set(this.name + "/" + key, value);
            this.initIfNeeded();
        }

        @Override
        protected void create(String key, String root, JsonElement value) throws IOException {
            this.parent.create(this.name + "/" + key, this.name + (String)(root.isEmpty() ? "" : "/" + root), value);
            this.initIfNeeded();
        }

        @Override
        protected void delete(String key) throws IOException {
            this.parent.delete(this.name + "/" + key);
        }

        @Override
        protected String[] getEntryKeys(String key) throws IOException {
            return this.parent.getEntryKeys(this.name + (String)(key.isEmpty() ? "" : "/" + key));
        }

        @Override
        protected String[] getChildContainers(String key) throws IOException {
            return this.parent.getChildContainers(this.name + (String)(key.isEmpty() ? "" : "/" + key));
        }

        @Override
        protected void deleteContainer(String root) throws IOException {
            this.parent.deleteContainer(this.name + (String)(root.isEmpty() ? "" : "/" + root));
        }

        @Override
        protected JsonElement find(BiFunction<String, JsonElement, Boolean> function, String root) throws IOException {
            return this.parent.find(function, this.name + (String)(root.isEmpty() ? "" : "/" + root));
        }

        @Override
        protected void runFor(BiFunction<String, JsonElement, Boolean> function, String root) throws IOException {
            this.parent.runFor(function, this.name + (String)(root.isEmpty() ? "" : "/" + root));
        }

        @Override
        protected void runForChildren(Function<String, Boolean> function, String root) throws IOException {
            this.parent.runForChildren(function, this.name + (String)(root.isEmpty() ? "" : "/" + root));
        }
    }
}

