/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.globalserver;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.CommonUpdater;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.commonapi.EdgeCommonApiServer;
import org.asf.edge.commonapi.config.CommonApiServerConfig;
import org.asf.edge.commonapi.events.config.CommonApiServerConfigLoadedEvent;
import org.asf.edge.commonapi.events.config.CommonApiServerConfigPresetupEvent;
import org.asf.edge.contentserver.EdgeContentServer;
import org.asf.edge.contentserver.config.ContentServerConfig;
import org.asf.edge.contentserver.events.config.ContentServerConfigLoadedEvent;
import org.asf.edge.contentserver.events.config.ContentServerConfigPresetupEvent;
import org.asf.edge.gameplayapi.EdgeGameplayApiServer;
import org.asf.edge.gameplayapi.config.GameplayApiServerConfig;
import org.asf.edge.gameplayapi.events.config.GameplayApiServerConfigLoadedEvent;
import org.asf.edge.gameplayapi.events.config.GameplayApiServerConfigPresetupEvent;
import org.asf.edge.mmoserver.EdgeMMOServer;
import org.asf.edge.mmoserver.config.MMOServerConfig;
import org.asf.edge.mmoserver.events.config.MMOServerConfigLoadedEvent;
import org.asf.edge.mmoserver.events.config.MMOServerConfigPresetupEvent;
import org.asf.edge.modules.ModuleManager;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class EdgeGlobalServerMain {
    public static final String GLOBAL_SERVER_VERSION = "1.0.0.A2";

    public static void main(String[] args) throws IOException, URISyntaxException {
        boolean mmoSrvDisabled;
        boolean gapiDisabled;
        boolean capiDisabled;
        boolean contentDisabled;
        Locale.setDefault(Locale.ENGLISH);
        System.out.println("-------------------------------------------------------------");
        System.out.println("                                                             ");
        System.out.println("    EDGE - Fan-made server software for School of Dragons    ");
        System.out.println("                Full Server Version: 1.0.0.A2                ");
        System.out.println("                                                             ");
        System.out.println("-------------------------------------------------------------");
        System.out.println("");
        CommonInit.initAll();
        CommonUpdater.init((String)"globalserver", (String)"stable", (String)GLOBAL_SERVER_VERSION, (File)new File(EdgeGlobalServerMain.class.getProtectionDomain().getCodeSource().getLocation().toURI()));
        Logger logger = LogManager.getLogger((String)"FULLSERVER");
        logger.info("EDGE Global (full) server is starting!");
        logger.info("Content server version: 1.0.0.A2");
        logger.info("Common API version: 1.0.0.A2");
        logger.info("Gameplay API server version: 1.0.0.A2");
        logger.info("MMO server version: 1.0.0.A2");
        logger.info("Global server version: 1.0.0.A2");
        logger.info("Preparing to start...");
        ModuleManager.init();
        ContentServerConfig contentSrvConfig = new ContentServerConfig();
        EventBus.getInstance().dispatchEvent((EventObject)new ContentServerConfigPresetupEvent(contentSrvConfig));
        GameplayApiServerConfig gpApiConfig = new GameplayApiServerConfig();
        EventBus.getInstance().dispatchEvent((EventObject)new GameplayApiServerConfigPresetupEvent(gpApiConfig));
        CommonApiServerConfig cApiConfig = new CommonApiServerConfig();
        EventBus.getInstance().dispatchEvent((EventObject)new CommonApiServerConfigPresetupEvent(cApiConfig));
        MMOServerConfig mmoSrvConfig = new MMOServerConfig();
        EventBus.getInstance().dispatchEvent((EventObject)new MMOServerConfigPresetupEvent(mmoSrvConfig));
        logger.info("Loading server configuration...");
        File configFile = new File("server.json");
        if (!configFile.exists()) {
            logger.debug("Creating server configuration...");
            Files.writeString(configFile.toPath(), (CharSequence)"{\n\n    \"contentServer\": {\n        \"disabled\": false,\n        \"listenAddress\": \"0.0.0.0\",\n        \"listenPort\": 5319,\n        \"contentRequestListenPath\": \"/\",\n        \"contentDataPath\": \"./data/contentserver/asset-data\",\n        \"allowIndexingAssets\": true,\n\n        \"serverTestEndpoint\": null,\n        \"fallbackAssetServerEndpoint\": null,\n        \"fallbackAssetServerManifestModifications\": {},\n\n        \"storeFallbackAssetDownloads\": false,\n        \"https\": false,\n        \"tlsKeystore\": null,\n        \"tlsKeystorePassword\": null\n    },\n\n    \"gameplayApiServer\": {\n        \"disabled\": false,\n        \"listenAddress\": \"0.0.0.0\",\n        \"listenPort\": 5320,\n        \"apiRequestListenPath\": \"/\",\n\n        \"https\": false,\n        \"tlsKeystore\": null,\n        \"tlsKeystorePassword\": null\n    },\n\n    \"commonApiServer\": {\n        \"disabled\": false,\n        \"listenAddress\": \"0.0.0.0\",\n        \"listenPort\": 5321,\n        \"apiRequestListenPath\": \"/\",\n\n        \"https\": false,\n        \"tlsKeystore\": null,\n        \"tlsKeystorePassword\": null,\n\n        \"internalListenAddress\": \"127.0.0.1\",\n        \"internalListenPort\": 5324,\n\n        \"httpsInternal\": false,\n        \"tlsKeystoreInternal\": null,\n        \"tlsKeystorePasswordInternal\": null\n    },\n\n    \"mmoServer\": {\n        \"disabled\": false,\n        \"listenAddress\": \"0.0.0.0\",\n        \"listenPort\": 5323,\n\n        \"discoveryAddress\": \"localhost\",\n        \"discoveryPort\": 5323,\n\n        \"commonApiUplinkURL\": \"http://127.0.0.1:5324/\"\n    },\n\n    \"modules\": {\n    }\n\n}", new OpenOption[0]);
        }
        logger.debug("Loading configuration file server.json...");
        JsonObject configData = JsonParser.parseString((String)Files.readString(configFile.toPath())).getAsJsonObject();
        logger.debug("Configuring content server settings...");
        JsonObject contentSrvJson = configData.get("contentServer").getAsJsonObject();
        boolean bl = contentDisabled = contentSrvJson.has("disabled") && contentSrvJson.get("disabled").getAsBoolean();
        if (!contentDisabled) {
            if (contentSrvConfig.server == null) {
                logger.debug("Loading listening settings...");
                contentSrvConfig.listenAddress = contentSrvJson.get("listenAddress").getAsString();
                contentSrvConfig.listenPort = contentSrvJson.get("listenPort").getAsInt();
            }
            logger.debug("Loading IO settings...");
            if (contentSrvJson.has("serverTestEndpoint") && !contentSrvJson.get("serverTestEndpoint").isJsonNull()) {
                contentSrvConfig.serverTestEndpoint = contentSrvJson.get("serverTestEndpoint").getAsString();
            }
            if (contentSrvJson.has("fallbackAssetServerEndpoint") && !contentSrvJson.get("fallbackAssetServerEndpoint").isJsonNull()) {
                contentSrvConfig.fallbackAssetServerEndpoint = contentSrvJson.get("fallbackAssetServerEndpoint").getAsString();
            }
            if (contentSrvJson.has("fallbackAssetServerManifestModifications") && !contentSrvJson.get("fallbackAssetServerManifestModifications").isJsonNull()) {
                contentSrvConfig.fallbackAssetServerManifestModifications = contentSrvJson.get("fallbackAssetServerManifestModifications").getAsJsonObject();
            }
            if (contentSrvJson.has("storeFallbackAssetDownloads")) {
                contentSrvConfig.storeFallbackAssetDownloads = contentSrvJson.get("storeFallbackAssetDownloads").getAsBoolean();
            }
            contentSrvConfig.contentRequestListenPath = contentSrvJson.get("contentRequestListenPath").getAsString();
            contentSrvConfig.contentDataPath = contentSrvJson.get("contentDataPath").getAsString();
            contentSrvConfig.allowIndexingAssets = contentSrvJson.get("allowIndexingAssets").getAsBoolean();
            if (contentSrvConfig.server == null) {
                logger.debug("Loading encryption settings...");
                contentSrvConfig.https = contentSrvJson.get("https").getAsBoolean();
                if (contentSrvConfig.https) {
                    contentSrvConfig.tlsKeystore = contentSrvJson.get("tlsKeystore").getAsString();
                    contentSrvConfig.tlsKeystorePassword = contentSrvJson.get("tlsKeystorePassword").getAsString();
                }
            }
        }
        logger.debug("Configuring Common API server settings...");
        JsonObject cApiJson = configData.get("commonApiServer").getAsJsonObject();
        boolean bl2 = capiDisabled = cApiJson.has("disabled") && cApiJson.get("disabled").getAsBoolean();
        if (!capiDisabled) {
            if (cApiConfig.server == null) {
                logger.debug("Loading listening settings...");
                cApiConfig.listenAddress = cApiJson.get("listenAddress").getAsString();
                cApiConfig.listenPort = cApiJson.get("listenPort").getAsInt();
            }
            logger.debug("Loading IO settings...");
            cApiConfig.apiRequestListenPath = cApiJson.get("apiRequestListenPath").getAsString();
            if (cApiConfig.server == null) {
                logger.debug("Loading encryption settings...");
                cApiConfig.https = cApiJson.get("https").getAsBoolean();
                if (cApiConfig.https) {
                    cApiConfig.tlsKeystore = cApiJson.get("tlsKeystore").getAsString();
                    cApiConfig.tlsKeystorePassword = cApiJson.get("tlsKeystorePassword").getAsString();
                }
            }
            logger.debug("Loading internal server settings...");
            if (cApiConfig.internalServer == null) {
                logger.debug("Loading listening settings...");
                cApiConfig.internalListenAddress = cApiJson.get("internalListenAddress").getAsString();
                cApiConfig.internalListenPort = cApiJson.get("internalListenPort").getAsInt();
            }
            if (cApiConfig.internalServer == null) {
                logger.debug("Loading encryption settings...");
                cApiConfig.httpsInternal = cApiJson.get("httpsInternal").getAsBoolean();
                if (cApiConfig.httpsInternal) {
                    cApiConfig.tlsKeystoreInternal = cApiJson.get("tlsKeystoreInternal").getAsString();
                    cApiConfig.tlsKeystorePasswordInternal = cApiJson.get("tlsKeystorePasswordInternal").getAsString();
                }
            }
        }
        logger.debug("Configuring Gameplay API server settings...");
        JsonObject gpApiJson = configData.get("gameplayApiServer").getAsJsonObject();
        boolean bl3 = gapiDisabled = gpApiJson.has("disabled") && gpApiJson.get("disabled").getAsBoolean();
        if (!gapiDisabled) {
            if (gpApiConfig.server == null) {
                logger.debug("Loading listening settings...");
                gpApiConfig.listenAddress = gpApiJson.get("listenAddress").getAsString();
                gpApiConfig.listenPort = gpApiJson.get("listenPort").getAsInt();
            }
            logger.debug("Loading IO settings...");
            gpApiConfig.apiRequestListenPath = gpApiJson.get("apiRequestListenPath").getAsString();
            if (gpApiConfig.server == null) {
                logger.debug("Loading encryption settings...");
                gpApiConfig.https = gpApiJson.get("https").getAsBoolean();
                if (gpApiConfig.https) {
                    gpApiConfig.tlsKeystore = gpApiJson.get("tlsKeystore").getAsString();
                    gpApiConfig.tlsKeystorePassword = gpApiJson.get("tlsKeystorePassword").getAsString();
                }
            }
        }
        logger.debug("Configuring MMO server settings...");
        JsonObject mmoSrvJson = configData.get("mmoServer").getAsJsonObject();
        boolean bl4 = mmoSrvDisabled = mmoSrvJson.has("disabled") && mmoSrvJson.get("disabled").getAsBoolean();
        if (!mmoSrvDisabled) {
            if (mmoSrvConfig.server == null) {
                logger.debug("Loading listening settings...");
                mmoSrvConfig.listenAddress = mmoSrvJson.get("listenAddress").getAsString();
                mmoSrvConfig.listenPort = mmoSrvJson.get("listenPort").getAsInt();
            }
            logger.debug("Loading discovery settings...");
            mmoSrvConfig.discoveryAddress = mmoSrvJson.get("discoveryAddress").getAsString();
            mmoSrvConfig.discoveryPort = mmoSrvJson.get("discoveryPort").getAsInt();
            mmoSrvConfig.commonApiUplinkURL = mmoSrvJson.get("commonApiUplinkURL").getAsString();
        }
        if (configData.has("modules")) {
            logger.debug("Loading module configurations...");
            JsonObject moduleSettings = configData.get("modules").getAsJsonObject();
            for (String id : moduleSettings.keySet()) {
                JsonObject conf = moduleSettings.get(id).getAsJsonObject();
                LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
                for (String key : conf.keySet()) {
                    mp.put(key, conf.get(key).getAsString());
                }
                ModuleManager.loadedModuleConfig((String)id, mp);
            }
        }
        if (!contentDisabled) {
            EventBus.getInstance().dispatchEvent((EventObject)new ContentServerConfigLoadedEvent(contentSrvConfig));
        }
        if (!capiDisabled) {
            EventBus.getInstance().dispatchEvent((EventObject)new GameplayApiServerConfigLoadedEvent(gpApiConfig));
        }
        if (!gapiDisabled) {
            EventBus.getInstance().dispatchEvent((EventObject)new CommonApiServerConfigLoadedEvent(cApiConfig));
        }
        if (!mmoSrvDisabled) {
            EventBus.getInstance().dispatchEvent((EventObject)new MMOServerConfigLoadedEvent(mmoSrvConfig));
        }
        logger.info("Setting up servers...");
        logger.debug("Loading common data manager implementations...");
        CommonDataManager.initCommonDataManagerServices((int)-10, (int)0, (int)-5);
        logger.debug("Selecting common data manager implementation...");
        ServiceManager.selectServiceImplementation(CommonDataManager.class);
        logger.debug("Loading common data manager...");
        CommonDataManager.getInstance().loadManager();
        logger.debug("Loading account manager implementations...");
        AccountManager.initAccountManagerServices((int)-10, (int)0, (int)-5);
        logger.debug("Selecting account manager implementation...");
        ServiceManager.selectServiceImplementation(AccountManager.class);
        logger.debug("Loading account manager...");
        AccountManager.getInstance().loadManager();
        EdgeContentServer contSrv = null;
        if (!contentDisabled) {
            logger.info("Setting up the content server...");
            contSrv = new EdgeContentServer(contentSrvConfig);
            contSrv.setupServer();
        }
        EdgeCommonApiServer cApiSrv = null;
        if (!capiDisabled) {
            logger.info("Setting up the Common API server...");
            cApiSrv = new EdgeCommonApiServer(cApiConfig);
            cApiSrv.setupServer();
        }
        EdgeGameplayApiServer gpApiSrv = null;
        if (!gapiDisabled) {
            logger.info("Setting up the Gameplay API server...");
            gpApiSrv = new EdgeGameplayApiServer(gpApiConfig);
            gpApiSrv.setupServer();
        }
        EdgeMMOServer mmoSrv = null;
        if (!mmoSrvDisabled) {
            logger.info("Setting up the MMO server...");
            mmoSrv = new EdgeMMOServer(mmoSrvConfig);
            mmoSrv.setupServer();
        }
        if (!contentDisabled) {
            contSrv.startServer();
        }
        if (!capiDisabled) {
            cApiSrv.startServer();
        }
        if (!gapiDisabled) {
            gpApiSrv.startServer();
        }
        if (!mmoSrvDisabled) {
            mmoSrv.startServer();
        }
        ModuleManager.runModulePostInit();
        logger.info("EDGE servers are running!");
        if (!capiDisabled) {
            cApiSrv.waitForExit();
        }
        if (!gapiDisabled) {
            gpApiSrv.waitForExit();
        }
        if (!mmoSrvDisabled) {
            mmoSrv.waitForExit();
        }
        if (CommonInit.restartPending) {
            System.exit(237);
        } else {
            System.exit(0);
        }
    }
}

