/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.mmoserver.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.asf.edge.mmoserver.networking.sfs.SmartfoxNetworkObjectUtil;

public class SnifferViewer {
    private JFrame frmEdgeSnifferLog;
    private ArrayList<SnifferDataBlock> sniffData = new ArrayList();
    private FileInputStream lastSniffData = null;
    private JScrollPane scrollPane_1;
    private JTextPane textRequestInfo;
    private JList<SnifferDataBlock> list;
    private JTextField searchBox;

    public static void main(String[] args) {
        try {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e1) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SnifferViewer window = new SnifferViewer();
                    window.frmEdgeSnifferLog.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public SnifferViewer() {
        this.initialize();
    }

    private void initialize() {
        this.frmEdgeSnifferLog = new JFrame();
        this.frmEdgeSnifferLog.setTitle("EDGE Sniffer Log Viewer");
        this.frmEdgeSnifferLog.setBounds(100, 100, 1003, 670);
        this.frmEdgeSnifferLog.setDefaultCloseOperation(3);
        this.frmEdgeSnifferLog.setLocationRelativeTo(null);
        JPanel panel = new JPanel();
        panel.setBorder(new BevelBorder(1, null, null, null, null));
        panel.setPreferredSize(new Dimension(350, 10));
        this.frmEdgeSnifferLog.getContentPane().add((Component)panel, "West");
        panel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(new BevelBorder(1, null, null, null, null));
        scrollPane.setVerticalScrollBarPolicy(22);
        panel.add((Component)scrollPane, "Center");
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SnifferViewer.this.setSelectedBlock(SnifferViewer.this.list.getSelectedValue());
            }
        });
        scrollPane.setViewportView(this.list);
        JPanel panel_3 = new JPanel();
        panel_3.setBorder(new BevelBorder(1, null, null, null, null));
        panel.add((Component)panel_3, "South");
        JButton btnNewButton = new JButton("Load file...");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileDialog chooser = new FileDialog((Frame)SnifferViewer.this.frmEdgeSnifferLog, "Open log file", 0);
                chooser.setFilenameFilter((dir, name) -> name.endsWith(".log") || new File(dir, name).isDirectory());
                chooser.setMultipleMode(false);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    SnifferViewer.this.loadSniffFile(chooser.getFiles()[0]);
                }
            }
        });
        panel_3.add(btnNewButton);
        JPanel panel_7 = new JPanel();
        panel_7.setBorder(new BevelBorder(1, null, null, null, null));
        panel.add((Component)panel_7, "North");
        panel_7.setLayout(new BorderLayout(0, 0));
        JLabel lblNewLabel = new JLabel("Packets");
        panel_7.add((Component)lblNewLabel, "North");
        this.searchBox = new JTextField();
        this.searchBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SnifferViewer.this.updateList();
            }
        });
        panel_7.add((Component)this.searchBox, "South");
        this.searchBox.setColumns(10);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new BevelBorder(1, null, null, null, null));
        this.frmEdgeSnifferLog.getContentPane().add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panelSniff = new JPanel();
        panelSniff.setBorder(new BevelBorder(1, null, null, null, null));
        panelSniff.setLayout(new BorderLayout(0, 0));
        panel_1.add((Component)panelSniff, "Center");
        this.scrollPane_1 = new JScrollPane();
        this.scrollPane_1.setBorder(new BevelBorder(1, null, null, null, null));
        this.scrollPane_1.setVerticalScrollBarPolicy(22);
        panelSniff.add((Component)this.scrollPane_1, "Center");
        this.textRequestInfo = new JTextPane();
        this.textRequestInfo.setEditable(false);
        this.scrollPane_1.setViewportView(this.textRequestInfo);
    }

    private void loadSniffFile(File file) {
        Object buffer;
        this.searchBox.setText("");
        boolean validFile = true;
        FileInputStream sourceFile = null;
        try {
            sourceFile = new FileInputStream(file);
            try {
                int b;
                buffer = "";
                boolean inBlock = false;
                while ((b = sourceFile.read()) != -1) {
                    byte bb = (byte)b;
                    char ch = (char)bb;
                    if (ch == '\r') continue;
                    if (!inBlock) {
                        if (ch == '\n') continue;
                        if (ch == '{') {
                            inBlock = true;
                        } else {
                            throw new IOException("Invalid file");
                        }
                    }
                    if (ch == '\n') {
                        JsonObject obj = JsonParser.parseString((String)buffer).getAsJsonObject();
                        buffer = "";
                        if (obj.has("time") && obj.has("host") && obj.has("port") && obj.has("side") && obj.has("data") || !obj.has("type") || obj.get("type").getAsString().equals("http")) break;
                        throw new IOException("Invalid file");
                    }
                    buffer = (String)buffer + ch;
                }
                sourceFile.getChannel().position(0L);
            }
            catch (Exception e) {
                try {
                    sourceFile.close();
                }
                catch (IOException inBlock) {
                    // empty catch block
                }
                throw e;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frmEdgeSnifferLog, "The file you selected is not a valid packet recording file.", "Error", 0);
            if (sourceFile != null) {
                try {
                    sourceFile.close();
                }
                catch (IOException inBlock) {
                    // empty catch block
                }
            }
            return;
        }
        if (!validFile) {
            JOptionPane.showMessageDialog(this.frmEdgeSnifferLog, "The file you selected is not a valid packet recording file.", "Error", 0);
            if (sourceFile != null) {
                try {
                    sourceFile.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return;
        }
        this.sniffData.clear();
        if (this.lastSniffData != null) {
            try {
                this.lastSniffData.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.lastSniffData = sourceFile;
        try {
            int b;
            buffer = "";
            while ((b = sourceFile.read()) != -1) {
                byte bb = (byte)b;
                char ch = (char)bb;
                if (ch == '\r' || ch == '\n') continue;
                if (ch == '{') {
                    JsonObject obj;
                    byte[] bufferD;
                    int read;
                    buffer = Character.toString(ch);
                    while ((read = sourceFile.read(bufferD = new byte[20480])) > 0) {
                        String bData = new String(bufferD, "UTF-8");
                        if (bData.contains("\n")) {
                            buffer = (String)buffer + bData.substring(0, bData.indexOf("\n"));
                            sourceFile.getChannel().position(sourceFile.getChannel().position() - (long)(read - bData.indexOf("\n")));
                            break;
                        }
                        buffer = (String)buffer + bData;
                    }
                    if (!((obj = JsonParser.parseString((String)buffer).getAsJsonObject()).has("time") && obj.has("host") && obj.has("port") && obj.has("side") && obj.has("data") || !obj.has("type") || obj.get("type").getAsString().equals("http"))) {
                        throw new IOException("Invalid file");
                    }
                    if (obj.has("type") && !obj.get("type").getAsString().equals("bstcp") && !obj.get("type").getAsString().equals("udp")) continue;
                    SnifferDataBlock block = new SnifferDataBlock();
                    block.type = obj.get("type").getAsString().equals("udp") ? "UDP" : "TCP";
                    block.host = obj.get("host").getAsString();
                    block.port = obj.get("port").getAsInt();
                    block.side = obj.get("side").getAsString();
                    block.time = obj.get("time").getAsLong();
                    block.data = Base64.getDecoder().decode(obj.get("data").getAsString());
                    this.sniffData.add(block);
                    continue;
                }
                throw new IOException("Invalid file");
            }
            sourceFile.getChannel().position(0L);
        }
        catch (Exception e) {
            Object stackTrace = "";
            for (StackTraceElement ele : e.getStackTrace()) {
                stackTrace = (String)stackTrace + "\n    at: " + ele;
            }
            JOptionPane.showMessageDialog(this.frmEdgeSnifferLog, "An error occured while loading the packet log file: " + e.getClass().getTypeName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : "") + "\n" + (String)stackTrace, "Error", 0);
        }
        this.updateList();
    }

    private void updateList() {
        final ArrayList<SnifferDataBlock> filteredData = new ArrayList<SnifferDataBlock>();
        for (SnifferDataBlock block : this.sniffData) {
            String filter = this.searchBox.getText();
            if ((filter = filter.trim()).isEmpty()) {
                filteredData.add(block);
                continue;
            }
            if (!block.dataString().toLowerCase().contains(filter.toLowerCase())) continue;
            filteredData.add(block);
        }
        this.list.setModel(new ListModel<SnifferDataBlock>(){

            @Override
            public int getSize() {
                return filteredData.size();
            }

            @Override
            public SnifferDataBlock getElementAt(int index) {
                return (SnifferDataBlock)filteredData.get(index);
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
        this.list.repaint();
        this.list.setSelectedValue(null, false);
        this.setSelectedBlock(null);
    }

    private void setSelectedBlock(SnifferDataBlock block) {
        this.textRequestInfo.setText("");
        if (block != null) {
            this.textRequestInfo.setText("Decoding from disk...");
            this.textRequestInfo.updateUI();
            SwingUtilities.invokeLater(() -> this.scrollPane_1.getViewport().setViewPosition(new Point(0, 0)));
            SwingUtilities.invokeLater(() -> {
                this.textRequestInfo.setText(block.dataString());
                this.scrollPane_1.updateUI();
                SwingUtilities.invokeLater(() -> this.scrollPane_1.getViewport().setViewPosition(new Point(0, 0)));
            });
        } else {
            this.scrollPane_1.updateUI();
            SwingUtilities.invokeLater(() -> this.scrollPane_1.getViewport().setViewPosition(new Point(0, 0)));
        }
    }

    public Map<String, String> parseForm(String payload) {
        HashMap<String, String> frm = new HashMap<String, String>();
        Object key = "";
        Object value = "";
        boolean isKey = true;
        for (int i = 0; i < payload.length(); ++i) {
            char ch = payload.charAt(i);
            if (ch == '&') {
                if (isKey && !((String)key).isEmpty()) {
                    frm.put((String)key, "");
                    key = "";
                    continue;
                }
                if (isKey || ((String)key).isEmpty()) continue;
                try {
                    frm.put((String)key, URLDecoder.decode((String)value, "UTF-8"));
                }
                catch (Exception e) {
                    frm.put((String)key, (String)value);
                }
                isKey = true;
                key = "";
                value = "";
                continue;
            }
            if (ch == '=') {
                isKey = !isKey;
                continue;
            }
            if (isKey) {
                key = (String)key + ch;
                continue;
            }
            value = (String)value + ch;
        }
        if (!((String)key).isEmpty() || !((String)value).isEmpty()) {
            try {
                frm.put((String)key, URLDecoder.decode((String)value, "UTF-8"));
            }
            catch (Exception e) {
                frm.put((String)key, (String)value);
            }
        }
        return frm;
    }

    private class SnifferDataBlock {
        public String type;
        public String host;
        public int port;
        public String side;
        public long time;
        public byte[] data;
        private String srStr;
        private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

        private SnifferDataBlock() {
        }

        public String dataString() {
            if (this.srStr != null) {
                return this.srStr;
            }
            this.srStr = "Host: " + this.host + "\n";
            this.srStr = this.srStr + "Port: " + this.port + "\n";
            this.srStr = this.srStr + "Side: " + this.side + "\n";
            this.srStr = this.srStr + "Type: " + this.type + "\n";
            this.srStr = this.srStr + "\n";
            try {
                this.srStr = this.srStr + new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(SmartfoxNetworkObjectUtil.parseSfsObject(this.data));
            }
            catch (IOException e) {
                this.srStr = this.srStr + SnifferDataBlock.bytesToHex(this.data);
            }
            return this.srStr;
        }

        public static String bytesToHex(byte[] bytes) {
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 2] = HEX_ARRAY[v >>> 4];
                hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            }
            return new String(hexChars);
        }

        public String toString() {
            String str = "[" + this.type + "] ";
            str = str + this.side + ": ";
            str = str + new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(this.time));
            str = str + " ([" + this.host + "]:" + this.port + ")";
            return str;
        }
    }
}

