/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.contentserver.http.postprocessors;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.asf.connective.RemoteClient;
import org.asf.connective.objects.HttpRequest;
import org.asf.connective.objects.HttpResponse;
import org.asf.edge.contentserver.config.ContentServerConfig;
import org.asf.edge.contentserver.http.ContentServerRequestHandler;

public class ServerDownPreprocessor
implements ContentServerRequestHandler.IPreProcessor {
    private ContentServerConfig config;

    public ServerDownPreprocessor(ContentServerConfig config) {
        this.config = config;
    }

    @Override
    public boolean match(String path, String method, RemoteClient client, String contentType, HttpRequest request, HttpResponse response, File sourceDir) {
        return path.endsWith("/ServerDown.xml");
    }

    @Override
    public InputStream preProcess(String path, String method, RemoteClient client, String contentType, HttpRequest request, HttpResponse response, InputStream source, File sourceDir) throws IOException {
        ObjectNode node;
        XmlMapper mapper;
        String data;
        byte[] docData;
        if (this.config.serverTestEndpoint != null) {
            docData = source.readAllBytes();
            source.close();
            data = new String(docData, "UTF-8");
            mapper = new XmlMapper();
            mapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
            node = (ObjectNode)mapper.readValue(docData, ObjectNode.class);
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL(this.config.serverTestEndpoint).openConnection();
                int code = conn.getResponseCode();
                if (code != 200 && code != 404) {
                    throw new IOException();
                }
            }
            catch (Exception e) {
                node.set("Down", (JsonNode)BooleanNode.TRUE);
                data = mapper.writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("ServerDown").writeValueAsString((Object)node);
            }
            source = new ByteArrayInputStream(data.getBytes("UTF-8"));
        }
        try {
            JsonNode scheduled;
            docData = source.readAllBytes();
            source.close();
            data = new String(docData, "UTF-8");
            mapper = new XmlMapper();
            mapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
            node = (ObjectNode)mapper.readValue(docData, ObjectNode.class);
            if (node.has("Scheduled") && (scheduled = node.get("Scheduled")).has("EdgeStartTime")) {
                String startTime = scheduled.get("EdgeStartTime").asText();
                String endTime = null;
                if (scheduled.has("EdgeEndTime")) {
                    endTime = scheduled.get("EdgeEndTime").asText();
                }
                long end = -1L;
                long start = -1L;
                SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy HH:mm");
                fmt.setTimeZone(TimeZone.getTimeZone("PST"));
                start = fmt.parse(startTime).getTime();
                if (fmt.getTimeZone().inDaylightTime(new Date(start))) {
                    start += 3600000L;
                }
                if (endTime != null) {
                    end = fmt.parse(endTime).getTime();
                    if (fmt.getTimeZone().inDaylightTime(new Date(end))) {
                        end += 3600000L;
                    }
                }
                if (System.currentTimeMillis() >= start && (end == -1L || System.currentTimeMillis() < end)) {
                    node.set("Down", (JsonNode)BooleanNode.TRUE);
                    data = mapper.writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("ServerDown").writeValueAsString((Object)node);
                }
            }
            source = new ByteArrayInputStream(data.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return source;
    }
}

