/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.items.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.asf.edge.common.entities.achivements.RankMultiplierInfo;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.entities.items.PlayerInventoryContainer;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.events.items.InventoryItemDeleteEvent;
import org.asf.edge.common.events.items.InventoryItemQuantityUpdateEvent;
import org.asf.edge.common.events.items.InventoryItemUsesUpdateEvent;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class PlayerInventoryItemImpl
extends PlayerInventoryItem {
    private AccountDataContainer data;
    private AccountObject account;
    private PlayerInventory inv;
    private PlayerInventoryContainer cont;
    private long lastUpdate = System.currentTimeMillis();
    private int defID;
    private int uniqueID;
    private int quantity;
    private int uses;

    public PlayerInventoryItemImpl(AccountDataContainer data, int uniqueID, int defID, int quantity, int uses, AccountObject account, PlayerInventory inv, PlayerInventoryContainer cont) {
        this.data = data;
        this.defID = defID;
        this.uniqueID = uniqueID;
        this.quantity = quantity;
        this.uses = uses;
        this.account = account;
        this.inv = inv;
        this.cont = cont;
    }

    private void updateInfo() {
        try {
            if (System.currentTimeMillis() < this.lastUpdate + 10000L) {
                return;
            }
            this.lastUpdate = System.currentTimeMillis();
            JsonElement ele = this.data.getChildContainer("d-" + this.defID).getEntry("u-" + this.uniqueID);
            if (ele == null) {
                return;
            }
            JsonObject itm = ele.getAsJsonObject();
            this.quantity = itm.get("quantity").getAsInt();
            this.uses = itm.get("uses").getAsInt();
        }
        catch (IOException e) {
            LogManager.getLogger((String)"ItemManager").error("Failed to refresh data of inventory item " + this.uniqueID, (Throwable)e);
        }
    }

    private void writeUpdate() {
        try {
            JsonObject itm = new JsonObject();
            itm.addProperty("quantity", (Number)this.quantity);
            itm.addProperty("uses", (Number)this.uses);
            this.data.getChildContainer("d-" + this.defID).setEntry("u-" + this.uniqueID, (JsonElement)itm);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void runItem() {
        if (this.getItemDef().hasAttribute("RewardMultiplier") && this.getItemDef().getAttribute("RewardMultiplier").getValue().asText().equalsIgnoreCase("true") && this.data.getSave() != null) {
            int factor = this.getItemDef().getAttribute("MultiplierFactor").getValue().asInt();
            int rewardType = this.getItemDef().getAttribute("MultiplierRewardType").getValue().asInt();
            int effectTime = this.getItemDef().getAttribute("MultiplierEffectTime").getValue().asInt();
            AchievementManager.getInstance().addUserRankMultiplier(this.data.getSave(), new RankMultiplierInfo(RankTypeID.getByTypeID(rewardType), factor, System.currentTimeMillis() + (long)(effectTime * 1000)));
        } else {
            LogManager.getLogger((String)"ItemManager").warn("Item " + this.getItemDefID() + " was used but no known methods of item data execution were possible!");
        }
    }

    @Override
    public int getUniqueID() {
        this.updateInfo();
        return this.uniqueID;
    }

    @Override
    public int getItemDefID() {
        this.updateInfo();
        return this.defID;
    }

    @Override
    public int getUses() {
        this.updateInfo();
        return this.uses;
    }

    @Override
    public int getQuantity() {
        this.updateInfo();
        return this.quantity;
    }

    @Override
    public void setQuantity(int quantity) {
        int oldQuant = this.quantity;
        this.quantity = quantity;
        if (this.quantity <= 0) {
            this.delete();
        } else {
            EventBus.getInstance().dispatchEvent((EventObject)new InventoryItemQuantityUpdateEvent(this, this.account, this.data, this.inv, this.cont, oldQuant, quantity));
            this.writeUpdate();
        }
    }

    @Override
    public void setUses(int uses) {
        int oldUses = this.uses;
        this.uses = uses;
        EventBus.getInstance().dispatchEvent((EventObject)new InventoryItemUsesUpdateEvent(this, this.account, this.data, this.inv, this.cont, oldUses, uses));
        this.writeUpdate();
    }

    @Override
    public boolean useItem(int uses) {
        int usesLeft = this.getUses();
        if (usesLeft == -1) {
            usesLeft = 1;
        }
        if (uses > usesLeft) {
            return false;
        }
        for (int i = 0; i < uses; ++i) {
            this.runItem();
            if (--usesLeft > 0) continue;
            this.remove(1);
            if (this.quantity <= 0) break;
        }
        return true;
    }

    @Override
    public void delete() {
        try {
            AccountDataContainer cont = this.data.getChildContainer("d-" + this.defID);
            cont.deleteEntry("u-" + this.uniqueID);
            if (Stream.of(cont.getEntryKeys()).filter(t -> t.startsWith("u-")).count() <= 0L) {
                cont.deleteContainer();
            }
            this.data.deleteEntry("u-" + this.uniqueID);
            EventBus.getInstance().dispatchEvent((EventObject)new InventoryItemDeleteEvent(this, this.account, this.data, this.inv, this.cont));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

