/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.events.achievements;

import org.asf.edge.common.entities.achivements.EntityRankInfo;
import org.asf.edge.common.entities.achivements.RankInfo;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.modules.eventbus.EventObject;
import org.asf.edge.modules.eventbus.EventPath;

@EventPath(value="achievements.ranks.changed")
public class RankChangedEvent
extends EventObject {
    private AchievementManager achievementManager;
    private AccountSaveContainer save;
    private EntityRankInfo rankInfo;
    private RankInfo lastRank;
    private RankInfo newRank;
    private int lastTotalScore;
    private int newTotalScore;

    public RankChangedEvent(AchievementManager achievementManager, AccountSaveContainer save, EntityRankInfo rankInfo, RankInfo lastRank, RankInfo newRank, int lastScore, int newScore) {
        this.achievementManager = achievementManager;
        this.save = save;
        this.rankInfo = rankInfo;
        this.lastRank = lastRank;
        this.newRank = newRank;
        this.lastTotalScore = lastScore;
        this.newTotalScore = newScore;
    }

    public String eventPath() {
        return "achievements.ranks.changed";
    }

    public AchievementManager getAchievementManager() {
        return this.achievementManager;
    }

    public AccountSaveContainer getSave() {
        return this.save;
    }

    public AccountObject getAccount() {
        return this.save.getAccount();
    }

    public EntityRankInfo getEntityRank() {
        return this.rankInfo;
    }

    public boolean hasRankChanged() {
        if (this.lastRank == null && this.newRank == null) {
            return false;
        }
        if (this.lastRank == null && this.newRank != null) {
            return true;
        }
        if (this.lastRank != null && this.newRank == null) {
            return true;
        }
        return this.lastRank.getID() != this.newRank.getID();
    }

    public RankInfo getLastRank() {
        return this.lastRank;
    }

    public RankInfo getNewRank() {
        return this.newRank;
    }

    public int getLastTotalScore() {
        return this.lastTotalScore;
    }

    public int getNewTotalScore() {
        return this.newTotalScore;
    }
}

